/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;
    private final Map<String, Set<String>> noTileHeaders;
    private final Map<String, Set<String>> noTileChecksums;
    private final Map<String, String> metadataHeaders;
    protected int tileSize;

    public AbstractTMSTileSource(TileSourceInfo info) {
        this.name = info.getName();
        this.baseUrl = info.getUrl();
        if (this.baseUrl != null && this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = info.getUrl();
        this.noTileHeaders = info.getNoTileHeaders();
        this.noTileChecksums = info.getNoTileChecksums();
        this.metadataHeaders = info.getMetadataHeaders();
        this.tileSize = info.getTileSize();
    }

    @Override
    public int getDefaultTileSize() {
        return OsmMercator.DEFAUL_TILE_SIZE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        return "/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int getTileSize() {
        if (this.tileSize <= 0) {
            return this.getDefaultTileSize();
        }
        return this.tileSize;
    }

    @Override
    public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public int getTileXMax(int zoom) {
        return AbstractTMSTileSource.getTileMax(zoom);
    }

    @Override
    public int getTileXMin(int zoom) {
        return 0;
    }

    @Override
    public int getTileYMax(int zoom) {
        return AbstractTMSTileSource.getTileMax(zoom);
    }

    @Override
    public int getTileYMin(int zoom) {
        return 0;
    }

    @Override
    public boolean isNoTileAtZoom(Map<String, List<String>> headers, int statusCode, byte[] content) {
        if (this.noTileHeaders != null && headers != null) {
            for (Map.Entry<String, Set<String>> searchEntry : this.noTileHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    for (String val : searchEntry.getValue()) {
                        if (!headerValue.matches(val)) continue;
                        return true;
                    }
                }
            }
        }
        if (this.noTileChecksums != null && content != null) {
            for (Map.Entry<String, Set<String>> searchEntry : this.noTileChecksums.entrySet()) {
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance(searchEntry.getKey());
                }
                catch (NoSuchAlgorithmException e) {
                    break;
                }
                byte[] byteDigest = md.digest(content);
                int len = byteDigest.length;
                char[] hexChars = new char[len * 2];
                int j = 0;
                for (int i = 0; i < len; ++i) {
                    byte v = byteDigest[i];
                    int vn = (v & 0xF0) >> 4;
                    hexChars[j++] = (char)(vn + (vn >= 10 ? 87 : 48));
                    vn = v & 0xF;
                    hexChars[j++] = (char)(vn + (vn >= 10 ? 87 : 48));
                }
                for (String val : searchEntry.getValue()) {
                    if (!new String(hexChars).equalsIgnoreCase(val)) continue;
                    return true;
                }
            }
        }
        return super.isNoTileAtZoom(headers, statusCode, content);
    }

    @Override
    public Map<String, String> getMetadata(Map<String, List<String>> headers) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.metadataHeaders != null && headers != null) {
            for (Map.Entry<String, String> searchEntry : this.metadataHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    ret.put(searchEntry.getValue(), headerValue);
                }
            }
        }
        return ret;
    }

    @Override
    public String getTileId(int zoom, int tilex, int tiley) {
        return this.baseUrl + "/" + zoom + "/" + tilex + "/" + tiley;
    }

    private static int getTileMax(int zoom) {
        return (int)Math.pow(2.0, zoom) - 1;
    }
}

