/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.UIManager;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Style;

public abstract class MapObjectImpl {
    private Layer layer;
    private String name;
    private Style style;
    private Boolean visible;

    public MapObjectImpl(String name) {
        this(null, name, null);
    }

    public MapObjectImpl(Layer layer) {
        this(layer, null, null);
    }

    public MapObjectImpl(Layer layer, String name, Style style) {
        this.layer = layer;
        this.name = name;
        this.style = style;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public Style getStyle() {
        return this.style;
    }

    public Style getStyleAssigned() {
        return this.style == null ? (this.layer == null ? null : this.layer.getStyle()) : this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Color getColor() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getColor();
    }

    public void setColor(Color color) {
        if (this.style == null && color != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setColor(color);
        }
    }

    public Color getBackColor() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getBackColor();
    }

    public void setBackColor(Color backColor) {
        if (this.style == null && backColor != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setBackColor(backColor);
        }
    }

    public Stroke getStroke() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getStroke();
    }

    public void setStroke(Stroke stroke) {
        if (this.style == null && stroke != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setStroke(stroke);
        }
    }

    public Font getFont() {
        Style styleAssigned = this.getStyleAssigned();
        return styleAssigned == null ? null : this.getStyleAssigned().getFont();
    }

    public void setFont(Font font) {
        if (this.style == null && font != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setFont(font);
        }
    }

    private boolean isVisibleLayer() {
        return this.layer == null || this.layer.isVisible() == null ? true : this.layer.isVisible();
    }

    public boolean isVisible() {
        return this.visible == null ? this.isVisibleLayer() : this.visible.booleanValue();
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String txt) {
        this.name = txt;
    }

    public static Font getDefaultFont() {
        Font f = UIManager.getDefaults().getFont("TextField.font");
        if (f == null) {
            f = Font.decode(null);
        }
        return new Font(f.getName(), 1, OsmMercator.isRetina() ? f.getSize() * 2 : f.getSize());
    }

    public void paintText(Graphics g, Point position) {
        if (this.name != null && g != null && position != null) {
            if (this.getFont() == null) {
                Font f = MapObjectImpl.getDefaultFont();
                this.setFont(new Font(f.getName(), 1, f.getSize()));
            }
            g.setColor(Color.DARK_GRAY);
            g.setFont(this.getFont());
            g.drawString(this.name, position.x + MapMarkerDot.DOT_RADIUS + 2, position.y + MapMarkerDot.DOT_RADIUS);
        }
    }
}

