/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Locale;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class DefaultMapController
extends JMapController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int MOUSE_BUTTONS_MASK = 7168;
    private static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    private Point lastDragPoint;
    private boolean isMoving = false;
    private boolean movementEnabled = true;
    private int movementMouseButton = 1;
    private int movementMouseButtonMask = 1024;
    private boolean wheelZoomEnabled = true;
    private boolean doubleClickZoomEnabled = true;

    public DefaultMapController(JMapViewer map) {
        super(map);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.movementEnabled || !this.isMoving) {
            return;
        }
        if ((e.getModifiersEx() & 0x1C00) == this.movementMouseButtonMask || DefaultMapController.isPlatformOsx() && e.getModifiersEx() == 1152) {
            Point p = e.getPoint();
            if (this.lastDragPoint != null) {
                int diffx = this.lastDragPoint.x - p.x;
                int diffy = this.lastDragPoint.y - p.y;
                this.map.moveMap(diffx, diffy);
            }
            this.lastDragPoint = p;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.doubleClickZoomEnabled && e.getClickCount() == 2 && e.getButton() == 1) {
            this.map.zoomIn(e.getPoint());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == this.movementMouseButton || DefaultMapController.isPlatformOsx() && e.getModifiersEx() == 1152) {
            this.lastDragPoint = null;
            this.isMoving = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == this.movementMouseButton || DefaultMapController.isPlatformOsx() && e.getButton() == 1) {
            this.lastDragPoint = null;
            this.isMoving = false;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.wheelZoomEnabled) {
            int rotation = JMapViewer.zoomReverseWheel ? -e.getWheelRotation() : e.getWheelRotation();
            this.map.setZoom(this.map.getZoom() - rotation, e.getPoint());
        }
    }

    public boolean isMovementEnabled() {
        return this.movementEnabled;
    }

    public void setMovementEnabled(boolean movementEnabled) {
        this.movementEnabled = movementEnabled;
    }

    public int getMovementMouseButton() {
        return this.movementMouseButton;
    }

    public void setMovementMouseButton(int movementMouseButton) {
        this.movementMouseButton = movementMouseButton;
        switch (movementMouseButton) {
            case 1: {
                this.movementMouseButtonMask = 1024;
                break;
            }
            case 2: {
                this.movementMouseButtonMask = 2048;
                break;
            }
            case 3: {
                this.movementMouseButtonMask = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported button");
            }
        }
    }

    public boolean isWheelZoomEnabled() {
        return this.wheelZoomEnabled;
    }

    public void setWheelZoomEnabled(boolean wheelZoomEnabled) {
        this.wheelZoomEnabled = wheelZoomEnabled;
    }

    public boolean isDoubleClickZoomEnabled() {
        return this.doubleClickZoomEnabled;
    }

    public void setDoubleClickZoomEnabled(boolean doubleClickZoomEnabled) {
        this.doubleClickZoomEnabled = doubleClickZoomEnabled;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (DefaultMapController.isPlatformOsx()) {
            if (!this.movementEnabled || !this.isMoving) {
                return;
            }
            if (e.getModifiersEx() == 128) {
                Point p = e.getPoint();
                if (this.lastDragPoint != null) {
                    int diffx = this.lastDragPoint.x - p.x;
                    int diffy = this.lastDragPoint.y - p.y;
                    this.map.moveMap(diffx, diffy);
                }
                this.lastDragPoint = p;
            }
        }
    }

    public static boolean isPlatformOsx() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase(Locale.ENGLISH).startsWith("mac os x");
    }
}

