/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

public class DoubleStroke
implements Stroke,
Serializable {
    private transient BasicStroke outlineStroke;
    private double innerWidth;
    private double outlineWidth;
    private double miterLimit;
    private float[] dashes;
    private float dashPhase;

    public DoubleStroke(double innerWidth, double outlineWidth) {
        this(innerWidth, outlineWidth, 2, 2, 10.0, null, 0.0f);
    }

    public DoubleStroke(double innerWidth, double outlineWidth, int cap, int join, double miterLimit, float[] dashes, float dashPhase) {
        this.innerWidth = innerWidth;
        this.outlineWidth = outlineWidth;
        this.miterLimit = miterLimit;
        this.outlineStroke = new BasicStroke((float)outlineWidth, cap, 2, (float)miterLimit, dashes, dashPhase);
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        BezierPath bp = new BezierPath();
        Path2D.Double left = new Path2D.Double();
        Path2D.Double right = new Path2D.Double();
        double[] coords = new double[6];
        PathIterator i = s.getPathIterator(null, 0.1);
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (!bp.isEmpty()) {
                        this.traceStroke(bp, left, right);
                    }
                    bp.clear();
                    bp.setClosed(false);
                    bp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (coords[0] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0] && coords[1] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0]) break;
                    bp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    bp.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    bp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    bp.setClosed(true);
                }
            }
            i.next();
        }
        if (!bp.isEmpty()) {
            this.traceStroke(bp, left, right);
        }
        right.append(left, false);
        return this.outlineStroke.createStrokedShape(right);
    }

    protected void traceStroke(BezierPath bp, Path2D.Double left, Path2D.Double right) {
        Point2D.Double intersect;
        double[] currentCorners = new double[8];
        double[] prevCorners = new double[8];
        if (bp.isClosed()) {
            prev = (BezierPath.Node)bp.get(bp.size() - 1);
            for (i = 0; i < bp.size(); ++i) {
                node = (BezierPath.Node)bp.get(i);
                if (prev.x[0] == node.x[0] && prev.y[0] == node.y[0]) {
                    bp.remove(i--);
                    continue;
                }
                prev = node;
            }
        } else {
            prev = (BezierPath.Node)bp.get(0);
            for (i = 1; i < bp.size(); ++i) {
                node = (BezierPath.Node)bp.get(i);
                if (prev.x[0] == node.x[0] && prev.y[0] == node.y[0]) {
                    bp.remove(i--);
                    continue;
                }
                prev = node;
            }
        }
        if (bp.isClosed() && bp.size() > 1) {
            intersect = Geom.intersect((prevCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0], ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0], ((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], this.innerWidth, prevCorners))[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], ((BezierPath.Node)bp.get((int)1)).x[0], ((BezierPath.Node)bp.get((int)1)).y[0], this.innerWidth, currentCorners))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.moveTo(intersect.x, intersect.y);
            } else {
                right.moveTo(prevCorners[4], prevCorners[5]);
                right.lineTo(currentCorners[0], currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.moveTo(intersect.x, intersect.y);
            } else {
                left.moveTo(prevCorners[6], prevCorners[7]);
                left.lineTo(currentCorners[2], currentCorners[3]);
            }
        } else if (bp.size() > 1) {
            currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], ((BezierPath.Node)bp.get((int)1)).x[0], ((BezierPath.Node)bp.get((int)1)).y[0], this.innerWidth, currentCorners);
            right.moveTo(currentCorners[0], currentCorners[1]);
            left.moveTo(currentCorners[2], currentCorners[3]);
        }
        int n = bp.size() - 1;
        for (int i = 1; i < n; ++i) {
            prevCorners = currentCorners;
            double[] tmp = prevCorners;
            intersect = Geom.intersect(prevCorners[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)i)).x[0], ((BezierPath.Node)bp.get((int)i)).y[0], ((BezierPath.Node)bp.get((int)(i + 1))).x[0], ((BezierPath.Node)bp.get((int)(i + 1))).y[0], this.innerWidth, tmp))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.lineTo(intersect.x, intersect.y);
            } else {
                right.lineTo(prevCorners[4], prevCorners[5]);
                right.lineTo(currentCorners[0], currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.lineTo(intersect.x, intersect.y);
                continue;
            }
            left.lineTo(prevCorners[6], prevCorners[7]);
            left.lineTo(currentCorners[2], currentCorners[3]);
        }
        if (bp.isClosed() && !bp.isEmpty()) {
            prevCorners = currentCorners;
            double[] tmp = prevCorners;
            intersect = Geom.intersect(prevCorners[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0], ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0], ((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], this.innerWidth, tmp))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.lineTo(intersect.x, intersect.y);
            } else {
                right.lineTo(prevCorners[4], prevCorners[5]);
                right.lineTo(currentCorners[0], currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.lineTo(intersect.x, intersect.y);
            } else {
                left.lineTo(prevCorners[6], prevCorners[7]);
                left.lineTo(currentCorners[2], currentCorners[3]);
            }
            right.closePath();
            left.closePath();
        } else if (bp.size() > 1) {
            right.lineTo(currentCorners[4], currentCorners[5]);
            left.lineTo(currentCorners[6], currentCorners[7]);
        }
    }

    private double[] computeThickLine(double[] seg, int offset, double[] corners) {
        return this.computeThickLine(seg[0 + offset], seg[1 + offset], seg[2 + offset], seg[3 + offset], this.innerWidth, corners);
    }

    private double[] computeThickLine(double x1, double y1, double x2, double y2, double thickness, double[] corners) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double lineLength = Math.sqrt(dx * dx + dy * dy);
        double scale = thickness / (2.0 * lineLength);
        double ddx = -scale * dy;
        double ddy = scale * dx;
        corners[0] = x1 + ddx;
        corners[1] = y1 + ddy;
        corners[2] = x1 - ddx;
        corners[3] = y1 - ddy;
        corners[4] = x2 + ddx;
        corners[5] = y2 + ddy;
        corners[6] = x2 - ddx;
        corners[7] = y2 - ddy;
        return corners;
    }

    public void setInnerWidth(float i) {
        this.innerWidth = i;
    }

    public double getInnerWidth() {
        return this.innerWidth;
    }

    public void setOutlineWidth(float o) {
        this.outlineWidth = o;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setMiterLimit(double m) {
        this.miterLimit = m;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setDashes(float[] d) {
        this.dashes = d;
    }

    public float[] getDashes() {
        return this.dashes;
    }

    public void setDashPhase(float p) {
        this.dashPhase = p;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.outlineStroke = (BasicStroke)DoubleStroke.readStroke(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        DoubleStroke.writeStroke(this.outlineStroke, out);
    }

    public static Stroke readStroke(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Stroke result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c = (Class)stream.readObject();
            if (c.equals(BasicStroke.class)) {
                float width = stream.readFloat();
                int cap = stream.readInt();
                int join = stream.readInt();
                float miterLimit = stream.readFloat();
                float[] dash = (float[])stream.readObject();
                float dashPhase = stream.readFloat();
                result = new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
            } else {
                result = (Stroke)stream.readObject();
            }
        }
        return result;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream stream) throws IOException {
        if (stroke != null) {
            stream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)stroke;
                stream.writeObject(BasicStroke.class);
                stream.writeFloat(s.getLineWidth());
                stream.writeInt(s.getEndCap());
                stream.writeInt(s.getLineJoin());
                stream.writeFloat(s.getMiterLimit());
                stream.writeObject(s.getDashArray());
                stream.writeFloat(s.getDashPhase());
            } else {
                stream.writeObject(stroke.getClass());
                stream.writeObject(stroke);
            }
        } else {
            stream.writeBoolean(true);
        }
    }
}

