/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.perspective.draw.util.CanvasPoint;
import org.jhotdraw.geom.BezierPathIterator;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Shapes;

public class BezierPath
extends ArrayList<Node>
implements Shape,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int C0_MASK = 0;
    public static final int C1_MASK = 1;
    public static final int C2_MASK = 2;
    public static final int C1C2_MASK = 3;
    private transient Path2D.Double generalPath;
    private transient Rectangle2D.Double bounds;
    private int outer = -1;
    private boolean isClosed;
    private int windingRule = 0;

    public void add(CanvasPoint c0) {
        this.add(new Node(0, c0, c0, c0));
    }

    public void add(double x, double y) {
        this.add(new Node(0, x, y, x, y, x, y));
    }

    public void add(int ctrlMask, CanvasPoint c0, CanvasPoint c1, CanvasPoint c2) {
        this.add(new Node(ctrlMask, c0, c1, c2));
    }

    public void addPolyline(Collection<CanvasPoint> points) {
        for (CanvasPoint c0 : points) {
            this.add(new Node(0, c0, c0, c0));
        }
    }

    public void set(int nodeIndex, int ctrlIndex, CanvasPoint p) {
        Node c = (Node)this.get(nodeIndex);
        c.x[ctrlIndex] = p.x;
        c.y[ctrlIndex] = p.y;
    }

    public CanvasPoint get(int nodeIndex, int ctrlIndex) {
        Node c = (Node)this.get(nodeIndex);
        return new CanvasPoint(c.x[ctrlIndex], c.y[ctrlIndex]);
    }

    public void invalidatePath() {
        this.generalPath = null;
        this.bounds = null;
        this.outer = -1;
    }

    public void validatePath() {
        if (this.generalPath == null) {
            this.generalPath = this.toGeneralPath();
        }
    }

    public Path2D.Double toGeneralPath() {
        Path2D.Double gp = new Path2D.Double();
        gp.setWindingRule(this.windingRule);
        if (this.isEmpty()) {
            gp.moveTo(0.0, 0.0);
            gp.lineTo(0.0, 1.0);
        } else if (this.size() == 1) {
            Node current = (Node)this.get(0);
            gp.moveTo(current.x[0], current.y[0]);
            gp.lineTo(current.x[0], current.y[0] + 1.0);
        } else {
            Node current;
            Node previous = current = (Node)this.get(0);
            gp.moveTo(current.x[0], current.y[0]);
            int n = this.size();
            for (int i = 1; i < n; ++i) {
                previous = current;
                current = (Node)this.get(i);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        gp.lineTo(current.x[0], current.y[0]);
                        continue;
                    }
                    gp.quadTo(current.x[1], current.y[1], current.x[0], current.y[0]);
                    continue;
                }
                if ((current.mask & 1) == 0) {
                    gp.quadTo(previous.x[2], previous.y[2], current.x[0], current.y[0]);
                    continue;
                }
                gp.curveTo(previous.x[2], previous.y[2], current.x[1], current.y[1], current.x[0], current.y[0]);
            }
            if (this.isClosed) {
                if (this.size() > 1) {
                    previous = (Node)this.get(this.size() - 1);
                    current = (Node)this.get(0);
                    if ((previous.mask & 2) == 0) {
                        if ((current.mask & 1) == 0) {
                            gp.lineTo(current.x[0], current.y[0]);
                        } else {
                            gp.quadTo(current.x[1], current.y[1], current.x[0], current.y[0]);
                        }
                    } else if ((current.mask & 1) == 0) {
                        gp.quadTo(previous.x[2], previous.y[2], current.x[0], current.y[0]);
                    } else {
                        gp.curveTo(previous.x[2], previous.y[2], current.x[1], current.y[1], current.x[0], current.y[0]);
                    }
                }
                gp.closePath();
            }
        }
        return gp;
    }

    @Override
    public boolean contains(Point2D p) {
        this.validatePath();
        return this.generalPath.contains(p);
    }

    public boolean outlineContains(CanvasPoint p, double tolerance) {
        Point2D.Double pdash = new Point2D.Double(p.x, p.y);
        return Shapes.outlineContains(this, pdash, tolerance);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.intersects(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new BezierPathIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(new BezierPathIterator(this, at), flatness);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.contains(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.intersects(x, y, w, h);
    }

    @Override
    public Rectangle2D.Double getBounds2D() {
        if (this.bounds == null) {
            double x1;
            double y1;
            double x2;
            double y2;
            int size = this.size();
            if (size == 0) {
                y2 = 0.0;
                x2 = 0.0;
                y1 = 0.0;
                x1 = 0.0;
            } else {
                double x;
                double y;
                Node node = (Node)this.get(0);
                y1 = y2 = node.y[0];
                x1 = x2 = node.x[0];
                if (this.isClosed && (node.mask & 1) != 0) {
                    y = node.y[1];
                    x = node.x[1];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                }
                if ((node.mask & 2) != 0) {
                    y = node.y[2];
                    x = node.x[2];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                }
                node = (Node)this.get(size - 1);
                y = node.y[0];
                x = node.x[0];
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (y > y2) {
                    y2 = y;
                }
                if ((node.mask & 1) != 0) {
                    y = node.y[1];
                    x = node.x[1];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                }
                if (this.isClosed && (node.mask & 2) != 0) {
                    y = node.y[2];
                    x = node.x[2];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                }
                int n = size - 1;
                for (int i = 1; i < n; ++i) {
                    node = (Node)this.get(i);
                    y = node.y[0];
                    x = node.x[0];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y;
                    }
                    if ((node.mask & 1) != 0) {
                        y = node.y[1];
                        x = node.x[1];
                        if (x < x1) {
                            x1 = x;
                        }
                        if (y < y1) {
                            y1 = y;
                        }
                        if (x > x2) {
                            x2 = x;
                        }
                        if (y > y2) {
                            y2 = y;
                        }
                    }
                    if ((node.mask & 2) == 0) continue;
                    y = node.y[2];
                    x = node.x[2];
                    if (x < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (!(y > y2)) continue;
                    y2 = y;
                }
            }
            this.bounds = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.contains(x, y, w, h);
    }

    @Override
    public boolean contains(double x, double y) {
        this.validatePath();
        return this.generalPath.contains(x, y);
    }

    public void setClosed(boolean newValue) {
        if (this.isClosed != newValue) {
            this.isClosed = newValue;
            this.invalidatePath();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public BezierPath clone() {
        BezierPath that = (BezierPath)super.clone();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            that.set(i, (Node)((Node)this.get(i)).clone());
        }
        return that;
    }

    public void transform(AffineTransform tx) {
        CanvasPoint p = new CanvasPoint();
        for (Node cp : this) {
            for (int i = 0; i < 3; ++i) {
                p.x = cp.x[i];
                p.y = cp.y[i];
                Point2D.Double pdash = new Point2D.Double(p.x, p.y);
                tx.transform(pdash, pdash);
                p = new CanvasPoint(pdash.x, pdash.y);
                cp.x[i] = p.x;
                cp.y[i] = p.y;
            }
        }
        this.invalidatePath();
    }

    public void setTo(BezierPath that) {
        while (that.size() < this.size()) {
            this.remove(this.size() - 1);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.get(i)).setTo((Node)that.get(i));
        }
        while (this.size() < that.size()) {
            this.add((Node)((Node)that.get(this.size())).clone());
        }
    }

    public CanvasPoint getCenter() {
        double sx = 0.0;
        double sy = 0.0;
        for (Node p : this) {
            sx += p.x[0];
            sy += p.y[0];
        }
        int n = this.size();
        return new CanvasPoint(sx / (double)n, sy / (double)n);
    }

    public CanvasPoint chop(CanvasPoint p) {
        Point2D.Double pdash = new Point2D.Double(p.x, p.y);
        Point2D.Double pdash2 = Geom.chop(this, pdash);
        CanvasPoint pdash3 = new CanvasPoint(pdash2.x, pdash2.y);
        return pdash3;
    }

    public int indexOfOutermostNode() {
        if (this.outer == -1) {
            CanvasPoint ctr = this.getCenter();
            this.outer = 0;
            double dist = 0.0;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                Node cp = (Node)this.get(i);
                double d = Geom.length2(ctr.x, ctr.y, cp.x[0], cp.y[0]);
                if (!(d > dist)) continue;
                dist = d;
                this.outer = i;
            }
        }
        return this.outer;
    }

    public CanvasPoint getPointOnPath(double relative, double flatness) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (relative <= 0.0) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (relative >= 1.0) {
            return ((Node)this.get(this.size() - 1)).getControlPoint(0);
        }
        this.validatePath();
        double len = this.getLengthOfPath(flatness);
        double relativeLen = len * relative;
        double pos = 0.0;
        double[] coords = new double[6];
        PathIterator i = this.generalPath.getPathIterator(new AffineTransform(), flatness);
        double prevX = coords[0];
        double prevY = coords[1];
        i.next();
        while (!i.isDone()) {
            i.currentSegment(coords);
            double segLen = Geom.length(prevX, prevY, coords[0], coords[1]);
            if (pos + segLen >= relativeLen) {
                double factor = (relativeLen - pos) / segLen;
                return new CanvasPoint(prevX * (1.0 - factor) + coords[0] * factor, prevY * (1.0 - factor) + coords[1] * factor);
            }
            pos += segLen;
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        throw new InternalError("We should never get here");
    }

    public double getLengthOfPath(double flatness) {
        double len = 0.0;
        PathIterator i = this.generalPath.getPathIterator(new AffineTransform(), flatness);
        double[] coords = new double[6];
        double prevX = coords[0];
        double prevY = coords[1];
        i.next();
        while (!i.isDone()) {
            i.currentSegment(coords);
            len += Geom.length(prevX, prevY, coords[0], coords[1]);
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        return len;
    }

    public double getRelativePositionOnPath(CanvasPoint find, double flatness) {
        Node v2;
        Node v1;
        double len = this.getLengthOfPath(flatness);
        double relativeLen = 0.0;
        BezierPath tempPath = new BezierPath();
        Node t1 = new Node();
        tempPath.add(t1);
        Node t2 = new Node();
        tempPath.add(t2);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            v1 = (Node)this.get(i);
            v2 = (Node)this.get(i + 1);
            if (v1.mask == 0 && v2.mask == 0) {
                if (Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, flatness)) {
                    return (relativeLen += Geom.length(v1.x[0], v1.y[0], find.x, find.y)) / len;
                }
                relativeLen += Geom.length(v1.x[0], v1.y[0], v2.x[0], v2.y[0]);
                continue;
            }
            t1.setTo(v1);
            t2.setTo(v2);
            tempPath.invalidatePath();
            if (tempPath.outlineContains(find, flatness)) {
                return (relativeLen += Geom.length(v1.x[0], v1.y[0], find.x, find.y)) / len;
            }
            relativeLen += Geom.length(v1.x[0], v1.y[0], v2.x[0], v2.y[0]);
        }
        if (this.isClosed && this.size() > 1) {
            v1 = (Node)this.get(this.size() - 1);
            v2 = (Node)this.get(0);
            if (v1.mask == 0 && v2.mask == 0) {
                if (Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, flatness)) {
                    return (relativeLen += Geom.length(v1.x[0], v1.y[0], find.x, find.y)) / len;
                }
            } else {
                t1.setTo(v1);
                t2.setTo(v2);
                tempPath.invalidatePath();
                if (tempPath.outlineContains(find, flatness)) {
                    return (relativeLen += Geom.length(v1.x[0], v1.y[0], find.x, find.y)) / len;
                }
            }
        }
        return -1.0;
    }

    public int findSegment(CanvasPoint find, double tolerance) {
        Node v2;
        Node v1;
        BezierPath tempPath = new BezierPath();
        Node t1 = new Node();
        tempPath.add(t1);
        Node t2 = new Node();
        tempPath.add(t2);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            v1 = (Node)this.get(i);
            v2 = (Node)this.get(i + 1);
            if (v1.mask == 0 && v2.mask == 0) {
                if (!Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, tolerance)) continue;
                return i;
            }
            t1.setTo(v1);
            t2.setTo(v2);
            tempPath.invalidatePath();
            if (!tempPath.outlineContains(find, tolerance)) continue;
            return i;
        }
        if (this.isClosed && this.size() > 1) {
            v1 = (Node)this.get(this.size() - 1);
            v2 = (Node)this.get(0);
            if (v1.mask == 0 && v2.mask == 0) {
                if (Geom.lineContainsPoint(v1.x[0], v1.y[0], v2.x[0], v2.y[0], find.x, find.y, tolerance)) {
                    return this.size() - 1;
                }
            } else {
                t1.setTo(v1);
                t2.setTo(v2);
                tempPath.invalidatePath();
                if (tempPath.outlineContains(find, tolerance)) {
                    return this.size() - 1;
                }
            }
        }
        return -1;
    }

    public int joinSegments(CanvasPoint join, double tolerance) {
        for (int i = 0; i < this.size(); ++i) {
            Node p = (Node)this.get(i);
            if (!(Geom.length(p.x[0], p.y[0], join.x, join.y) < tolerance)) continue;
            this.remove(i);
            return i;
        }
        return -1;
    }

    public int splitSegment(CanvasPoint split, double tolerance) {
        int i = this.findSegment(split, tolerance);
        int nextI = (i + 1) % this.size();
        if (i != -1) {
            if ((((Node)this.get((int)i)).mask & 2) == 2 && (((Node)this.get((int)nextI)).mask & 1) == 0) {
                this.add(i + 1, new Node(2, split, split, split));
            } else if ((((Node)this.get((int)i)).mask & 2) == 0 && (((Node)this.get((int)nextI)).mask & 1) == 1) {
                this.add(i + 1, new Node(1, split, split, split));
            } else if ((((Node)this.get((int)i)).mask & 2) == 2 && (((Node)this.get((int)nextI)).mask & 1) == 1) {
                this.add(i + 1, new Node(3, split, split, split));
            } else {
                this.add(i + 1, new Node(split));
            }
        }
        return i + 1;
    }

    public void moveTo(double x1, double y1) {
        if (!this.isEmpty()) {
            throw new IllegalPathStateException("moveTo only allowed when empty");
        }
        Node node = new Node(x1, y1);
        node.keepColinear = false;
        this.add(node);
    }

    public void lineTo(double x1, double y1) {
        if (this.isEmpty()) {
            throw new IllegalPathStateException("lineTo only allowed when not empty");
        }
        ((Node)this.get((int)(this.size() - 1))).keepColinear = false;
        this.add(new Node(x1, y1));
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        if (this.isEmpty()) {
            throw new IllegalPathStateException("quadTo only allowed when not empty");
        }
        this.add(new Node(1, x2, y2, x1, y1, x2, y2));
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.isEmpty()) {
            throw new IllegalPathStateException("curveTo only allowed when not empty");
        }
        Node lastPoint = (Node)this.get(this.size() - 1);
        lastPoint.mask |= 2;
        lastPoint.x[2] = x1;
        lastPoint.y[2] = y1;
        if ((lastPoint.mask & 3) == 3) {
            lastPoint.keepColinear = Math.abs(Geom.angle(lastPoint.x[0], lastPoint.y[0], lastPoint.x[1], lastPoint.y[1]) - Geom.angle(lastPoint.x[2], lastPoint.y[2], lastPoint.x[0], lastPoint.y[0])) < 0.001;
        }
        this.add(new Node(1, x3, y3, x2, y2, x3, y3));
    }

    public void arcTo(double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        double Pry;
        double Py1;
        double y0;
        if (rx == 0.0 || ry == 0.0) {
            this.lineTo(x, y);
            return;
        }
        Node lastPoint = (Node)this.get(this.size() - 1);
        double x0 = (lastPoint.mask & 2) == 2 ? lastPoint.x[2] : lastPoint.x[0];
        double d = y0 = (lastPoint.mask & 2) == 2 ? lastPoint.y[2] : lastPoint.y[0];
        if (x0 == x && y0 == y) {
            return;
        }
        double dx2 = (x0 - x) / 2.0;
        double dy2 = (y0 - y) / 2.0;
        double angle = Math.toRadians(xAxisRotation);
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double Prx = (rx = Math.abs(rx)) * rx;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ry = Math.abs(ry)) * ry);
        if (radiiCheck > 1.0) {
            rx = Math.sqrt(radiiCheck) * rx;
            ry = Math.sqrt(radiiCheck) * ry;
            Prx = rx * rx;
            Pry = ry * ry;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rx * y1 / ry);
        double cy1 = coef * -(ry * x1 / rx);
        double sx2 = (x0 + x) / 2.0;
        double sy2 = (y0 + y) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx;
        double uy = (y1 - cy1) / ry;
        double vx = (-x1 - cx1) / rx;
        double vy = (-y1 - cy1) / ry;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p / n));
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        Arc2D.Double arc = new Arc2D.Double(cx - rx, cy - ry, rx * 2.0, ry * 2.0, -(angleStart %= 360.0), -(angleExtent %= 360.0), 0);
        PathIterator i = arc.getPathIterator(AffineTransform.getRotateInstance(angle, arc.getCenterX(), arc.getCenterY()));
        double[] coords = new double[6];
        i.next();
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 4: {
                    break;
                }
                case 3: {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            i.next();
        }
    }

    public CanvasPoint[] toPolygonArray() {
        CanvasPoint[] points = new CanvasPoint[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            points[i] = new CanvasPoint(((Node)this.get((int)i)).x[0], ((Node)this.get((int)i)).y[0]);
        }
        return points;
    }

    public void setWindingRule(int newValue) {
        if (newValue != this.windingRule) {
            this.invalidatePath();
            int oldValue = this.windingRule;
            this.windingRule = newValue;
        }
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public static class Node
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public int mask = 0;
        public double[] x = new double[3];
        public double[] y = new double[3];
        public boolean keepColinear = true;

        public Node() {
        }

        public Node(Node that) {
            this.setTo(that);
        }

        public void setTo(Node that) {
            this.mask = that.mask;
            this.keepColinear = that.keepColinear;
            System.arraycopy(that.x, 0, this.x, 0, 3);
            System.arraycopy(that.y, 0, this.y, 0, 3);
        }

        public Node(CanvasPoint c0) {
            this.mask = 0;
            this.x[0] = c0.x;
            this.y[0] = c0.y;
            this.x[1] = c0.x;
            this.y[1] = c0.y;
            this.x[2] = c0.x;
            this.y[2] = c0.y;
        }

        public Node(int mask, CanvasPoint c0, CanvasPoint c1, CanvasPoint c2) {
            this.mask = mask;
            this.x[0] = c0.x;
            this.y[0] = c0.y;
            this.x[1] = c1.x;
            this.y[1] = c1.y;
            this.x[2] = c2.x;
            this.y[2] = c2.y;
        }

        public Node(double x0, double y0) {
            this.mask = 0;
            this.x[0] = x0;
            this.y[0] = y0;
            this.x[1] = x0;
            this.y[1] = y0;
            this.x[2] = x0;
            this.y[2] = y0;
        }

        public Node(int mask, double x0, double y0, double x1, double y1, double x2, double y2) {
            this.mask = mask;
            this.x[0] = x0;
            this.y[0] = y0;
            this.x[1] = x1;
            this.y[1] = y1;
            this.x[2] = x2;
            this.y[2] = y2;
        }

        public int getMask() {
            return this.mask;
        }

        public void setMask(int newValue) {
            this.mask = newValue;
        }

        public void setControlPoint(int index, CanvasPoint p) {
            this.x[index] = p.x;
            this.y[index] = p.y;
        }

        public CanvasPoint getControlPoint(int index) {
            return new CanvasPoint(this.x[index], this.y[index]);
        }

        public void moveTo(CanvasPoint p) {
            this.moveBy(p.x - this.x[0], p.y - this.y[0]);
        }

        public void moveTo(double x, double y) {
            this.moveBy(x - this.x[0], y - this.y[0]);
        }

        public void moveBy(double dx, double dy) {
            int i = 0;
            while (i < 3) {
                int n = i;
                this.x[n] = this.x[n] + dx;
                int n2 = i++;
                this.y[n2] = this.y[n2] + dy;
            }
        }

        public Object clone() {
            try {
                Node that = (Node)super.clone();
                that.x = (double[])this.x.clone();
                that.y = (double[])this.y.clone();
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append('[');
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    if ((this.mask & i) != i) continue;
                    buf.append(',');
                }
                buf.append('x');
                buf.append(i);
                buf.append('=');
                buf.append(this.x[i]);
                buf.append(",y");
                buf.append(i);
                buf.append('=');
                buf.append(this.y[i]);
            }
            buf.append(']');
            return buf.toString();
        }

        public int hashCode() {
            return (this.mask & 3) << 29 | Arrays.hashCode(this.x) & 0x3FFF0000 | Arrays.hashCode(this.y) & 0xFFFF;
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node that = (Node)o;
                return that.mask == this.mask && Arrays.equals(that.x, this.x) && Arrays.equals(that.y, this.y);
            }
            return false;
        }
    }
}

