/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.perspective.draw.util.CanvasPoint;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

public class Bezier {
    private Bezier() {
    }

    public static BezierPath fitBezierPath(CanvasPoint[] digitizedPoints, double error) {
        return Bezier.fitBezierPath(Arrays.asList(digitizedPoints), error);
    }

    public static BezierPath fitBezierPath(List<CanvasPoint> digitizedPoints, double error) {
        ArrayList<ArrayList<CanvasPoint>> segments = Bezier.splitAtCorners(digitizedPoints, 1.3439035240356336, error * error);
        int n = segments.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<CanvasPoint> seg = segments.get(i);
            seg = Bezier.removeClosePoints(seg, error * 2.0);
            seg = Bezier.reduceNoise(seg, 0.8);
            segments.set(i, seg);
        }
        BezierPath fittedPath = new BezierPath();
        boolean isEmpty = false;
        for (ArrayList arrayList : segments) {
            if (!arrayList.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (!isEmpty) {
            double errorSquared = error * error;
            block7: for (ArrayList<CanvasPoint> seg : segments) {
                switch (seg.size()) {
                    case 0: {
                        continue block7;
                    }
                    case 1: {
                        fittedPath.add(new BezierPath.Node(seg.get(0)));
                        continue block7;
                    }
                    case 2: {
                        if (fittedPath.isEmpty()) {
                            fittedPath.add(new BezierPath.Node(seg.get(0)));
                        }
                        fittedPath.lineTo(seg.get((int)1).x, seg.get((int)1).y);
                        continue block7;
                    }
                }
                if (fittedPath.isEmpty()) {
                    fittedPath.add(new BezierPath.Node(seg.get(0)));
                }
                CanvasPoint tHat1 = Bezier.computeLeftTangent(seg, 0);
                CanvasPoint tHat2 = Bezier.computeRightTangent(seg, seg.size() - 1);
                Bezier.fitCubic(seg, 0, seg.size() - 1, tHat1, tHat2, errorSquared, fittedPath);
            }
        }
        return fittedPath;
    }

    public static BezierPath fitBezierPath(BezierPath digitizedPoints, double error) {
        ArrayList<CanvasPoint> d = new ArrayList<CanvasPoint>(digitizedPoints.size());
        for (BezierPath.Node n : digitizedPoints) {
            d.add(new CanvasPoint(n.x[0], n.y[0]));
        }
        return Bezier.fitBezierPath(d, error);
    }

    public static ArrayList<CanvasPoint> removeClosePoints(List<CanvasPoint> digitizedPoints, double minDistance) {
        if (minDistance == 0.0) {
            return Bezier.removeCoincidentPoints(digitizedPoints);
        }
        double squaredDistance = minDistance * minDistance;
        ArrayList<CanvasPoint> cleaned = new ArrayList<CanvasPoint>();
        if (!digitizedPoints.isEmpty()) {
            CanvasPoint prev = digitizedPoints.get(0);
            cleaned.add(prev);
            for (CanvasPoint p : digitizedPoints) {
                if (!(Bezier.v2SquaredDistanceBetween2Points(prev, p) > squaredDistance)) continue;
                cleaned.add(p);
                prev = p;
            }
            if (!prev.equals(digitizedPoints.get(digitizedPoints.size() - 1))) {
                cleaned.set(cleaned.size() - 1, digitizedPoints.get(digitizedPoints.size() - 1));
            }
        }
        return cleaned;
    }

    private static ArrayList<CanvasPoint> removeCoincidentPoints(List<CanvasPoint> digitizedPoints) {
        ArrayList<CanvasPoint> cleaned = new ArrayList<CanvasPoint>();
        if (!digitizedPoints.isEmpty()) {
            CanvasPoint prev = digitizedPoints.get(0);
            cleaned.add(prev);
            for (CanvasPoint p : digitizedPoints) {
                if (prev.equals(p)) continue;
                cleaned.add(p);
                prev = p;
            }
        }
        return cleaned;
    }

    public static ArrayList<ArrayList<CanvasPoint>> splitAtCorners(List<CanvasPoint> digitizedPoints, double maxAngle, double minDistance) {
        ArrayList<Integer> cornerIndices = Bezier.findCorners(digitizedPoints, maxAngle, minDistance);
        ArrayList<ArrayList<CanvasPoint>> segments = new ArrayList<ArrayList<CanvasPoint>>(cornerIndices.size() + 1);
        if (cornerIndices.isEmpty()) {
            segments.add(new ArrayList<CanvasPoint>(digitizedPoints));
        } else {
            segments.add(new ArrayList<CanvasPoint>(digitizedPoints.subList(0, cornerIndices.get(0) + 1)));
            for (int i = 1; i < cornerIndices.size(); ++i) {
                segments.add(new ArrayList<CanvasPoint>(digitizedPoints.subList(cornerIndices.get(i - 1), cornerIndices.get(i) + 1)));
            }
            segments.add(new ArrayList<CanvasPoint>(digitizedPoints.subList(cornerIndices.get(cornerIndices.size() - 1), digitizedPoints.size())));
        }
        return segments;
    }

    public static ArrayList<Integer> findCorners(List<CanvasPoint> digitizedPoints, double minAngle, double minDistance) {
        ArrayList<Integer> cornerIndices = new ArrayList<Integer>();
        double squaredDistance = minDistance * minDistance;
        int previousCorner = -1;
        double previousCornerAngle = 0.0;
        int n = digitizedPoints.size();
        for (int i = 1; i < n - 1; ++i) {
            double aNext;
            double aPrev;
            double angle;
            CanvasPoint p = digitizedPoints.get(i);
            CanvasPoint prev = null;
            boolean intersectsPreviousCorner = false;
            for (int j = i - 1; j >= 0; --j) {
                if (j != previousCorner && !(Bezier.v2SquaredDistanceBetween2Points(digitizedPoints.get(j), p) >= squaredDistance)) continue;
                prev = digitizedPoints.get(j);
                intersectsPreviousCorner = j < previousCorner;
                break;
            }
            if (prev == null) continue;
            CanvasPoint next = null;
            for (int j = i + 1; j < n; ++j) {
                if (!(Bezier.v2SquaredDistanceBetween2Points(digitizedPoints.get(j), p) >= squaredDistance)) continue;
                next = digitizedPoints.get(j);
                break;
            }
            if (next == null || !((angle = Math.abs((aPrev = Math.atan2(prev.y - p.y, prev.x - p.x)) - (aNext = Math.atan2(next.y - p.y, next.x - p.x)))) < Math.PI - minAngle) && !(angle > Math.PI + minAngle)) continue;
            if (intersectsPreviousCorner) {
                cornerIndices.set(cornerIndices.size() - 1, i);
            } else {
                cornerIndices.add(i);
            }
            previousCorner = i;
            previousCornerAngle = angle;
        }
        return cornerIndices;
    }

    public static ArrayList<CanvasPoint> reduceNoise(List<CanvasPoint> digitizedPoints, double weight) {
        ArrayList<CanvasPoint> cleaned = new ArrayList<CanvasPoint>();
        if (!digitizedPoints.isEmpty()) {
            CanvasPoint prev = digitizedPoints.get(0);
            cleaned.add(prev);
            double pnWeight = (1.0 - weight) / 2.0;
            int n = digitizedPoints.size() - 1;
            for (int i = 1; i < n; ++i) {
                CanvasPoint cur = digitizedPoints.get(i);
                CanvasPoint next = digitizedPoints.get(i + 1);
                cleaned.add(new CanvasPoint(cur.x * weight + pnWeight * prev.x + pnWeight * next.x, cur.y * weight + pnWeight * prev.y + pnWeight * next.y));
                prev = cur;
            }
            if (digitizedPoints.size() > 1) {
                cleaned.add(digitizedPoints.get(digitizedPoints.size() - 1));
            }
        }
        return cleaned;
    }

    private static void fitCubic(ArrayList<CanvasPoint> d, int first, int last, CanvasPoint tHat1, CanvasPoint tHat2, double errorSquared, BezierPath bezierPath) {
        int[] splitPoint = new int[1];
        int maxIterations = 4;
        try {
            tHat1 = (CanvasPoint)tHat1.clone();
            tHat2 = (CanvasPoint)tHat2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        double iterationError = errorSquared * errorSquared;
        int nPts = last - first + 1;
        if (nPts == 2) {
            double dist = Bezier.v2DistanceBetween2Points(d.get(last), d.get(first)) / 3.0;
            CanvasPoint[] bezCurve = new CanvasPoint[4];
            for (int i = 0; i < bezCurve.length; ++i) {
                bezCurve[i] = new CanvasPoint();
            }
            bezCurve[0] = d.get(first);
            bezCurve[3] = d.get(last);
            Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, dist), bezCurve[1]);
            Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, dist), bezCurve[2]);
            bezierPath.curveTo(bezCurve[1].x, bezCurve[1].y, bezCurve[2].x, bezCurve[2].y, bezCurve[3].x, bezCurve[3].y);
            return;
        }
        double[] u = Bezier.chordLengthParameterize(d, first, last);
        CanvasPoint[] bezCurve = Bezier.generateBezier(d, first, last, u, tHat1, tHat2);
        double maxError = Bezier.computeMaxError(d, first, last, bezCurve, u, splitPoint);
        if (maxError < errorSquared) {
            Bezier.addCurveTo(bezCurve, bezierPath, errorSquared, first == 0 && last == d.size() - 1);
            return;
        }
        if (maxError < iterationError) {
            for (int i = 0; i < maxIterations; ++i) {
                double[] uPrime = Bezier.reparameterize(d, first, last, u, bezCurve);
                maxError = Bezier.computeMaxError(d, first, last, bezCurve = Bezier.generateBezier(d, first, last, uPrime, tHat1, tHat2), uPrime, splitPoint);
                if (maxError < errorSquared) {
                    Bezier.addCurveTo(bezCurve, bezierPath, errorSquared, first == 0 && last == d.size() - 1);
                    return;
                }
                u = uPrime;
            }
        }
        CanvasPoint tHatCenter = Bezier.computeCenterTangent(d, splitPoint[0]);
        if (first < splitPoint[0]) {
            Bezier.fitCubic(d, first, splitPoint[0], tHat1, tHatCenter, errorSquared, bezierPath);
        } else {
            bezierPath.lineTo(d.get((int)splitPoint[0]).x, d.get((int)splitPoint[0]).y);
        }
        Bezier.v2Negate(tHatCenter);
        if (splitPoint[0] < last) {
            Bezier.fitCubic(d, splitPoint[0], last, tHatCenter, tHat2, errorSquared, bezierPath);
        } else {
            bezierPath.lineTo(d.get((int)last).x, d.get((int)last).y);
        }
    }

    private static void addCurveTo(CanvasPoint[] bezCurve, BezierPath bezierPath, double errorSquared, boolean connectsCorners) {
        BezierPath.Node lastNode = (BezierPath.Node)bezierPath.get(bezierPath.size() - 1);
        double error = Math.sqrt(errorSquared);
        if (connectsCorners && Geom.lineContainsPoint(lastNode.x[0], lastNode.y[0], bezCurve[3].x, bezCurve[3].y, bezCurve[1].x, bezCurve[1].y, error) && Geom.lineContainsPoint(lastNode.x[0], lastNode.y[0], bezCurve[3].x, bezCurve[3].y, bezCurve[2].x, bezCurve[2].y, error)) {
            bezierPath.lineTo(bezCurve[3].x, bezCurve[3].y);
        } else {
            bezierPath.curveTo(bezCurve[1].x, bezCurve[1].y, bezCurve[2].x, bezCurve[2].y, bezCurve[3].x, bezCurve[3].y);
        }
    }

    private static CanvasPoint computeLeftTangent(ArrayList<CanvasPoint> d, int end) {
        CanvasPoint tHat1 = Bezier.v2SubII(d.get(end + 1), d.get(end));
        tHat1 = Bezier.v2Normalize(tHat1);
        return tHat1;
    }

    private static CanvasPoint computeRightTangent(ArrayList<CanvasPoint> d, int end) {
        CanvasPoint tHat2 = Bezier.v2SubII(d.get(end - 1), d.get(end));
        tHat2 = Bezier.v2Normalize(tHat2);
        return tHat2;
    }

    private static CanvasPoint computeCenterTangent(ArrayList<CanvasPoint> d, int center) {
        CanvasPoint tHatCenter = new CanvasPoint();
        CanvasPoint V1 = Bezier.v2SubII(d.get(center - 1), d.get(center));
        CanvasPoint V22 = Bezier.v2SubII(d.get(center), d.get(center + 1));
        tHatCenter.x = (V1.x + V22.x) / 2.0;
        tHatCenter.y = (V1.y + V22.y) / 2.0;
        tHatCenter = Bezier.v2Normalize(tHatCenter);
        return tHatCenter;
    }

    private static double[] chordLengthParameterize(ArrayList<CanvasPoint> d, int first, int last) {
        int i;
        double[] u = new double[last - first + 1];
        u[0] = 0.0;
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first - 1] + Bezier.v2DistanceBetween2Points(d.get(i), d.get(i - 1));
        }
        for (i = first + 1; i <= last; ++i) {
            int n = i - first;
            u[n] = u[n] / u[last - first];
        }
        return u;
    }

    private static double[] reparameterize(ArrayList<CanvasPoint> d, int first, int last, double[] u, CanvasPoint[] bezCurve) {
        int nPts = last - first + 1;
        double[] uPrime = new double[nPts];
        for (int i = first; i <= last; ++i) {
            uPrime[i - first] = Bezier.newtonRaphsonRootFind(bezCurve, d.get(i), u[i - first]);
        }
        return uPrime;
    }

    private static double newtonRaphsonRootFind(CanvasPoint[] Q, CanvasPoint P, double u) {
        int i;
        CanvasPoint[] Q1 = new CanvasPoint[3];
        CanvasPoint[] Q2 = new CanvasPoint[2];
        CanvasPoint Q_u = Bezier.bezierII(3, Q, u);
        for (i = 0; i <= 2; ++i) {
            Q1[i] = new CanvasPoint((Q[i + 1].x - Q[i].x) * 3.0, (Q[i + 1].y - Q[i].y) * 3.0);
        }
        for (i = 0; i <= 1; ++i) {
            Q2[i] = new CanvasPoint((Q1[i + 1].x - Q1[i].x) * 2.0, (Q1[i + 1].y - Q1[i].y) * 2.0);
        }
        CanvasPoint Q1_u = Bezier.bezierII(2, Q1, u);
        CanvasPoint Q2_u = Bezier.bezierII(1, Q2, u);
        double numerator = (Q_u.x - P.x) * Q1_u.x + (Q_u.y - P.y) * Q1_u.y;
        double denominator = Q1_u.x * Q1_u.x + Q1_u.y * Q1_u.y + (Q_u.x - P.x) * Q2_u.x + (Q_u.y - P.y) * Q2_u.y;
        double uPrime = u - numerator / denominator;
        return uPrime;
    }

    private static double computeMaxError(ArrayList<CanvasPoint> d, int first, int last, CanvasPoint[] bezCurve, double[] u, int[] splitPoint) {
        splitPoint[0] = (last - first + 1) / 2;
        double maxDist = 0.0;
        for (int i = first + 1; i < last; ++i) {
            CanvasPoint P = Bezier.bezierII(3, bezCurve, u[i - first]);
            CanvasPoint v = Bezier.v2SubII(P, d.get(i));
            double dist = Bezier.v2SquaredLength(v);
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            splitPoint[0] = i;
        }
        return maxDist;
    }

    private static CanvasPoint[] generateBezier(ArrayList<CanvasPoint> d, int first, int last, double[] uPrime, CanvasPoint tHat1, CanvasPoint tHat2) {
        CanvasPoint[] bezCurve = new CanvasPoint[4];
        for (int i = 0; i < bezCurve.length; ++i) {
            bezCurve[i] = new CanvasPoint();
        }
        double dist = Bezier.v2DistanceBetween2Points(d.get(last), d.get(first)) / 3.0;
        bezCurve[0] = d.get(first);
        bezCurve[3] = d.get(last);
        Bezier.v2Add(bezCurve[0], Bezier.v2Scale(tHat1, dist), bezCurve[1]);
        Bezier.v2Add(bezCurve[3], Bezier.v2Scale(tHat2, dist), bezCurve[2]);
        return bezCurve;
    }

    private static CanvasPoint bezierII(int degree, CanvasPoint[] V, double t) {
        int i;
        CanvasPoint[] vTemp = new CanvasPoint[degree + 1];
        for (i = 0; i <= degree; ++i) {
            try {
                vTemp[i] = (CanvasPoint)V[i].clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        for (i = 1; i <= degree; ++i) {
            for (int j = 0; j <= degree - i; ++j) {
                vTemp[j].x = (1.0 - t) * vTemp[j].x + t * vTemp[j + 1].x;
                vTemp[j].y = (1.0 - t) * vTemp[j].y + t * vTemp[j + 1].y;
            }
        }
        CanvasPoint q = vTemp[0];
        return q;
    }

    private static double v2DistanceBetween2Points(CanvasPoint a, CanvasPoint b) {
        return Math.sqrt(Bezier.v2SquaredDistanceBetween2Points(a, b));
    }

    private static double v2SquaredDistanceBetween2Points(CanvasPoint a, CanvasPoint b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        return dx * dx + dy * dy;
    }

    private static CanvasPoint v2Scale(CanvasPoint v, double newlen) {
        double len = Bezier.v2Length(v);
        if (len != 0.0) {
            v.x *= newlen / len;
            v.y *= newlen / len;
        }
        return v;
    }

    private static CanvasPoint v2ScaleIII(CanvasPoint v, double s) {
        CanvasPoint result = new CanvasPoint();
        result.x = v.x * s;
        result.y = v.y * s;
        return result;
    }

    private static double v2Length(CanvasPoint a) {
        return Math.sqrt(Bezier.v2SquaredLength(a));
    }

    private static double v2SquaredLength(CanvasPoint a) {
        return a.x * a.x + a.y * a.y;
    }

    private static CanvasPoint v2Add(CanvasPoint a, CanvasPoint b, CanvasPoint c) {
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        return c;
    }

    private static CanvasPoint v2AddII(CanvasPoint a, CanvasPoint b) {
        CanvasPoint c = new CanvasPoint();
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        return c;
    }

    private static CanvasPoint v2Negate(CanvasPoint v) {
        v.x = -v.x;
        v.y = -v.y;
        return v;
    }

    private static double v2Dot(CanvasPoint a, CanvasPoint b) {
        return a.x * b.x + a.y * b.y;
    }

    private static CanvasPoint v2Normalize(CanvasPoint v) {
        double len = Bezier.v2Length(v);
        if (len != 0.0) {
            v.x /= len;
            v.y /= len;
        }
        return v;
    }

    private static CanvasPoint v2SubII(CanvasPoint a, CanvasPoint b) {
        CanvasPoint c = new CanvasPoint();
        c.x = a.x - b.x;
        c.y = a.y - b.y;
        return c;
    }

    private static double b0(double u) {
        double tmp = 1.0 - u;
        return tmp * tmp * tmp;
    }

    private static double b1(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * (tmp * tmp);
    }

    private static double b2(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * u * tmp;
    }

    private static double b3(double u) {
        return u * u * u;
    }
}

