/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.BasicStroke;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.MainFrame;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.serialise.ArrowTypePersistenceDelegate;
import net.perspective.draw.serialise.BasicStrokePersistenceDelegate;
import net.perspective.draw.serialise.DoubleStrokePersistenceDelegate;
import net.perspective.draw.serialise.FigurePersistenceDelegate;
import net.perspective.draw.serialise.FigureTypePersistenceDelegate;
import net.perspective.draw.serialise.InstantPersistenceDelegate;
import net.perspective.draw.serialise.Path2DPersistenceDelegate;
import net.perspective.draw.serialise.RailwayStrokePersistenceDelegate;
import net.perspective.draw.serialise.XMLEncoder;
import net.perspective.draw.util.FileUtils;
import net.perspective.draw.util.ImageUtils;
import net.perspective.draw.util.RailwayStroke;
import net.perspective.draw.workers.Worker;
import org.jhotdraw.geom.DoubleStroke;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public final class WriteOutStreamer
extends SwingWorker
implements Worker {
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final File file;
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private static final Logger logger = Logger.getLogger(WriteOutStreamer.class.getName());

    public WriteOutStreamer(MainFrame application, File file) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = this.canvas.getView();
        this.file = file;
        this.setLengthOfTask(2 + this.view.getImageItems().size());
    }

    protected Object doInBackground() {
        this.current = 0;
        this.done = false;
        this.canceled = false;
        this.statMessage = null;
        this.view.eraseQueuedPictures();
        logger.info("Save started...");
        return new Serialiser();
    }

    @Override
    public void done() {
        logger.info("Save completed.");
        this.ensureEventThread();
        this.application.setStatus("Saved to disk.");
        this.application.getProgress().setVisible(false);
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    @Override
    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    @Override
    public void setLengthOfTask(int l) {
        this.lengthOfTask = l;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel(true);
    }

    final class Serialiser {
        XMLEncoder encoder;
        ZipOutputStream zos = null;
        BeanInfo arrowInfo = null;

        Serialiser() {
            logger.info("Serialisation initialised.");
            try {
                this.make();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
            finally {
                if (this.zos != null) {
                    try {
                        this.zos.close();
                    }
                    catch (IOException e) {
                        logger.info(e.getMessage());
                    }
                }
            }
        }

        public void make() throws IOException {
            this.setBeanInfo();
            List<Integer> maps = this.listOfMapImages(WriteOutStreamer.this.view.getDrawings());
            FileOutputStream fos = new FileOutputStream(WriteOutStreamer.this.file);
            this.zos = new ZipOutputStream(new BufferedOutputStream(fos));
            ZipEntry entry = new ZipEntry("content/pictures.xml");
            this.zos.putNextEntry(entry);
            List<ImageItem> pictures = WriteOutStreamer.this.view.getImageItems();
            this.encoder = new XMLEncoder(this.zos);
            this.encoder.setPersistenceDelegate(Instant.class, new InstantPersistenceDelegate());
            this.encoder.writeObject(pictures);
            this.encoder.finished();
            this.zos.closeEntry();
            ++WriteOutStreamer.this.current;
            this.finishCheck();
            for (int index = 0; index < pictures.size(); ++index) {
                BufferedImage img = pictures.get(index).getImage();
                if (maps.contains(index) && OsmMercator.isRetina()) {
                    img = ImageUtils.rescaleImage(img, 0.5);
                }
                entry = new ZipEntry("images/" + FileUtils.getImageName(index));
                this.zos.putNextEntry(entry);
                try {
                    ImageIO.write((RenderedImage)img, "png", this.zos);
                }
                catch (IllegalArgumentException e) {
                    logger.info("Image file blank.");
                }
                this.zos.closeEntry();
                ++WriteOutStreamer.this.current;
            }
            this.finishCheck();
            entry = new ZipEntry("content/canvas.xml");
            this.zos.putNextEntry(entry);
            List<DrawItem> drawings = WriteOutStreamer.this.view.getDrawings();
            this.encoder = new XMLEncoder(this.zos);
            this.encoder.setPersistenceDelegate(BasicStroke.class, new BasicStrokePersistenceDelegate());
            this.encoder.setPersistenceDelegate(DoubleStroke.class, new DoubleStrokePersistenceDelegate());
            this.encoder.setPersistenceDelegate(RailwayStroke.class, new RailwayStrokePersistenceDelegate());
            this.encoder.setPersistenceDelegate(ArrowType.class, new ArrowTypePersistenceDelegate());
            this.encoder.setPersistenceDelegate(FigureType.class, new FigureTypePersistenceDelegate());
            this.encoder.setPersistenceDelegate(Figure.class, new FigurePersistenceDelegate());
            this.encoder.setPersistenceDelegate(Path2D.Double.class, new Path2DPersistenceDelegate());
            this.encoder.setExceptionListener(exception -> logger.warning(exception.getMessage()));
            this.encoder.writeObject(drawings);
            this.encoder.finished();
            this.zos.closeEntry();
            ++WriteOutStreamer.this.current;
            this.finishCheck();
        }

        public void finishCheck() {
            if (WriteOutStreamer.this.current >= WriteOutStreamer.this.lengthOfTask) {
                WriteOutStreamer.this.done = true;
                WriteOutStreamer.this.current = WriteOutStreamer.this.lengthOfTask;
            }
        }

        private void setBeanInfo() {
            try {
                this.arrowInfo = Introspector.getBeanInfo(ArrowLine.class);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            block12: for (PropertyDescriptor pd : this.arrowInfo.getPropertyDescriptors()) {
                switch (pd.getName()) {
                    case "fillcolor": {
                        pd.setValue("transient", Boolean.TRUE);
                        continue block12;
                    }
                    case "closed": {
                        pd.setValue("transient", Boolean.TRUE);
                        continue block12;
                    }
                    case "type": {
                        pd.setValue("transient", Boolean.TRUE);
                        continue block12;
                    }
                }
            }
        }

        private List<Integer> listOfMapImages(List<DrawItem> drawings) {
            ArrayList<Integer> pictures = new ArrayList<Integer>();
            for (DrawItem item : drawings) {
                if (!(item instanceof StreetMap)) continue;
                StreetMap streetMap = (StreetMap)item;
                pictures.add(streetMap.getImageIndex());
            }
            return pictures;
        }
    }
}

