/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.MainFrame;
import net.perspective.draw.enums.Media;
import net.perspective.draw.util.CanvasPoint;
import org.jfree.svg.SVGGraphics2D;
import org.jfree.svg.SVGHints;

public class SVGWorker
extends SwingWorker {
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final File file;
    private double margin;
    private static final Logger logger = Logger.getLogger(SVGWorker.class.getName());

    public SVGWorker(MainFrame application, File file) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = application.getCanvas().getView();
        this.file = file;
        this.margin = 0.0;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    protected Object doInBackground() {
        logger.info("SVG export started...");
        return new Serialiser();
    }

    @Override
    public void done() {
        logger.info("SVG export completed.");
        this.ensureEventThread();
        this.application.setStatus("Exported to SVG.");
        int max = this.application.getProgress().getMaximum();
        this.application.getProgress().setValue(max);
        this.application.getProgress().setIndeterminate(false);
        this.application.getProgress().setVisible(false);
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    final class Serialiser {
        Serialiser() {
            logger.info("SVG export initialised.");
            this.make();
        }

        public void make() {
            CanvasPoint[] bounds = SVGWorker.this.view.getBounds();
            CanvasPoint start = bounds[0].shifted(-SVGWorker.this.margin, -SVGWorker.this.margin).floor();
            CanvasPoint end = bounds[1].shifted(SVGWorker.this.margin, SVGWorker.this.margin);
            int width = (int)Math.ceil(end.x - start.x);
            int height = (int)Math.ceil(end.y - start.y);
            SVGGraphics2D g2 = new SVGGraphics2D((double)width, (double)height);
            g2.setRenderingHint((RenderingHints.Key)SVGHints.KEY_ELEMENT_ID, (Object)"gesticulate-canvas");
            g2.setRenderingHint((RenderingHints.Key)SVGHints.KEY_ELEMENT_TITLE, (Object)"Gesticulate Drawing");
            g2.setRenderingHint((RenderingHints.Key)SVGHints.KEY_IMAGE_HANDLING, SVGHints.VALUE_IMAGE_HANDLING_EMBED);
            g2.translate(-start.x, -start.y);
            SVGWorker.this.canvas.drawCanvas((Graphics2D)g2, Media.PRINT);
            Object svgElement = g2.getSVGElement();
            String viewBox = String.format("viewBox=\"0 0 %d %d\"", width, height);
            String widthAttr = String.format("width='%.1f'", Float.valueOf(width));
            String heightAttr = String.format("height='%.1f'", Float.valueOf(height));
            svgElement = ((String)svgElement).replace(widthAttr, "width=\"100%\"");
            svgElement = ((String)svgElement).replace(heightAttr, "height=\"100%\"");
            int insertPos = ((String)svgElement).indexOf("<svg") + 4;
            svgElement = ((String)svgElement).substring(0, insertPos) + " " + viewBox + ((String)svgElement).substring(insertPos);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(SVGWorker.this.file), "UTF-8");){
                out.write((String)svgElement);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error writing SVG file: {0}", e.getMessage());
            }
            g2.dispose();
        }
    }
}

