/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.MainFrame;
import net.perspective.draw.svg.SVGUtils;

public class SVGVectorWorker
extends SwingWorker {
    private final MainFrame application;
    private final List<File> files;
    private int success = 0;
    private int filesize = 0;
    private static final Logger logger = Logger.getLogger(SVGVectorWorker.class.getName());

    public SVGVectorWorker(MainFrame application, List<File> files) {
        this.application = application;
        this.files = files;
        this.filesize = files.size();
    }

    protected Object doInBackground() throws Exception {
        logger.info("Loading vector images...");
        return new Deserialiser(this);
    }

    @Override
    public void done() {
        logger.info("SVG import completed.");
        this.ensureEventThread();
        if (this.success > 0) {
            this.application.setStatus(String.valueOf(this.success) + " of " + String.valueOf(this.filesize) + " vector images loaded.");
        } else {
            this.application.setStatus("Vector import failed.");
        }
        int max = this.application.getProgress().getMaximum();
        this.application.getProgress().setValue(max);
        this.application.getProgress().setIndeterminate(false);
        this.application.getProgress().setVisible(false);
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    final class Deserialiser {
        SVGUtils svgreader;

        Deserialiser(SVGVectorWorker this$0) {
            logger.info("SVG deserialisation initialised.");
            this.svgreader = new SVGUtils(this$0.application);
            for (File file : this$0.files) {
                try {
                    this.make(file);
                    ++this$0.success;
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        public void make(File file) throws IOException {
            this.svgreader.parseSVG(file);
        }
    }
}

