/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.image.BufferedImage;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.MainFrame;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Edge;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.GroupedShape;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.util.FileUtils;
import net.perspective.draw.util.ImageUtils;
import net.perspective.draw.util.NanoClock;
import net.perspective.draw.workers.Worker;
import org.apache.commons.beanutils.BeanUtils;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public final class ReadInFunnel
extends SwingWorker
implements Worker {
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final File file;
    private List<DrawItem> drawings;
    private List<ImageItem> pictures;
    private int lengthOfTask;
    private int current = 0;
    private boolean canceled = false;
    private boolean success = false;
    private final Clock clock;
    private final MathContext mathContext;
    private Instant startTime;
    private Instant endTime;
    private static final Logger logger = Logger.getLogger(ReadInFunnel.class.getName());

    public ReadInFunnel(MainFrame application, File file) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = this.canvas.getView();
        this.file = file;
        this.setLengthOfTask(3);
        this.clock = new NanoClock();
        this.mathContext = new MathContext(3, RoundingMode.HALF_UP);
    }

    protected Object doInBackground() {
        this.current = 0;
        this.canceled = false;
        this.success = false;
        logger.info("Open file started...");
        this.startTime = Instant.now(this.clock);
        return new Deserialiser();
    }

    @Override
    public void done() {
        logger.info("Open completed.");
        this.ensureEventThread();
        if (this.success && !this.canceled) {
            for (DrawItem drawitem : this.drawings) {
                DrawItem item = this.checkDrawings(drawitem);
                this.view.setNewItem(item);
                this.view.copyItemToCanvas(item);
            }
        }
        this.endTime = Instant.now(this.clock);
        String duration = String.format(Locale.UK, "%,.0f", BigDecimal.valueOf(Duration.between(this.startTime, this.endTime).toMillis()).round(this.mathContext));
        logger.log(Level.FINEST, "Read elapsed time: {0}ms", duration);
        this.application.setStatus("Opened drawing.");
        this.application.getProgress().setVisible(false);
    }

    /*
     * Unable to fully structure code
     */
    private DrawItem checkDrawings(DrawItem drawing) {
        v0 = drawing;
        Objects.requireNonNull(v0);
        var2_2 = v0;
        var3_3 = 0;
        block2 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrowLine.class, Edge.class, Figure.class}, (Object)var2_2, var3_3)) {
            case 0: {
                arrowLine = (ArrowLine)var2_2;
                item = new Edge();
                try {
                    BeanUtils.copyProperties((Object)item, (Object)arrowLine.getLine());
                    arrowLine.setLine(item);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    ReadInFunnel.logger.warning(e.getMessage());
                }
                arrowLine.setFactory();
                arrowLine.setEndPoints();
                arrowLine.setPath();
                break;
            }
            case 1: {
                edge = (Edge)var2_2;
                edge.setFactory();
                edge.setEndPoints();
                edge.setPath();
                break;
            }
            case 2: {
                figure = (Figure)var2_2;
                switch (1.$SwitchMap$net$perspective$draw$geom$FigureType[figure.getType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        item = new Edge();
                        try {
                            BeanUtils.copyProperties((Object)item, (Object)drawing);
                            figure = item;
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            ReadInFunnel.logger.warning(e.getMessage());
                        }
                        figure.setFactory();
                        figure.setEndPoints();
                        figure.setPath();
                        break block2;
                    }
                }
                figure.setFactory();
                figure.setEndPoints();
                figure.setPath();
                break;
            }
        }
        if (!(drawing instanceof Picture)) ** GOTO lbl-1000
        picture = (Picture)drawing;
        if (!(drawing instanceof StreetMap)) {
            i = picture.getImageIndex();
            this.view.setImageItem(this.pictures.get(i));
        } else if (drawing instanceof StreetMap) {
            streetmap = (StreetMap)drawing;
            i = streetmap.getImageIndex();
            this.view.setImageItem(this.pictures.get(i));
            image = this.view.getImageItems().get(i).getImage();
            if (OsmMercator.isRetina()) {
                img = ImageUtils.rescaleImage(image, 2.0);
                this.view.getImageItems().get(i).setImage(img);
            }
        }
        if (drawing instanceof Grouped) {
            grouped = (Grouped)drawing;
            item = new Grouped();
            for (DrawItem shape : grouped.getDrawItems()) {
                item.addDrawItem(this.checkDrawings(shape));
            }
            item.setAngle(grouped.getAngle());
            item.setVertical(grouped.isVertical());
            item.setTransparency(grouped.getTransparency());
            item.setScale(grouped.getScale());
            drawing = item;
        }
        if (drawing instanceof GroupedShape) {
            groupedShape = (GroupedShape)drawing;
            item = new Grouped();
            for (DrawItem shape : groupedShape.getShapes()) {
                item.addDrawItem(this.checkDrawings(shape));
            }
            item.setAngle(groupedShape.getAngle());
            item.setVertical(groupedShape.isVertical());
            item.setTransparency(groupedShape.getTransparency());
            item.setScale(1.0);
            drawing = item;
        }
        return drawing;
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    @Override
    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    @Override
    public void setLengthOfTask(int l) {
        this.lengthOfTask = l;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel(true);
    }

    final class Deserialiser {
        XMLDecoder decoder;

        Deserialiser() {
            logger.info("Deserialisation initialised.");
            try {
                ReadInFunnel.this.success = true;
                this.make();
            }
            catch (IOException | IllegalStateException | NullPointerException e) {
                logger.warning(e.getMessage());
                ReadInFunnel.this.success = false;
            }
        }

        public void make() throws IOException {
            block12: {
                try (ZipFile zf = new ZipFile(ReadInFunnel.this.file);){
                    ZipEntry ze = zf.getEntry("content/pictures.xml");
                    this.decoder = new XMLDecoder(new BufferedInputStream(zf.getInputStream(ze)));
                    this.decoder.setExceptionListener(exception -> logger.warning(exception.getMessage()));
                    Object obj = this.decoder.readObject();
                    if (obj == null) {
                        throw new IllegalStateException("XMLDecoder returned null object");
                    }
                    if (!(obj instanceof List)) {
                        throw new IllegalStateException("Unexpected object type from XMLDecoder: " + obj.getClass().getName());
                    }
                    List list = (List)obj;
                    ReadInFunnel.this.pictures = new ArrayList<ImageItem>(list);
                    ++ReadInFunnel.this.current;
                    this.finishCheck();
                    int index = 0;
                    for (ImageItem picture : ReadInFunnel.this.pictures) {
                        ze = zf.getEntry("images/" + FileUtils.getImageName(index));
                        try {
                            BufferedImage img = ImageIO.read(new BufferedInputStream(zf.getInputStream(ze)));
                            picture.setImage(img);
                        }
                        catch (IOException e) {
                            logger.warning("Can't read image file.");
                        }
                        ++index;
                    }
                    ++ReadInFunnel.this.current;
                    this.finishCheck();
                    ze = zf.getEntry("content/canvas.xml");
                    this.decoder = new XMLDecoder(new BufferedInputStream(zf.getInputStream(ze)));
                    this.decoder.setExceptionListener(exception -> logger.warning(exception.getMessage()));
                    obj = this.decoder.readObject();
                    if (obj == null) {
                        throw new IllegalStateException("XMLDecoder returned null object");
                    }
                    if (obj instanceof List) {
                        List list2 = (List)obj;
                        ReadInFunnel.this.drawings = new ArrayList<DrawItem>(list2);
                        break block12;
                    }
                    throw new IllegalStateException("Unexpected object type from XMLDecoder: " + obj.getClass().getName());
                }
            }
            ++ReadInFunnel.this.current;
            this.finishCheck();
        }

        public void finishCheck() {
            if (ReadInFunnel.this.current >= ReadInFunnel.this.lengthOfTask) {
                ReadInFunnel.this.current = ReadInFunnel.this.lengthOfTask;
            }
        }
    }
}

