/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.MainFrame;
import net.perspective.draw.enums.Media;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.NanoClock;

public class PNGWorker
extends SwingWorker {
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final File file;
    private boolean opacity;
    private double margin;
    private final Clock clock;
    private final MathContext mathContext;
    private Instant startTime;
    private Instant endTime;
    private static final Logger logger = Logger.getLogger(PNGWorker.class.getName());

    public PNGWorker(MainFrame application, File file) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = application.getCanvas().getView();
        this.file = file;
        this.margin = 0.0;
        this.opacity = true;
        this.clock = new NanoClock();
        this.mathContext = new MathContext(3, RoundingMode.HALF_UP);
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public void setOpacity(boolean opacity) {
        this.opacity = opacity;
    }

    public boolean isOpacity() {
        return this.opacity;
    }

    protected Object doInBackground() throws Exception {
        logger.info("PNG export started...");
        this.startTime = Instant.now(this.clock);
        return new Serialiser();
    }

    @Override
    public void done() {
        logger.info("PNG export completed.");
        this.endTime = Instant.now(this.clock);
        String duration = String.format(Locale.UK, "%,.0f", BigDecimal.valueOf(Duration.between(this.startTime, this.endTime).toMillis()).round(this.mathContext));
        logger.log(Level.FINEST, "PNG export elapsed time: {0}ms", duration);
        this.ensureEventThread();
        this.application.setStatus("Exported to PNG");
        int max = this.application.getProgress().getMaximum();
        this.application.getProgress().setValue(max);
        this.application.getProgress().setIndeterminate(false);
        this.application.getProgress().setVisible(false);
        this.application.enablePNGButton(true);
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    final class Serialiser {
        double scale = 1.375;

        Serialiser() {
            logger.info("PNG export initialised.");
            this.make();
        }

        public void make() {
            CanvasPoint[] bounds = PNGWorker.this.view.getBounds();
            CanvasPoint start = bounds[0].shifted(-PNGWorker.this.margin, -PNGWorker.this.margin).grow(this.scale).floor();
            CanvasPoint end = bounds[1].shifted(PNGWorker.this.margin, PNGWorker.this.margin).grow(this.scale);
            BufferedImage img = new BufferedImage((int)Math.ceil(end.x), (int)Math.ceil(end.y), 2);
            Graphics2D g2 = img.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setBackground(Color.WHITE);
            if (PNGWorker.this.isOpacity()) {
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, img.getWidth(), img.getHeight());
            }
            g2.transform(AffineTransform.getTranslateInstance(0.0, 0.0));
            g2.transform(AffineTransform.getScaleInstance(this.scale, this.scale));
            PNGWorker.this.canvas.drawCanvas(g2, Media.PRINT);
            g2.dispose();
            int width = (int)Math.ceil(end.x - start.x);
            int height = (int)Math.ceil(end.y - start.y);
            BufferedImage image = img.getSubimage((int)Math.floor(start.x), (int)Math.floor(start.y), width, height);
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(PNGWorker.this.file));){
                ImageIO.write((RenderedImage)image, "png", bos);
            }
            catch (IllegalArgumentException e) {
                logger.warning("Failed to write PNG.");
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
    }
}

