/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.MainFrame;
import net.perspective.draw.enums.Media;
import net.perspective.draw.util.CanvasPoint;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.pdf.Version;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class PDFWorker
extends SwingWorker {
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final File file;
    private double margin;
    private static final Logger logger = Logger.getLogger(PDFWorker.class.getName());

    public PDFWorker(MainFrame application, File file) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = this.canvas.getView();
        this.file = file;
        this.margin = 0.0;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    protected Object doInBackground() {
        logger.info("PDF export started...");
        return new Serialiser();
    }

    @Override
    public void done() {
        logger.info("PDF export completed.");
        this.ensureEventThread();
        this.application.setStatus("Exported to PDF.");
        int max = this.application.getProgress().getMaximum();
        this.application.getProgress().setValue(max);
        this.application.getProgress().setIndeterminate(false);
        this.application.getProgress().setVisible(false);
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    final class Serialiser {
        Serialiser() {
            logger.info("PDF export initialised.");
            this.make();
        }

        public void make() {
            CanvasPoint[] bounds = PDFWorker.this.view.getBounds();
            CanvasPoint start = bounds[0].shifted(-PDFWorker.this.margin, -PDFWorker.this.margin).floor();
            CanvasPoint end = bounds[1].shifted(PDFWorker.this.margin, PDFWorker.this.margin);
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(PDFWorker.this.file));){
                PDFDocumentGraphics2D g2 = new PDFDocumentGraphics2D(false);
                g2.getPDFDocument().setPDFVersion(Version.V1_6);
                g2.getPDFDocument().setColorSpace(1000);
                if (g2.getPDFDocument().getProfile().isTransparencyAllowed() != null) {
                    logger.warning("Transparency is not enabled");
                }
                g2.setGraphicContext(new GraphicContext());
                DefaultConfiguration cfg = new DefaultConfiguration("cfg");
                this.configure(g2, (Configuration)cfg);
                int width = (int)Math.ceil(end.x - start.x);
                int height = (int)Math.ceil(end.y - start.y);
                Dimension pageSize = new Dimension(width, height);
                g2.setupDocument((OutputStream)bos, pageSize.width, pageSize.height);
                g2.transform(AffineTransform.getTranslateInstance(-start.x, -start.y));
                g2.setDeviceDPI(72.0f);
                PDFWorker.this.canvas.drawCanvas((Graphics2D)g2, Media.PRINT);
                g2.finish();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
            catch (ConfigurationException e) {
                logger.severe(e.getMessage());
            }
        }

        private void configure(PDFDocumentGraphics2D g2d, Configuration cfg) throws ConfigurationException {
            PDFDocumentGraphics2DConfigurator configurator = new PDFDocumentGraphics2DConfigurator();
            boolean useComplexScriptFeatures = false;
            configurator.configure(g2d, cfg, useComplexScriptFeatures);
        }
    }
}

