/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.workers;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.MainFrame;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.util.FileUtils;
import net.perspective.draw.util.NanoClock;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class ImageLoadWorker
extends SwingWorker {
    private List<BufferedImage> images;
    private final MainFrame application;
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final List<File> imageFiles;
    private double shift;
    private final Clock clock;
    private final MathContext mathContext;
    private Instant startTime;
    private Instant endTime;
    private final int pageWidth = 940;
    private final int pageHeight = 1330;
    private static final Logger logger = Logger.getLogger(ImageLoadWorker.class.getName());

    public ImageLoadWorker(MainFrame application) {
        this.application = application;
        this.canvas = application.getCanvas();
        this.view = this.canvas.getView();
        this.imageFiles = application.getImageFiles();
        this.shift = 20.0;
        this.clock = new NanoClock();
        this.mathContext = new MathContext(3, RoundingMode.HALF_UP);
    }

    protected Object doInBackground() {
        this.startTime = Instant.now(this.clock);
        return new ImageLoader();
    }

    @Override
    public void done() {
        logger.info("Reading images complete.");
        if (!this.images.isEmpty()) {
            for (BufferedImage image : this.images) {
                Picture picture = new Picture(this.shift, this.shift);
                ImageItem item = new ImageItem(image);
                item.setFormat(FileUtils.getExtension(this.imageFiles.get(this.images.indexOf(image))));
                int index = this.view.setImageItem(item);
                double width = image.getWidth();
                double height = image.getHeight();
                double scale = this.getScale(width, height);
                logger.log(Level.FINEST, "Image relative scale: {0}", scale);
                picture.setImage(index, width, height);
                picture.setScale(scale);
                this.view.setNewItem(picture);
                this.view.addItemToCanvas(picture);
                this.shift += 10.0;
            }
            this.endTime = Instant.now(this.clock);
            String duration = String.format(Locale.UK, "%,.0f", BigDecimal.valueOf(Duration.between(this.startTime, this.endTime).toMillis()).round(this.mathContext));
            logger.log(Level.FINEST, "Image load elapsed time: {0}ms", duration);
            this.ensureEventThread();
            this.application.setStatus("Read pictures.");
        }
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("Not Event Dispatch Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage rasterize(File svgFile) throws IOException {
        final BufferedImage[] imagePointer = new BufferedImage[1];
        String css = "svg {shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;}";
        Path cssFile = Files.createTempFile(Files.createTempDirectory("temp-dir", new FileAttribute[0]), "batik-default-override-", ".css", new FileAttribute[0]);
        FileUtils.writeStringToFile(cssFile.toFile(), css);
        TranscodingHints transcoderHints = new TranscodingHints();
        transcoderHints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)cssFile.toUri().toString());
        transcoderHints.put((Object)SVGAbstractTranscoder.KEY_ALLOW_EXTERNAL_RESOURCES, (Object)Boolean.TRUE);
        try {
            TranscoderInput input = new TranscoderInput((InputStream)new FileInputStream(svgFile));
            ImageTranscoder t = new ImageTranscoder(this){

                public BufferedImage createImage(int w, int h) {
                    return new BufferedImage(w, h, 2);
                }

                public void writeImage(BufferedImage image, TranscoderOutput out) throws TranscoderException {
                    imagePointer[0] = image;
                }
            };
            t.setTranscodingHints(transcoderHints);
            t.transcode(input, null);
        }
        catch (TranscoderException ex) {
            logger.log(Level.SEVERE, "Couldn't convert {0}", svgFile.getName());
        }
        finally {
            cssFile.toFile().deleteOnExit();
        }
        return imagePointer[0];
    }

    private double getScale(double width, double height) {
        if (width <= 940.0 && height <= 1330.0) {
            return 1.0;
        }
        if (width <= 940.0 && height > 1330.0) {
            return 1064.0 / height;
        }
        if (width > 940.0 && height <= 1330.0) {
            return 752.0 / width;
        }
        if (width > 940.0 && height > 1330.0) {
            double ratio_w = 940.0 / width;
            double ratio_h = 1330.0 / height;
            if (ratio_w <= ratio_h) {
                return 752.0 / width;
            }
            return 1064.0 / height;
        }
        return 1.0;
    }

    final class ImageLoader {
        ImageLoader() {
            logger.info("Reading images initialised.");
            try {
                this.make();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }

        public void make() throws IOException {
            ImageLoadWorker.this.images = new ArrayList<BufferedImage>();
            for (File file : ImageLoadWorker.this.imageFiles) {
                if (FileUtils.getExtension(file.getName()).equals("svg")) {
                    ImageLoadWorker.this.images.add(ImageLoadWorker.this.rasterize(file));
                    continue;
                }
                ImageLoadWorker.this.images.add(ImageIO.read(file));
            }
        }
    }
}

