/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import net.perspective.draw.util.CanvasPoint;

public class V2 {
    public static CanvasPoint rot(double x, double y, double theta) {
        CanvasPoint vec = new CanvasPoint();
        double rx = Math.cos(theta) * x - Math.sin(theta) * y;
        double ry = Math.sin(theta) * x + Math.cos(theta) * y;
        vec.setLocation(rx, ry);
        return vec;
    }

    public static double dot(CanvasPoint a, CanvasPoint b) {
        return a.x * b.x + a.y * b.y;
    }

    public static double L2(CanvasPoint p) {
        return Math.hypot(p.x, p.y);
    }

    public static double L2(double x, double y) {
        return Math.hypot(x, y);
    }

    public static CanvasPoint rot90(CanvasPoint p) {
        return new CanvasPoint(-p.y, p.x);
    }

    public static double declination(double x, double y) {
        CanvasPoint A = new CanvasPoint(x, y);
        double h1 = V2.L2(A);
        CanvasPoint q1 = new CanvasPoint(A.x / h1, A.y / h1);
        CanvasPoint q2 = new CanvasPoint(1.0, 0.0);
        double cos_t = V2.dot(q1, q2);
        double sin_t = V2.dot(V2.rot90(q1), q2);
        return Math.atan2(sin_t, cos_t);
    }

    public static double norm_angle(double angle) {
        while (angle > Math.PI || angle < -Math.PI) {
            if (angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (!(angle < -Math.PI)) continue;
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static int quadrant(double angle) {
        int offset = -1;
        if ((angle = V2.norm_angle(angle)) >= 0.0 && angle < 1.5707963267948966) {
            offset = 0;
        }
        if (angle >= 1.5707963267948966 && angle < Math.PI) {
            offset = 1;
        }
        if (angle >= -Math.PI && angle < -1.5707963267948966 || Math.abs(angle) == Math.PI) {
            offset = 2;
        }
        if (angle >= -1.5707963267948966 && angle < 0.0) {
            offset = 3;
        }
        return offset;
    }

    public static int side(double angle) {
        int offset = -1;
        if ((angle = V2.norm_angle(angle)) >= 0.7853981633974483 && angle < 2.356194490192345) {
            offset = 0;
        }
        if (angle >= 2.356194490192345 && angle < Math.PI) {
            offset = 1;
        }
        if (angle >= -Math.PI && angle < -2.356194490192345) {
            offset = 1;
        }
        if (angle >= -2.356194490192345 && angle < -0.7853981633974483) {
            offset = 2;
        }
        if (angle >= -0.7853981633974483 && angle < 0.7853981633974483) {
            offset = 3;
        }
        return offset;
    }

    public static int octet(double angle) {
        int offset = -1;
        if ((angle = V2.norm_angle(angle)) >= -0.39269908169872414 && angle < 0.39269908169872414) {
            offset = 0;
        }
        if (angle >= 0.39269908169872414 && angle < 1.1780972450961724) {
            offset = 1;
        }
        if (angle >= 1.1780972450961724 && angle < 1.9634954084936207) {
            offset = 2;
        }
        if (angle >= 1.9634954084936207 && angle < 2.748893571891069) {
            offset = 3;
        }
        if (angle >= 2.748893571891069 && angle < Math.PI) {
            offset = 4;
        }
        if (angle >= -Math.PI && angle < -2.748893571891069) {
            offset = 4;
        }
        if (angle >= -2.748893571891069 && angle < -1.9634954084936207) {
            offset = 5;
        }
        if (angle >= -1.9634954084936207 && angle < -1.1780972450961724) {
            offset = 6;
        }
        if (angle >= -1.1780972450961724 && angle < -0.39269908169872414) {
            offset = 7;
        }
        return offset;
    }

    private V2() {
    }
}

