/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SymbolStroke
implements Stroke,
Serializable {
    transient BasicStroke _basicStroke = null;
    transient BasicStroke _symbolStroke = null;
    transient Shape _symbol = null;
    public double _symbolSeparation = 0.0;
    public boolean _startWithSymbol = false;
    public boolean _drawBasicLine = true;
    public boolean _symbolFillOnly = false;

    public SymbolStroke() {
        this._basicStroke = new BasicStroke();
        this._symbolStroke = new BasicStroke();
    }

    public SymbolStroke(BasicStroke basicStroke) {
        this._basicStroke = basicStroke;
    }

    public SymbolStroke(Shape symbol, double symbolSeparation, boolean startWithSymbol, boolean drawBasicLine, boolean symbolFillOnly) {
        this();
        this._symbol = symbol;
        this._symbolSeparation = symbolSeparation;
        if (this._symbolSeparation <= 0.0) {
            throw new IllegalArgumentException("symbolSeparation must be greater than 0.0");
        }
        this._startWithSymbol = startWithSymbol;
        this._drawBasicLine = drawBasicLine;
        this._symbolFillOnly = symbolFillOnly;
    }

    public SymbolStroke(BasicStroke basicStroke, BasicStroke symbolStroke, Shape symbol, double symbolSeparation, boolean startWithSymbol, boolean drawBasicLine, boolean symbolFillOnly) {
        this(symbol, symbolSeparation, startWithSymbol, drawBasicLine, symbolFillOnly);
        this._basicStroke = basicStroke;
        if (this._basicStroke == null) {
            throw new IllegalArgumentException("basicStroke cannot be null");
        }
        this._symbolStroke = symbolStroke;
        if (this._symbolStroke == null) {
            throw new IllegalArgumentException("symbolStroke cannot be null");
        }
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        Shape basicShape = this._basicStroke.createStrokedShape(shape);
        if (this._symbol == null) {
            return basicShape;
        }
        GeneralPath retVal = this._drawBasicLine ? new GeneralPath(basicShape) : new GeneralPath();
        double[] pt = new double[6];
        Point2D.Double startPt = null;
        Point2D.Double prevPt = null;
        Point2D.Double currPt = null;
        double prevDist = 0.0;
        double currDist = 0.0;
        boolean newSegment = false;
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            int type = pi.currentSegment(pt);
            block0 : switch (type) {
                case 0: {
                    currPt = new Point2D.Double(pt[0], pt[1]);
                    startPt = new Point2D.Double(pt[0], pt[1]);
                    currDist = this._symbolSeparation / 2.0;
                    newSegment = true;
                    break;
                }
                case 1: 
                case 4: {
                    prevPt = currPt;
                    switch (type) {
                        case 1: {
                            currPt = new Point2D.Double(pt[0], pt[1]);
                            break;
                        }
                        case 4: {
                            currPt = startPt;
                        }
                    }
                    if (prevPt == null) break;
                    prevDist = currDist;
                    currDist += prevPt.distance(currPt);
                    while (currDist >= this._symbolSeparation) {
                        Shape symbolShape;
                        double radius = this._symbolSeparation - prevDist;
                        Point2D.Double center = prevPt;
                        Line2D.Double line = new Line2D.Double(prevPt, currPt);
                        Point2D.Double intersect = SymbolStroke.intersectLineAndCircle(center, radius, line);
                        if (newSegment && this._startWithSymbol) {
                            symbolShape = this.getStrokedSymbolShape(line, prevPt);
                            retVal.append(symbolShape, false);
                            newSegment = false;
                        }
                        if (intersect == null) {
                            currDist = 0.0;
                            break block0;
                        }
                        symbolShape = this.getStrokedSymbolShape(line, intersect);
                        retVal.append(symbolShape, false);
                        prevDist = 0.0;
                        prevPt = intersect;
                        currDist -= this._symbolSeparation;
                    }
                    break;
                }
            }
            pi.next();
        }
        return retVal;
    }

    protected Shape getStrokedSymbolShape(Line2D.Double line, Point2D.Double intersect) {
        double rotation = Math.atan2(line.x1 - line.x2, line.y2 - line.y1) - 1.5707963267948966;
        AffineTransform rt = AffineTransform.getRotateInstance(rotation);
        Shape rotatedSymbol = rt.createTransformedShape(this._symbol);
        AffineTransform tt = AffineTransform.getTranslateInstance(intersect.x, intersect.y);
        Shape transformedSymbol = tt.createTransformedShape(rotatedSymbol);
        Shape symbolShape = this._symbolStroke.createStrokedShape(transformedSymbol);
        if (this._symbolFillOnly) {
            return transformedSymbol;
        }
        return symbolShape;
    }

    public static Point2D.Double intersectLineAndCircle(Point2D.Double center, double radius, Line2D.Double line) {
        double baX = line.x2 - line.x1;
        double acX = line.x1 - center.x;
        double baY = line.y2 - line.y1;
        double acY = line.y1 - center.y;
        double bBy2 = baX * acX + baY * acY;
        double a = baX * baX + baY * baY;
        double pBy2 = bBy2 / a;
        double c = acX * acX + acY * acY - radius * radius;
        double q = c / a;
        double disc = pBy2 * pBy2 - q;
        if (disc < 0.0) {
            return null;
        }
        double tmpSqrt = Math.sqrt(disc);
        double abScalingFactor1 = -pBy2 + tmpSqrt;
        double abScalingFactor2 = -pBy2 - tmpSqrt;
        Point2D.Double p1 = new Point2D.Double(line.x1 - baX * abScalingFactor1, line.y1 - baY * abScalingFactor1);
        if (disc == 0.0) {
            return p1;
        }
        Point2D.Double p2 = new Point2D.Double(line.x1 - baX * abScalingFactor2, line.y1 - baY * abScalingFactor2);
        return p2;
    }

    public void set_symbol(Shape s) {
        this._symbol = s;
    }

    public Shape get_symbol() {
        return this._symbol;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._basicStroke = (BasicStroke)SymbolStroke.readStroke(in);
        this._symbolStroke = (BasicStroke)SymbolStroke.readStroke(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SymbolStroke.writeStroke(this._basicStroke, out);
        SymbolStroke.writeStroke(this._symbolStroke, out);
    }

    public static Stroke readStroke(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Stroke result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c = (Class)stream.readObject();
            if (c.equals(BasicStroke.class)) {
                float width = stream.readFloat();
                int cap = stream.readInt();
                int join = stream.readInt();
                float miterLimit = stream.readFloat();
                float[] dash = (float[])stream.readObject();
                float dashPhase = stream.readFloat();
                result = new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
            } else {
                result = (Stroke)stream.readObject();
            }
        }
        return result;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream stream) throws IOException {
        if (stroke != null) {
            stream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)stroke;
                stream.writeObject(BasicStroke.class);
                stream.writeFloat(s.getLineWidth());
                stream.writeInt(s.getEndCap());
                stream.writeInt(s.getLineJoin());
                stream.writeFloat(s.getMiterLimit());
                stream.writeObject(s.getDashArray());
                stream.writeFloat(s.getDashPhase());
            } else {
                stream.writeObject(stroke.getClass());
                stream.writeObject(stroke);
            }
        } else {
            stream.writeBoolean(true);
        }
    }
}

