/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.util.ArrayList;
import java.util.List;
import net.perspective.draw.util.CanvasPoint;

public class Spline {
    static int N;
    static double[] Px;
    static double[] Py;
    static double[] dx;
    static double[] dy;
    static double[] Ax;
    static double[] Ay;
    static double[] Bi;

    private Spline() {
    }

    public static List<CanvasPoint> getControlPoints(List<CanvasPoint> points) {
        Spline.makeSpline(points);
        return Spline.getCPoints();
    }

    private static void makeSpline(List<CanvasPoint> points) {
        N = points.size();
        Px = new double[N];
        Py = new double[N];
        dx = new double[N];
        dy = new double[N];
        for (int i = 0; i < N; ++i) {
            CanvasPoint point = points.get(i);
            Spline.Px[i] = point.getX();
            Spline.Py[i] = point.getY();
        }
        Spline.dx[0] = (Px[1] - Px[0]) / 3.0;
        Spline.dy[0] = (Py[1] - Py[0]) / 3.0;
        Spline.dx[Spline.N - 1] = (Px[N - 1] - Px[N - 2]) / 3.0;
        Spline.dy[Spline.N - 1] = (Py[N - 1] - Py[N - 2]) / 3.0;
    }

    private static List<CanvasPoint> getCPoints() {
        int i;
        Ax = new double[N];
        Ay = new double[N];
        Bi = new double[N];
        Spline.Bi[1] = -0.25;
        Spline.Ax[1] = (Px[2] - Px[0] - dx[0]) / 4.0;
        Spline.Ay[1] = (Py[2] - Py[0] - dy[0]) / 4.0;
        for (i = 2; i < N - 1; ++i) {
            Spline.Bi[i] = -1.0 / (4.0 + Bi[i - 1]);
            Spline.Ax[i] = -(Px[i + 1] - Px[i - 1] - Ax[i - 1]) * Bi[i];
            Spline.Ay[i] = -(Py[i + 1] - Py[i - 1] - Ay[i - 1]) * Bi[i];
        }
        for (i = N - 2; i > 0; --i) {
            Spline.dx[i] = Ax[i] + dx[i + 1] * Bi[i];
            Spline.dy[i] = Ay[i] + dy[i + 1] * Bi[i];
        }
        ArrayList<CanvasPoint> cPoints = new ArrayList<CanvasPoint>();
        cPoints.add(new CanvasPoint(Px[0] + dx[0], Py[0] + dy[0]));
        for (int i2 = 1; i2 < N - 1; ++i2) {
            cPoints.add(new CanvasPoint(Px[i2] - dx[i2], Py[i2] - dy[i2]));
            cPoints.add(new CanvasPoint(Px[i2] + dx[i2], Py[i2] + dy[i2]));
        }
        cPoints.add(new CanvasPoint(Px[N - 1] - dx[N - 1], Py[N - 1] - dy[N - 1]));
        return cPoints;
    }
}

