/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;

public class ReplacingReader
extends FilterReader {
    LinkedList<Integer> inQueue = new LinkedList();
    LinkedList<Integer> outQueue = new LinkedList();
    final byte[] search;
    final byte[] replacement;

    public ReplacingReader(InputStreamReader in, byte[] search, byte[] replacement) {
        super(in);
        this.search = search;
        this.replacement = replacement;
    }

    private boolean isMatchFound() {
        Iterator inIter = this.inQueue.iterator();
        for (int i = 0; i < this.search.length; ++i) {
            if (inIter.hasNext() && this.search[i] == (Integer)inIter.next()) continue;
            return false;
        }
        return true;
    }

    private void readAhead() throws IOException {
        while (this.inQueue.size() < this.search.length) {
            int next = super.read();
            this.inQueue.offer(next);
            if (next != -1) continue;
            break;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.outQueue.isEmpty()) {
            this.readAhead();
            if (this.isMatchFound()) {
                for (int i = 0; i < this.search.length; ++i) {
                    this.inQueue.remove();
                }
                for (byte b : this.replacement) {
                    this.outQueue.offer(Integer.valueOf(b));
                }
            } else {
                this.outQueue.add(this.inQueue.remove());
            }
        }
        return this.outQueue.remove();
    }
}

