/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.perspective.draw.util.SymbolStroke;
import org.jhotdraw.geom.DoubleStroke;

public class RailwayStroke
implements Stroke,
Serializable {
    public DoubleStroke dblDrawItem;
    public SymbolStroke railDrawItem;
    transient BasicStroke stroke;
    public float span;
    public float strokeWidth;

    public RailwayStroke() {
    }

    public RailwayStroke(float width1, float width2) {
        this.railDrawItem = new SymbolStroke(new BasicStroke(3.0f), new BasicStroke(3.0f), new Line2D.Double(0.0, 5.0, 0.0, -5.0), 8.0, false, false, false);
        this.span = width1;
        this.strokeWidth = width2;
        this.stroke = new BasicStroke(width2);
        this.dblDrawItem = new DoubleStroke(width1, width2);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath newDrawItem = new GeneralPath();
        newDrawItem.append(this.dblDrawItem.createStrokedShape(shape), false);
        newDrawItem.append(this.railDrawItem.createStrokedShape(shape), false);
        return newDrawItem;
    }

    public void setSpan(float s) {
        this.span = s;
    }

    public float getSpan() {
        return this.span;
    }

    public void setStrokeWidth(float w) {
        this.strokeWidth = w;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setDblDrawItem(DoubleStroke d) {
        this.dblDrawItem = d;
    }

    public DoubleStroke getDblDrawItem() {
        return this.dblDrawItem;
    }

    public void setRailDrawItem(SymbolStroke r) {
        this.railDrawItem = r;
    }

    public SymbolStroke getRailDrawItem() {
        return this.railDrawItem;
    }

    public void setStroke(BasicStroke s) {
        this.stroke = s;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = (BasicStroke)RailwayStroke.readStroke(in);
        this.railDrawItem = new SymbolStroke(new BasicStroke(3.0f), new BasicStroke(3.0f), new Line2D.Double(0.0, 5.0, 0.0, -5.0), 8.0, false, false, false);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        RailwayStroke.writeStroke(this.stroke, out);
    }

    public static Stroke readStroke(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Stroke result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c = (Class)stream.readObject();
            if (c.equals(BasicStroke.class)) {
                float width = stream.readFloat();
                int cap = stream.readInt();
                int join = stream.readInt();
                float miterLimit = stream.readFloat();
                float[] dash = (float[])stream.readObject();
                float dashPhase = stream.readFloat();
                result = new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
            } else {
                result = (Stroke)stream.readObject();
            }
        }
        return result;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream stream) throws IOException {
        if (stroke != null) {
            stream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)stroke;
                stream.writeObject(BasicStroke.class);
                stream.writeFloat(s.getLineWidth());
                stream.writeInt(s.getEndCap());
                stream.writeInt(s.getLineJoin());
                stream.writeFloat(s.getMiterLimit());
                stream.writeObject(s.getDashArray());
                stream.writeFloat(s.getDashPhase());
            } else {
                stream.writeObject(stroke.getClass());
                stream.writeObject(stroke);
            }
        } else {
            stream.writeBoolean(true);
        }
    }
}

