/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.V2;

public class R2 {
    static ContainsType[] flip0Array = new ContainsType[]{ContainsType.TL, ContainsType.BR, ContainsType.BL, ContainsType.TR};
    static ContainsType[] flip1Array = new ContainsType[]{ContainsType.TR, ContainsType.BL, ContainsType.BR, ContainsType.TL};
    static ContainsType[] flip2Array = new ContainsType[]{ContainsType.BR, ContainsType.BL, ContainsType.TR, ContainsType.TL};
    static ContainsType[] flip3Array = new ContainsType[]{ContainsType.TL, ContainsType.BR, ContainsType.BL, ContainsType.TR};
    static ContainsType[] flip4Array = new ContainsType[]{ContainsType.BL, ContainsType.BR, ContainsType.TL, ContainsType.TR};
    static ContainsType[] swap0Array = new ContainsType[]{ContainsType.TT, ContainsType.LL, ContainsType.BB, ContainsType.RR};
    static ContainsType[] swap1Array = new ContainsType[]{ContainsType.TT, ContainsType.RR, ContainsType.BB, ContainsType.LL};
    static ContainsType[] swap2Array = new ContainsType[]{ContainsType.LL, ContainsType.BB, ContainsType.RR, ContainsType.TT};
    static ContainsType[] swap3Array = new ContainsType[]{ContainsType.TT, ContainsType.RR, ContainsType.BB, ContainsType.LL};
    static ContainsType[] swap4Array = new ContainsType[]{ContainsType.LL, ContainsType.BB, ContainsType.RR, ContainsType.TT};
    static int[] flip1 = new int[]{0, 1, 1, -1};
    static int[] flip2 = new int[]{1, 0, 1, 1};
    static int[] flip3 = new int[]{0, -1, -1, 1};
    static int[] flip4 = new int[]{-1, 0, -1, -1};

    public static int quadrant(CanvasPoint vertex, CanvasPoint centre) {
        double theta = V2.declination(vertex.x - centre.x, vertex.y - centre.y);
        return V2.quadrant(theta);
    }

    public static int quarter(CanvasPoint edge, CanvasPoint centre) {
        double theta = V2.declination(edge.x - centre.x, edge.y - centre.y);
        return V2.side(theta);
    }

    public static int octant(CanvasPoint vertex, CanvasPoint centre) {
        double theta = V2.declination(vertex.x - centre.x, vertex.y - centre.y);
        return V2.octet(theta);
    }

    public static ContainsType permute(ContainsType contains, int quad) {
        contains = switch (quad) {
            case 0 -> R2.flip1(contains, quad);
            case 1 -> R2.flip2(contains, quad);
            case 2 -> R2.flip3(contains, quad);
            case 3 -> R2.flip4(contains, quad);
            default -> ContainsType.NONE;
        };
        return contains;
    }

    public static ContainsType mutate(ContainsType contains, int quad) {
        contains = switch (quad) {
            case 0 -> R2.swap1(contains, quad);
            case 1 -> R2.swap2(contains, quad);
            case 2 -> R2.swap3(contains, quad);
            case 3 -> R2.swap4(contains, quad);
            default -> ContainsType.NONE;
        };
        return contains;
    }

    public static int[] flip(int quad) {
        int[] flip = switch (quad) {
            case 0 -> flip1;
            case 1 -> flip2;
            case 2 -> flip3;
            case 3 -> flip4;
            default -> flip3;
        };
        return flip;
    }

    private static ContainsType flip1(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)flip0Array[i])) continue;
            index = i;
        }
        return flip1Array[(index - quad + 4) % 4];
    }

    private static ContainsType flip2(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)flip0Array[i])) continue;
            index = i;
        }
        return flip2Array[(index - quad + 4) % 4];
    }

    private static ContainsType flip3(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)flip0Array[i])) continue;
            index = i;
        }
        return flip3Array[(index - quad + 4) % 4];
    }

    private static ContainsType flip4(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)flip0Array[i])) continue;
            index = i;
        }
        return flip4Array[(index - quad + 4) % 4];
    }

    private static ContainsType swap1(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)swap0Array[i])) continue;
            index = i;
        }
        return swap1Array[(index - quad + 4) % 4];
    }

    private static ContainsType swap2(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)swap0Array[i])) continue;
            index = i;
        }
        return swap2Array[(index - quad + 4) % 4];
    }

    private static ContainsType swap3(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)swap0Array[i])) continue;
            index = i;
        }
        return swap3Array[(index - quad + 4) % 4];
    }

    private static ContainsType swap4(ContainsType type, int quad) {
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!type.equals((Object)swap0Array[i])) continue;
            index = i;
        }
        return swap4Array[(index - quad + 4) % 4];
    }

    private R2() {
    }
}

