/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage createCompatibleImage(int width, int height, double multiplier) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration gc = device.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(Math.toIntExact(Math.round((double)width * multiplier)), Math.toIntExact(Math.round((double)height * multiplier)), 3);
        return image;
    }

    public static BufferedImage rescaleImage(BufferedImage img, double multiplier) {
        BufferedImage image = ImageUtils.createCompatibleImage(img.getWidth(), img.getHeight(), multiplier);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform op = new AffineTransform();
        op.setToScale(multiplier, multiplier);
        g.drawImage(img, op, null);
        g.dispose();
        return image;
    }
}

