/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.text.Editor;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.V2;

public class G2 {
    private G2() {
    }

    public static void drawRotationPivot(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform defaultTransform = g2.getTransform();
        CanvasView view = canvas.getView();
        DrawItem item = view.getDrawings().get(view.getSelected());
        CanvasPoint centre = item.rotationCentre();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(centre.x, centre.y);
        transform.rotate(item.getAngle() + (item.isVertical() ? -1.5707963267948966 : 0.0));
        g2.transform(transform);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(canvas.getCanvasBackgroundColor());
        g2.fill(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        g2.setColor(canvas.getThemeAccentColor());
        g2.draw(new Line2D.Double(0.0, 0.0, 0.0, 0.0));
        g2.draw(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        g2.draw(new Line2D.Double(-6.0, 0.0, -3.0, 0.0));
        g2.draw(new Line2D.Double(3.0, 0.0, 6.0, 0.0));
        g2.draw(new Line2D.Double(0.0, -6.0, 0.0, -3.0));
        g2.draw(new Line2D.Double(0.0, 3.0, 0.0, 6.0));
        g2.setTransform(defaultTransform);
    }

    public static void highlightText(Graphics2D g2, DrawingCanvas canvas, DrawItem item) {
        AffineTransform rotation;
        AffineTransform translate = new AffineTransform();
        AffineTransform defaultTransform = g2.getTransform();
        TextLayout layout = canvas.getTextLayout(item);
        CanvasPoint axis = item.rotationCentre();
        CanvasPoint offset = new CanvasPoint(0.0, item.getEnd().getY() - (double)layout.getDescent());
        offset = V2.rot(offset.x, offset.y, item.getAngle());
        if (item.isVertical()) {
            offset = V2.rot(offset.x, offset.y, -1.5707963267948966);
            translate.setToTranslation(axis.x + offset.x, axis.y + offset.y);
            rotation = new AffineTransform();
            rotation.setToRotation(-1.5707963267948966);
            translate.concatenate(rotation);
        } else {
            translate.setToTranslation(axis.x + offset.x, axis.y + offset.y);
        }
        rotation = new AffineTransform();
        rotation.setToRotation(item.getAngle());
        translate.concatenate(rotation);
        g2.transform(translate);
        Editor editor = canvas.getView().getTextController().getEditor();
        if (editor.getCaretStart() == editor.getCaretEnd()) {
            Shape[] carets = layout.getCaretShapes(editor.getCaretStart());
            g2.setColor(Color.black);
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.draw(carets[0]);
        } else {
            Shape textSelection = layout.getLogicalHighlightShape(editor.getCaretStart(), editor.getCaretEnd());
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
            g2.setComposite(ac);
            g2.setColor(new Color(110, 165, 232));
            g2.fill(textSelection);
            ac = AlphaComposite.getInstance(3, 1.0f);
            g2.setComposite(ac);
        }
        g2.setTransform(defaultTransform);
    }

    public static void drawGridLayout(Graphics2D g2, DrawingCanvas canvas) {
        int i;
        Color majorColor;
        Color minorColor;
        double width = 10.0;
        double height = 10.0;
        Color color = canvas.getBackground();
        int rgb = color.getRGB();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (rgb < -8355712) {
            minorColor = new Color((float)(r <= 248 ? r + 7 : 255) / 255.0f, (float)(g <= 248 ? g + 7 : 255) / 255.0f, (float)(b <= 248 ? b + 7 : 255) / 255.0f, 1.0f);
            majorColor = new Color((float)(r <= 241 ? r + 14 : 255) / 255.0f, (float)(g <= 241 ? g + 14 : 255) / 255.0f, (float)(b <= 241 ? b + 14 : 255) / 255.0f, 1.0f);
        } else {
            minorColor = new Color((float)(r >= 12 ? r - 12 : 0) / 255.0f, (float)(g >= 12 ? g - 12 : 0) / 255.0f, (float)(b >= 12 ? b - 12 : 0) / 255.0f, 1.0f);
            majorColor = new Color((float)(r >= 45 ? r - 45 : 0) / 255.0f, (float)(g >= 45 ? g - 45 : 0) / 255.0f, (float)(b >= 45 ? b - 45 : 0) / 255.0f, 1.0f);
        }
        int majorGridSpacing = 5;
        Dimension bounds = canvas.getSize();
        CanvasPoint origin = new CanvasPoint(0.0, 0.0);
        CanvasPoint point = new CanvasPoint();
        g2.setColor(minorColor);
        int m = (int)((origin.x + (double)bounds.width) / width) + 1;
        for (i = (int)(origin.x / width); i <= m; ++i) {
            g2.setColor(i % majorGridSpacing == 0 ? majorColor : minorColor);
            point.x = width * (double)i;
            g2.drawLine((int)point.x, 0, (int)point.x, bounds.height);
        }
        g2.setColor(minorColor);
        m = (int)((origin.y + (double)bounds.height) / height) + 1;
        for (i = (int)(origin.y / height); i <= m; ++i) {
            g2.setColor(i % majorGridSpacing == 0 ? majorColor : minorColor);
            point.y = height * (double)i;
            g2.drawLine(0, (int)point.y, bounds.width, (int)point.y);
        }
    }
}

