/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class FileUtils {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";
    public static final String svg = "svg";
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());

    private FileUtils() {
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File cleanseFileName(File file, String extension) {
        Object fileName = file.getName();
        Pattern extPattern = Pattern.compile("\\.(\\w+)$");
        Matcher matcher = extPattern.matcher(file.getName());
        String ext = matcher.find() ? matcher.group(1).toLowerCase() : "blank";
        if (!ext.equals("blank")) {
            fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46));
        }
        fileName = (String)fileName + "." + extension;
        File f = new File(file.getParent(), (String)fileName);
        return f;
    }

    public static String getImageName(int index) {
        StringBuilder name = new StringBuilder();
        Formatter formatter = new Formatter(name);
        formatter.format("%04d", index);
        name.append(".png");
        return name.insert(0, "Image").toString();
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = FileUtils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.log(Level.WARNING, "Couldn''t find file: {0}", path);
        return null;
    }

    public static ImageIcon createMultiDpiImageIcon(String path) {
        String name = FileUtils.getNameWithoutExtension(path);
        String ext = FileUtils.getExtension(path);
        String path2x = name + "@2x." + ext;
        return FileUtils.getMultiIconResource(path, path2x);
    }

    private static ImageIcon getMultiIconResource(String path, String path2x) {
        try {
            Image img1x = FileUtils.createImage(path);
            Image img2x = FileUtils.createImage(path2x);
            BaseMultiResolutionImage image = new BaseMultiResolutionImage(img1x, img2x);
            return new ImageIcon(image);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }

    private static Image createImage(String path) throws IOException {
        URL imgURL = FileUtils.class.getResource(path);
        if (imgURL != null) {
            BufferedImage image = ImageIO.read(imgURL);
            return image;
        }
        logger.log(Level.WARNING, "Couldn''t find file: {0}", path);
        return null;
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String getExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static void writeStringToFile(File file, String data) {
        try (PrintWriter out = new PrintWriter(file);){
            out.write(data);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, "Couldn't locate file {0}", file.getAbsoluteFile());
        }
    }
}

