/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.util;

import java.io.Serializable;
import net.perspective.draw.util.V2;

public class CanvasPoint
implements Serializable,
Cloneable {
    public double x;
    public double y;
    private static final long serialVersionUID = 1L;

    public CanvasPoint() {
        this(0.0, 0.0);
    }

    public CanvasPoint(double u, double v) {
        this.x = u;
        this.y = v;
    }

    public void setX(double u) {
        this.x = u;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double v) {
        this.y = v;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double u, double v) {
        this.x = u;
        this.y = v;
    }

    public void translate(double u, double v) {
        this.x += u;
        this.y += v;
    }

    public void scale(double sx, double sy) {
        this.x *= sx;
        this.y *= sy;
    }

    public CanvasPoint grow(double scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public CanvasPoint shifted(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public CanvasPoint floor() {
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        return this;
    }

    public void rotate(double angle) {
        CanvasPoint point = V2.rot(this.x, this.y, angle);
        this.x = point.x;
        this.y = point.y;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "[x: " + String.valueOf(this.x) + " y: " + String.valueOf(this.y) + "]";
    }
}

