/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.perspective.draw.geom.Text;
import net.perspective.draw.text.Editor;

public class TextEditor
implements Editor {
    private String text;
    private String clipboard = "";
    private int caretstart = 0;
    private int caretend = 0;

    @Override
    public void editText(Text item) {
        Pattern parpattern = Pattern.compile("(<p>)+(.*)(</p>)+", 32);
        Matcher matcher = parpattern.matcher(item.getText());
        if (matcher.find()) {
            String content = matcher.group(2);
            content = content.replaceAll("<(.|\n)*?>", "");
            content = content.replaceAll("&amp;", "&");
            content = content.replaceAll("&lt;", "<");
            this.text = content = content.replaceAll("&gt;", ">");
        } else {
            this.text = item.getText();
        }
    }

    @Override
    public void commitText(Text item) {
        item.setText(this.text);
    }

    @Override
    public String readPlainText() {
        return this.text;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public void cutText() {
        String newText = this.text.substring(0, this.caretstart) + this.text.substring(this.caretend);
        this.clipboard = this.text.substring(this.caretstart, this.caretend);
        this.text = newText.length() == 0 ? " " : newText;
        this.caretend = this.caretstart;
    }

    @Override
    public void copyText() {
        this.clipboard = this.text.substring(this.caretstart, this.caretend);
    }

    @Override
    public void pasteText() {
        String endText;
        String startText = this.text.substring(0, this.caretstart);
        String newText = startText + this.clipboard + (endText = this.text.substring(this.caretend));
        this.text = newText.length() == 0 ? " " : newText;
        this.caretstart = this.caretend = this.caretstart + this.clipboard.length();
    }

    @Override
    public void backSpace() {
        String newText;
        if (this.caretstart == this.caretend) {
            if (this.caretstart > 0) {
                newText = this.text.substring(0, this.caretstart - 1) + this.text.substring(this.caretend);
                --this.caretstart;
            } else {
                newText = this.text.substring(0, this.caretstart) + this.text.substring(this.caretend);
            }
        } else {
            newText = this.text.substring(0, this.caretstart) + this.text.substring(this.caretend);
        }
        this.text = newText.length() == 0 ? " " : newText;
        this.caretend = this.caretstart;
    }

    @Override
    public void deleteChar() {
        String newText = this.caretend < this.text.length() ? this.text.substring(0, this.caretstart) + this.text.substring(this.caretend + 1) : this.text.substring(0, this.caretstart) + this.text.substring(this.caretend);
        this.text = newText.length() == 0 ? " " : newText;
        this.caretend = this.caretstart;
    }

    @Override
    public void insertChar(char c) {
        String startText = this.text.substring(0, this.caretstart);
        String endText = this.text.substring(this.caretend);
        String newText = startText + String.valueOf(c) + endText;
        this.text = newText.length() == 0 ? " " : newText;
        ++this.caretstart;
        this.caretend = this.caretstart;
    }

    @Override
    public void insertText(String string) {
        String endText;
        String startText = this.text.substring(0, this.caretstart);
        String newText = startText + string + (endText = this.text.substring(this.caretend));
        this.text = newText.length() == 0 ? " " : newText;
        this.caretstart = this.caretend = this.caretstart + string.length();
    }

    @Override
    public void setCaretStart(int s) {
        this.caretstart = s;
    }

    @Override
    public int getCaretStart() {
        return this.caretstart;
    }

    @Override
    public void setCaretEnd(int e) {
        this.caretend = e;
    }

    @Override
    public int getCaretEnd() {
        return this.caretend;
    }

    @Override
    public void setClipboard(String s) {
        this.clipboard = s;
    }

    @Override
    public String getClipboard() {
        return this.clipboard;
    }
}

