/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.perspective.draw.geom.Text;
import net.perspective.draw.text.Composer;
import net.perspective.draw.text.Editor;
import net.perspective.draw.text.Styler;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

public class RichTextEditor
implements Editor,
Styler {
    private String clipboard;
    private int caretstart;
    private int caretend;
    private Document currentdom;
    private SAXBuilder builder;
    private static final Logger logger = Logger.getLogger(RichTextEditor.class.getName());

    public RichTextEditor() {
        this.initbuilder();
        this.currentdom = new Document();
    }

    private void initbuilder() {
        this.builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        this.builder.setReuseParser(true);
        this.builder.setIgnoringBoundaryWhitespace(false);
        this.builder.setIgnoringElementContentWhitespace(false);
    }

    @Override
    public void editText(Text item) {
        String content = this.normalizeText(item);
        StringReader r = new StringReader(content);
        try {
            this.currentdom = this.builder.build((Reader)r);
        }
        catch (JDOMException e) {
            logger.warning("Malformed input.");
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void commitText(Text item) {
        this.currentdom.getRootElement().coalesceText(true);
        Document dom = this.getSerialVer(this.currentdom);
        StringWriter out = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setOmitDeclaration(true);
        format.setLineSeparator(LineSeparator.NONE);
        format.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter fmt = new XMLOutputter(format);
        try {
            fmt.output(dom, (Writer)out);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        item.setText(out.toString());
    }

    private String normalizeText(Text item) {
        Object content = item.getText();
        Pattern parpattern = Pattern.compile("(<p>)+(.*)(</p>)+", 32);
        Matcher matcher = parpattern.matcher((CharSequence)content);
        if (!matcher.find()) {
            content = ((String)content).replaceAll("&", "&amp;");
            content = ((String)content).replaceAll("<", "&lt;");
            content = ((String)content).replaceAll(">", "&gt;");
            content = this.setFormatting(item, (String)content);
        } else {
            content = "<p>" + matcher.group(2) + "</p>";
        }
        return content;
    }

    private String setFormatting(Text item, String content) {
        int style = item.getStyle();
        if ((style & 2) != 0) {
            content = "<i>" + (String)content + "</i>";
        }
        if ((style & 1) != 0) {
            content = "<b>" + (String)content + "</b>";
        }
        content = "<p>" + (String)content + "</p>";
        return content;
    }

    @Override
    public String readPlainText() {
        return Composer.getFlattenedText(this.currentdom.getContent());
    }

    @Override
    public int getLength() {
        return Composer.getLength(this.currentdom.getContent());
    }

    @Override
    public void cutText() {
        this.clipboard = Composer.copyText(this.currentdom.getContent(), this.caretstart, this.caretend);
        this.removeText();
        this.caretend = this.caretstart;
    }

    @Override
    public void copyText() {
        this.clipboard = Composer.copyText(this.currentdom.getContent(), this.caretstart, this.caretend);
    }

    @Override
    public void pasteText() {
        int size;
        Element parent;
        this.removeText();
        this.caretend = this.caretstart;
        if (Composer.getFlattenedText(this.currentdom.getContent()).equals(" ") && (parent = this.currentdom.getRootElement()).getContent((size = parent.getContent().size()) - 1) instanceof org.jdom2.Text) {
            Content text = parent.getContent(size - 1);
            parent.removeContent(text);
        }
        Composer.insertText(this.currentdom.getContent(), this.clipboard, this.caretstart, this.caretend);
        this.caretstart = this.caretend = this.caretstart + this.clipboard.length();
    }

    @Override
    public void backSpace() {
        if (this.caretstart == this.caretend) {
            if (this.caretstart > 0) {
                Composer.cutText(this.currentdom.getRootElement().getContent(), this.caretstart - 1, this.caretend);
                --this.caretstart;
            }
        } else {
            Composer.cutText(this.currentdom.getRootElement().getContent(), this.caretstart, this.caretend);
        }
        this.coalesceText();
        this.caretend = this.caretstart;
    }

    @Override
    public void deleteChar() {
        if (this.caretend < Composer.getLength(this.currentdom.getContent())) {
            Composer.cutText(this.currentdom.getRootElement().getContent(), this.caretstart, this.caretend + 1);
        } else {
            Composer.cutText(this.currentdom.getRootElement().getContent(), this.caretstart, this.caretend);
        }
        this.coalesceText();
        this.caretend = this.caretstart;
    }

    @Override
    public void insertChar(char c) {
        int size;
        Element parent;
        this.removeText();
        this.caretend = this.caretstart;
        if (Composer.getFlattenedText(this.currentdom.getContent()).equals(" ") && (parent = this.currentdom.getRootElement()).getContent((size = parent.getContent().size()) - 1) instanceof org.jdom2.Text) {
            Content text = parent.getContent(size - 1);
            parent.removeContent(text);
        }
        Composer.insertText(this.currentdom.getContent(), String.valueOf(c), this.caretstart, this.caretend);
        ++this.caretstart;
        this.caretend = this.caretstart;
    }

    @Override
    public void insertText(String string) {
        int size;
        Element parent;
        this.removeText();
        this.caretend = this.caretstart;
        if (Composer.getFlattenedText(this.currentdom.getContent()).equals(" ") && (parent = this.currentdom.getRootElement()).getContent((size = parent.getContent().size()) - 1) instanceof org.jdom2.Text) {
            Content t = parent.getContent(size - 1);
            parent.removeContent(t);
        }
        Composer.insertText(this.currentdom.getContent(), string, this.caretstart, this.caretend);
        this.caretstart = this.caretend = this.caretstart + string.length();
    }

    @Override
    public Set<String> detectStyles() {
        HashSet<String> styles = new HashSet<String>();
        List<Element> elements = Composer.getElements(this.currentdom.getRootElement().getContent(), this.caretstart, this.caretend);
        for (Element s : elements) {
            styles.add(s.getName());
        }
        return styles;
    }

    @Override
    public void createStyle(String style) {
        List<Content> newlist = Composer.insertElement(this.currentdom.getRootElement().getContent(), style, this.caretstart, this.caretend);
        this.currentdom.getRootElement().removeContent();
        this.currentdom.getRootElement().addContent(newlist);
    }

    @Override
    public void removeStyle(String style) {
        Composer.removeElements(this.currentdom.getContent(), style, this.caretstart, this.caretend);
    }

    private void removeText() {
        Composer.cutText(this.currentdom.getRootElement().getContent(), this.caretstart, this.caretend);
        this.coalesceText();
    }

    private void coalesceText() {
        this.currentdom.getRootElement().coalesceText(true);
        if (Composer.getFlattenedText(this.currentdom.getContent()).length() == 0) {
            this.currentdom.getRootElement().setContent((Content)new org.jdom2.Text(" "));
        }
    }

    @Override
    public void setCaretStart(int s) {
        this.caretstart = s;
    }

    @Override
    public int getCaretStart() {
        return this.caretstart;
    }

    @Override
    public void setCaretEnd(int e) {
        this.caretend = e;
    }

    @Override
    public int getCaretEnd() {
        return this.caretend;
    }

    @Override
    public void setClipboard(String s) {
        this.clipboard = s;
    }

    @Override
    public String getClipboard() {
        return this.clipboard;
    }

    private Document getSerialVer(Document dom) {
        Document doc = new Document();
        List elems = dom.cloneContent();
        String content = "<html></html>";
        StringReader r = new StringReader(content);
        try {
            doc = this.builder.build((Reader)r);
            doc.getRootElement().setContent((Collection)elems);
        }
        catch (JDOMException e) {
            logger.warning("Malformed input.");
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        return doc;
    }
}

