/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

public class Composer {
    private static SAXBuilder builder;
    private static final Logger logger;

    private Composer() {
    }

    public static String copyText(List<Content> list, int start, int end) {
        Object copytext = "";
        Stack<List> liststack = new Stack<List>();
        Stack<Integer> indices = new Stack<Integer>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content c = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                c = list.get(i);
                if (c instanceof Text) {
                    int offset = localoffset;
                    if (offset <= start && (localoffset += ((Text)c).getText().length()) >= end) {
                        copytext = (String)copytext + ((Text)c).getText().substring(start - offset, end - offset);
                    } else if (offset <= start && localoffset < end && localoffset >= start) {
                        copytext = (String)copytext + ((Text)c).getText().substring(start - offset);
                    } else if (offset > start && localoffset >= end && offset < end) {
                        copytext = (String)copytext + ((Text)c).getText().substring(0, end - offset);
                    } else if (offset > start && localoffset < end) {
                        copytext = (String)copytext + ((Text)c).getText();
                    }
                    ++i;
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(c instanceof Element)) continue;
            indices.push(++i);
            liststack.push(list);
            list = ((Element)c).getContent();
            i = 0;
        }
        return copytext;
    }

    public static void cutText(List<Content> list, int start, int end) {
        Stack<List> liststack = new Stack<List>();
        Stack<Integer> indices = new Stack<Integer>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content e = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                e = list.get(i);
                if (e instanceof Text) {
                    int offset = localoffset;
                    if (offset <= start && (localoffset += ((Text)e).getText().length()) >= end) {
                        ArrayList<Text> newlist = new ArrayList<Text>();
                        newlist.add(new Text(((Text)e).getText().substring(0, start - offset)));
                        newlist.add(new Text(((Text)e).getText().substring(end - offset)));
                        list.remove(i);
                        list.addAll(i, newlist);
                        ++i;
                    } else if (offset <= start && localoffset < end && localoffset >= start) {
                        list.set(i, new Text(((Text)e).getText().substring(0, start - offset)));
                    } else if (offset > start && localoffset >= end && offset < end) {
                        list.set(i, new Text(((Text)e).getText().substring(end - offset)));
                    } else if (offset > start && localoffset < end) {
                        list.remove(i);
                        --i;
                    }
                    ++i;
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(e instanceof Element)) continue;
            indices.push(++i);
            liststack.push(list);
            list = ((Element)e).getContent();
            i = 0;
        }
    }

    public static void insertText(List<Content> list, String pasted, int start, int end) {
        Stack<List> liststack = new Stack<List>();
        Stack<Integer> indices = new Stack<Integer>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content c = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                c = list.get(i);
                int offset = localoffset;
                if (c instanceof Element) {
                    if (localoffset == start && ((Element)c).getContent().isEmpty()) {
                        ((Element)c).setText(pasted);
                        localoffset += pasted.length();
                    }
                } else if (c instanceof Text && offset <= start && (localoffset += ((Text)c).getText().length()) >= end) {
                    int n = 0;
                    ArrayList<Text> newlist = new ArrayList<Text>();
                    newlist.add(new Text(((Text)c).getText().substring(0, start - offset)));
                    Text text = new Text(((Text)c).getText().substring(start - offset, end - offset));
                    newlist.add(text);
                    ++n;
                    if (i < list.size() - 1 && list.get(i + 1) instanceof Element) {
                        if (!Composer.isEmptyElement((Element)list.get(i + 1)) || localoffset > end) {
                            newlist.add(new Text(pasted));
                            localoffset += pasted.length();
                            ++n;
                        }
                    } else {
                        newlist.add(new Text(pasted));
                        localoffset += pasted.length();
                        ++n;
                    }
                    newlist.add(new Text(((Text)c).getText().substring(end - offset)));
                    list.remove(i);
                    list.addAll(i, newlist);
                    i += n + 1;
                }
                ++i;
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(c instanceof Element)) continue;
            indices.push(i);
            liststack.push(list);
            list = ((Element)c).getContent();
            i = 0;
        }
    }

    public static List<Content> insertElement(List<Content> list, String name, int start, int end) {
        List<Object> newlist = new ArrayList<Content>();
        Stack<List> liststack = new Stack<List>();
        Stack<ArrayList<Content>> newstack = new Stack<ArrayList<Content>>();
        Stack<Integer> indices = new Stack<Integer>();
        Stack<Element> elstack = new Stack<Element>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content c = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                c = list.get(i);
                int offset = localoffset;
                Element el = new Element(name);
                if (c instanceof Text) {
                    if (offset <= start && (localoffset += ((Text)c).getText().length()) >= end) {
                        newlist.add(new Text(((Text)c).getText().substring(0, start - offset)));
                        if (i >= list.size() - 1 || !(list.get(i + 1) instanceof Element) || !((Element)list.get(i + 1)).getContent().isEmpty() || localoffset > end) {
                            text = new Text(((Text)c).getText().substring(start - offset, end - offset));
                            el.addContent((Content)text);
                            newlist.add(el);
                        }
                        newlist.add(new Text(((Text)c).getText().substring(end - offset)));
                    } else if (offset <= start && localoffset < end && localoffset >= start) {
                        newlist.add(new Text(((Text)c).getText().substring(0, start - offset)));
                        text = new Text(((Text)c).getText().substring(start - offset));
                        el.addContent((Content)text);
                        newlist.add(el);
                    } else if (offset <= start && localoffset < end && localoffset < start) {
                        String snippet = ((Text)c).getText();
                        newlist.add(new Text(snippet));
                    } else if (offset > start && localoffset >= end && offset >= end) {
                        newlist.add(new Text(((Text)c).getText()));
                    } else if (offset > start && localoffset >= end && offset < end) {
                        text = new Text(((Text)c).getText().substring(0, end - offset));
                        el.addContent((Content)text);
                        newlist.add(el);
                        newlist.add(new Text(((Text)c).getText().substring(end - offset)));
                    } else if (offset > start && localoffset < end && offset < end) {
                        text = new Text(((Text)c).getText());
                        el.addContent((Content)text);
                        newlist.add(el);
                    }
                    el.coalesceText(true);
                    ++i;
                } else if (c instanceof Element) {
                    Element e = ((Element)c).clone();
                    if (localoffset == start && ((Element)c).getContent().isEmpty()) {
                        e.setContent((Content)el);
                        e.coalesceText(true);
                    }
                    newlist.add((Content)e);
                    elstack.push(e);
                    ++i;
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    Element e = (Element)elstack.pop();
                    e.setContent(newlist);
                    newlist = (List)newstack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(c instanceof Element)) continue;
            indices.push(i);
            liststack.push(list);
            newstack.push((ArrayList<Content>)newlist);
            list = ((Element)c).getContent();
            newlist = new ArrayList();
            i = 0;
        }
        return newlist;
    }

    public static boolean removeElements(List<Content> list, String style, int start, int end) {
        Stack<List> liststack = new Stack<List>();
        Stack<Integer> indices = new Stack<Integer>();
        int localoffset = 0;
        boolean finished = false;
        boolean removed = false;
        int i = 0;
        Content e = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                e = list.get(i);
                if (e instanceof Text) {
                    localoffset += ((Text)e).getText().length();
                    ++i;
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(e instanceof Element)) continue;
            List templist = ((Element)e).getContent();
            if (((Element)e).getName().equals(style) && localoffset >= start && localoffset <= end) {
                ArrayList<Content> newlist = new ArrayList<Content>();
                int j = 0;
                for (Content c : templist) {
                    Content k = c.clone();
                    newlist.add(k);
                    ++j;
                }
                e.detach();
                list.addAll(i, newlist);
                i += j - 1;
            }
            indices.push(++i);
            liststack.push(list);
            list = templist;
            i = 0;
        }
        return removed;
    }

    public static List<Element> getElements(List<Content> list, int start, int end) {
        Stack<List> liststack = new Stack<List>();
        Stack<Integer> indices = new Stack<Integer>();
        ArrayList<Element> elements = new ArrayList<Element>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content c = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                c = list.get(i);
                int offset = localoffset;
                if (c instanceof Text) {
                    localoffset += ((Text)c).getText().length();
                    ++i;
                } else if (c instanceof Element && offset >= start && localoffset <= end) {
                    Element s = new Element(((Element)c).getName());
                    s.setText("");
                    elements.add(s);
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(c instanceof Element)) continue;
            indices.push(++i);
            liststack.push(list);
            list = ((Element)c).getContent();
            i = 0;
        }
        return elements;
    }

    public static int getLength(List<Content> list) {
        int length = 0;
        for (Content c : list) {
            if (c instanceof Text) {
                length += ((Text)c).getText().length();
                continue;
            }
            if (!(c instanceof Element)) continue;
            length += Composer.getLength(((Element)c).getContent());
        }
        return length;
    }

    private static boolean isEmptyElement(Element element) {
        boolean empty = false;
        if (element.getContent().isEmpty()) {
            empty = true;
        } else if (element.getContent().get(0) instanceof Element) {
            empty = Composer.isEmptyElement((Element)element.getContent().get(0));
        }
        return empty;
    }

    public static String getFlattenedText(List<Content> list) {
        Object cdata = "";
        for (Content c : list) {
            if (c instanceof Text) {
                cdata = (String)cdata + ((Text)c).getText();
                continue;
            }
            if (!(c instanceof Element)) continue;
            cdata = (String)cdata + Composer.getFlattenedText(((Element)c).getContent());
        }
        return cdata;
    }

    public static List<Content> copyFragment(List<Content> list, int start, int end) {
        List<Object> newlist = new ArrayList<Content>();
        Stack<List> liststack = new Stack<List>();
        Stack<ArrayList<Content>> newstack = new Stack<ArrayList<Content>>();
        Stack<Integer> indices = new Stack<Integer>();
        Stack<Element> elstack = new Stack<Element>();
        int localoffset = 0;
        boolean finished = false;
        int i = 0;
        Content c = list.get(0);
        while (!finished) {
            if (i < list.size()) {
                c = list.get(i);
                int offset = localoffset;
                if (c instanceof Text) {
                    if (offset <= start && (localoffset += ((Text)c).getText().length()) >= end) {
                        newlist.add((Content)new Text(((Text)c).getText()));
                    } else if (offset <= start && localoffset < end && localoffset >= start) {
                        newlist.add((Content)new Text(((Text)c).getText()));
                    } else if (offset <= start && localoffset < end && localoffset < start) {
                        newlist.add(new Text(((Text)c).getText()));
                    } else if (offset > start && localoffset >= end && offset >= end) {
                        newlist.add(new Text(((Text)c).getText()));
                    } else if (offset > start && localoffset >= end && offset < end) {
                        newlist.add(new Text(((Text)c).getText()));
                    } else if (offset > start && localoffset < end && offset < end) {
                        newlist.add(new Text(((Text)c).getText()));
                    }
                    ++i;
                } else if (c instanceof Element) {
                    e = ((Element)c).clone();
                    newlist.add((Content)e);
                    elstack.push(e);
                    ++i;
                }
            } else {
                if (!liststack.empty()) {
                    i = (Integer)indices.pop();
                    list = (List)liststack.pop();
                    e = (Element)elstack.pop();
                    e.setContent(newlist);
                    newlist = (List)newstack.pop();
                    continue;
                }
                finished = true;
            }
            if (!(c instanceof Element)) continue;
            indices.push(i);
            liststack.push(list);
            newstack.push((ArrayList<Content>)newlist);
            list = ((Element)c).getContent();
            newlist = new ArrayList();
            i = 0;
        }
        return newlist;
    }

    public static void initbuilder() {
        builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setReuseParser(true);
        builder.setIgnoringBoundaryWhitespace(false);
        builder.setIgnoringElementContentWhitespace(false);
    }

    public static List<Content> getFragment(String html) {
        List<Object> list = new ArrayList<Content>();
        StringReader r = new StringReader(html);
        try {
            Document dom = builder.build((Reader)r);
            list = dom.getRootElement().cloneContent();
        }
        catch (JDOMException e) {
            logger.warning("Malformed input.");
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        return list;
    }

    public static String getHTML(List<Content> list) {
        Document dom = new Document();
        dom.setRootElement(new Element("p"));
        dom.getRootElement().setContent(list);
        StringWriter out = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setOmitDeclaration(true);
        format.setLineSeparator(LineSeparator.NONE);
        format.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter fmt = new XMLOutputter(format);
        try {
            fmt.output(dom, (Writer)out);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        return out.toString();
    }

    static {
        logger = Logger.getLogger(Composer.class.getName());
    }
}

