/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.MainFrame;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.Text;
import net.perspective.draw.swing.ComboBoxRenderer;
import net.perspective.draw.swing.Dropper;
import net.perspective.draw.util.FileUtils;

public final class ToolPanel
extends JPanel
implements ActionListener {
    private final MainFrame frame;
    private final DrawingCanvas canvas;
    private final Dropper dropper;
    private Color strokeColor;
    private Color fillColor;
    private int panelType;
    private int strokeId;
    private int styleNum;
    private ImageIcon[] strokeImages;
    private ImageIcon[] styleImages;
    List<String> strokeStrings = Arrays.asList("stroke1", "stroke2", "stroke3", "stroke4", "stroke5", "stroke6", "stroke7", "stroke8", "stroke9");
    List<String> styleStrings = Arrays.asList("style1", "style2", "style3", "style4", "style5", "style6", "style7", "style8", "style9", "style10", "style11", "style12", "style13");
    List<String> fontFamily = Arrays.asList("Serif", "SansSerif", "Monospaced");
    List<String> fontSize = Arrays.asList("8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72");
    static final int INIT_PANEL = 0;
    static final int COMBO_PANEL = 1;
    static final int COLOR_PANEL = 2;
    static final int FONT_PANEL = 3;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final boolean PC_WIN = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private JButton jFillColor;
    private JButton jStrokeColor;
    private JButton jVHButton;
    private JButton jPNGButton;
    private JButton jSVGButton;
    private JButton jDateAndTimeButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox jStrokeCombo;
    private JComboBox jLineStyleCombo;
    private JComboBox jFontCombo;
    private JComboBox jSizeCombo;
    private JToggleButton jFontBold;
    private JToggleButton jFontItalic;
    private JToggleButton jFontUnderline;
    private JToggleButton jDropperButton;
    private JToggleButton jOneToOneButton;
    private JToggleButton jOutlineButton;

    public ToolPanel(MainFrame f) {
        this.frame = f;
        this.canvas = this.frame.getCanvas();
        this.panelType = 1;
        this.strokeId = 2;
        this.styleNum = 0;
        this.dropper = new Dropper();
        this.initComponents();
        this.setPanel(0);
        this.strokeColor = this.canvas.getStrokeColor();
        this.fillColor = this.canvas.getFillColor();
        this.jStrokeColor.setBackground(this.strokeColor);
        this.jFillColor.setBackground(this.fillColor);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jStrokeColor = new JButton();
        this.jFillColor = new JButton();
        this.jVHButton = new JButton();
        this.jPNGButton = new JButton();
        this.jSVGButton = new JButton();
        this.jOutlineButton = new JToggleButton();
        this.jOneToOneButton = new JToggleButton();
        this.jDropperButton = new JToggleButton();
        this.jDateAndTimeButton = new JButton();
        this.jStrokeColor.setBorder(BorderFactory.createEmptyBorder());
        this.jStrokeColor.setMinimumSize(new Dimension(45, 29));
        this.jStrokeColor.setMaximumSize(new Dimension(45, 29));
        this.jStrokeColor.setPreferredSize(new Dimension(45, 29));
        this.jStrokeColor.setToolTipText("Stroke color");
        this.jStrokeColor.setActionCommand("Stroke");
        this.jStrokeColor.setFocusable(false);
        this.makeButtonListener(this.jStrokeColor);
        this.jFillColor.setBorder(BorderFactory.createEmptyBorder());
        this.jFillColor.setMinimumSize(new Dimension(45, 29));
        this.jFillColor.setMaximumSize(new Dimension(45, 29));
        this.jFillColor.setPreferredSize(new Dimension(45, 29));
        this.jFillColor.setToolTipText("Fill color");
        this.jFillColor.setActionCommand("Fill");
        this.jFillColor.setFocusable(false);
        this.makeButtonListener(this.jFillColor);
        if (MAC_OS_X) {
            this.jStrokeColor.setOpaque(true);
            this.jFillColor.setOpaque(true);
        }
        this.jOutlineButton.setMinimumSize(new Dimension(32, 29));
        this.jOutlineButton.setMaximumSize(new Dimension(32, 29));
        this.jOutlineButton.setPreferredSize(new Dimension(32, 29));
        this.jOutlineButton.setToolTipText("Draw as outline");
        this.jOutlineButton.setActionCommand("Opacity");
        this.jOutlineButton.setFocusable(false);
        this.makeButtonListener(this.jOutlineButton);
        this.jVHButton.setMinimumSize(new Dimension(32, 29));
        this.jVHButton.setMaximumSize(new Dimension(32, 29));
        this.jVHButton.setPreferredSize(new Dimension(32, 29));
        this.jVHButton.setToolTipText("Toggle Vertical");
        this.jVHButton.setActionCommand("VH");
        this.jVHButton.setFocusable(false);
        this.makeButtonListener(this.jVHButton);
        this.jOneToOneButton.setMinimumSize(new Dimension(32, 29));
        this.jOneToOneButton.setMaximumSize(new Dimension(32, 29));
        this.jOneToOneButton.setPreferredSize(new Dimension(32, 29));
        this.jOneToOneButton.setToolTipText("Draw Isometric");
        this.jOneToOneButton.setActionCommand("OneToOne");
        this.jOneToOneButton.setFocusable(false);
        this.makeButtonListener(this.jOneToOneButton);
        this.jDropperButton.setMinimumSize(new Dimension(32, 29));
        this.jDropperButton.setMaximumSize(new Dimension(32, 29));
        this.jDropperButton.setPreferredSize(new Dimension(32, 29));
        this.jDropperButton.setToolTipText("Copy Styles");
        this.jDropperButton.setActionCommand("DropperTool");
        this.jDropperButton.setFocusable(false);
        this.jDropperButton.addItemListener(e -> this.frame.setDropperTool(e.getStateChange() == 1));
        this.jDateAndTimeButton.setMinimumSize(new Dimension(32, 29));
        this.jDateAndTimeButton.setMaximumSize(new Dimension(32, 29));
        this.jDateAndTimeButton.setPreferredSize(new Dimension(32, 29));
        this.jDateAndTimeButton.setToolTipText("Insert date and time");
        this.jDateAndTimeButton.setActionCommand("DateTool");
        this.jDateAndTimeButton.setFocusable(false);
        this.makeButtonListener(this.jDateAndTimeButton);
        this.jPNGButton.setMinimumSize(new Dimension(32, 29));
        this.jPNGButton.setMaximumSize(new Dimension(32, 29));
        this.jPNGButton.setPreferredSize(new Dimension(32, 29));
        this.jPNGButton.setToolTipText("Snapshot to Desktop");
        this.jPNGButton.setActionCommand("PNG");
        this.jPNGButton.setFocusable(false);
        this.makeButtonListener(this.jPNGButton);
        this.jSVGButton.setMinimumSize(new Dimension(32, 29));
        this.jSVGButton.setMaximumSize(new Dimension(32, 29));
        this.jSVGButton.setPreferredSize(new Dimension(32, 29));
        this.jSVGButton.setToolTipText("Show Icon Library");
        this.jSVGButton.setActionCommand("SVG");
        this.jSVGButton.setFocusable(false);
        this.makeButtonListener(this.jSVGButton);
        this.jLabel1.setText("Color");
        this.jLabel2.setText("Fill");
        this.jFontCombo = new JComboBox();
        this.jSizeCombo = new JComboBox();
        this.jFontBold = new JToggleButton();
        this.jFontItalic = new JToggleButton();
        this.jFontUnderline = new JToggleButton();
        this.jFontCombo.setModel(new DefaultComboBoxModel<String>(this.fontFamily.toArray(new String[this.fontFamily.size() - 1])));
        this.jFontCombo.setSelectedIndex(0);
        this.jFontCombo.setMaximumSize(new Dimension(114, 27));
        this.jFontCombo.setMinimumSize(new Dimension(114, 27));
        this.jFontCombo.setPreferredSize(new Dimension(114, 27));
        this.jFontCombo.setToolTipText("Font");
        this.jFontCombo.setFocusable(false);
        this.jFontCombo.addActionListener(this);
        this.jSizeCombo.setModel(new DefaultComboBoxModel<String>(this.fontSize.toArray(new String[this.fontSize.size() - 1])));
        this.jSizeCombo.setSelectedIndex(5);
        this.jSizeCombo.setMaximumSize(new Dimension(70, 27));
        this.jSizeCombo.setMinimumSize(new Dimension(70, 27));
        this.jSizeCombo.setPreferredSize(new Dimension(70, 27));
        this.jSizeCombo.setToolTipText("Font Size");
        this.jSizeCombo.setFocusable(false);
        this.jSizeCombo.addActionListener(this);
        this.jFontBold.setMinimumSize(new Dimension(32, 29));
        this.jFontBold.setMaximumSize(new Dimension(32, 29));
        this.jFontBold.setPreferredSize(new Dimension(32, 29));
        this.jFontBold.setToolTipText("Bold");
        this.jFontBold.setActionCommand("Bold");
        this.jFontBold.setFocusable(false);
        this.makeButtonListener(this.jFontBold);
        this.jFontItalic.setMinimumSize(new Dimension(32, 29));
        this.jFontItalic.setMaximumSize(new Dimension(32, 29));
        this.jFontItalic.setPreferredSize(new Dimension(32, 29));
        this.jFontItalic.setToolTipText("Italic");
        this.jFontItalic.setActionCommand("Italic");
        this.jFontItalic.setFocusable(false);
        this.makeButtonListener(this.jFontItalic);
        this.jFontUnderline.setMinimumSize(new Dimension(32, 29));
        this.jFontUnderline.setMaximumSize(new Dimension(32, 29));
        this.jFontUnderline.setPreferredSize(new Dimension(32, 29));
        this.jFontUnderline.setToolTipText("Underlined");
        this.jFontUnderline.setActionCommand("Underline");
        this.jFontUnderline.setFocusable(false);
        this.makeButtonListener(this.jFontUnderline);
        this.setImageIcons(this.frame.isDarkTheme());
        this.canvas.setToolPanel(this);
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(1, 50));
        this.setMinimumSize(new Dimension(0, 50));
        this.setPreferredSize(new Dimension(0, 50));
        this.setFocusable(false);
        if (MAC_OS_X) {
            this.setMaximumSize(new Dimension(1, 52));
            this.setMinimumSize(new Dimension(0, 52));
            this.setPreferredSize(new Dimension(0, 52));
            this.setBorder(new EmptyBorder(5, 0, 0, 0));
        }
    }

    public void setImageIcons(boolean isDarkTheme) {
        this.jOutlineButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/wireframe" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jDateAndTimeButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/hourglass" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jVHButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/perpendicular" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jOneToOneButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/onetoone" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jDropperButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/dropper" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jPNGButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/share" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jSVGButton.setIcon(FileUtils.createMultiDpiImageIcon("/images/image" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jFontBold.setIcon(FileUtils.createMultiDpiImageIcon("/images/bold" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jFontItalic.setIcon(FileUtils.createMultiDpiImageIcon("/images/italic" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jFontUnderline.setIcon(FileUtils.createMultiDpiImageIcon("/images/underline" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.strokeImages = new ImageIcon[this.strokeStrings.size()];
        Integer[] strkIntArray = new Integer[this.strokeStrings.size()];
        for (int i = 0; i < this.strokeStrings.size(); ++i) {
            strkIntArray[i] = i;
            this.strokeImages[i] = FileUtils.createMultiDpiImageIcon("/images/" + this.strokeStrings.get(i) + (isDarkTheme ? "-alt" : "") + ".png");
            if (this.strokeImages[i] == null) continue;
            this.strokeImages[i].setDescription(this.strokeStrings.get(i));
        }
        this.jStrokeCombo = new JComboBox<Integer>(strkIntArray);
        ComboBoxRenderer strokeRenderer = new ComboBoxRenderer(this.strokeImages);
        strokeRenderer.setPreferredSize(new Dimension(75, 14));
        this.jStrokeCombo.setRenderer(strokeRenderer);
        this.jStrokeCombo.setMaximumRowCount(9);
        this.jStrokeCombo.setSelectedIndex(2);
        this.jStrokeCombo.setToolTipText("Stroke Width");
        this.jStrokeCombo.setMaximumSize(new Dimension(114, 27));
        this.jStrokeCombo.setMinimumSize(new Dimension(114, 27));
        this.jStrokeCombo.setPreferredSize(new Dimension(114, 27));
        this.jStrokeCombo.setFocusable(false);
        this.jStrokeCombo.addActionListener(this);
        this.styleImages = new ImageIcon[this.styleStrings.size()];
        Integer[] styleIntArray = new Integer[this.styleStrings.size()];
        for (int i = 0; i < this.styleStrings.size(); ++i) {
            styleIntArray[i] = i;
            this.styleImages[i] = FileUtils.createMultiDpiImageIcon("/images/" + this.styleStrings.get(i) + (isDarkTheme ? "-alt" : "") + ".png");
            if (this.styleImages[i] == null) continue;
            this.styleImages[i].setDescription(this.styleStrings.get(i));
        }
        this.jLineStyleCombo = new JComboBox<Integer>(styleIntArray);
        ComboBoxRenderer styleRenderer = new ComboBoxRenderer(this.styleImages);
        styleRenderer.setPreferredSize(new Dimension(75, 14));
        this.jLineStyleCombo.setRenderer(styleRenderer);
        this.jLineStyleCombo.setMaximumRowCount(13);
        this.jLineStyleCombo.setSelectedIndex(0);
        this.jLineStyleCombo.setToolTipText("Stroke Style");
        this.jLineStyleCombo.setMaximumSize(new Dimension(114, 27));
        this.jLineStyleCombo.setMinimumSize(new Dimension(114, 27));
        this.jLineStyleCombo.setPreferredSize(new Dimension(114, 27));
        this.jLineStyleCombo.setFocusable(false);
        this.jLineStyleCombo.addActionListener(this);
    }

    public void setPanel(int type) {
        switch (type) {
            case 1: {
                super.removeAll();
                this.repaint();
                this.setComboPanel();
                this.panelType = 1;
                break;
            }
            case 2: {
                super.removeAll();
                this.repaint();
                this.setColorPanel();
                this.panelType = 2;
                break;
            }
            case 3: {
                super.removeAll();
                this.repaint();
                this.setFontPanel();
                this.panelType = 3;
                break;
            }
            default: {
                super.removeAll();
                this.repaint();
                this.setComboPanel();
                this.panelType = 1;
            }
        }
    }

    public void updateComponentUI() {
        int panel = this.panelType;
        this.setPanel(3);
        SwingUtilities.updateComponentTreeUI(this);
        this.setPanel(1);
        SwingUtilities.updateComponentTreeUI(this);
        this.setPanel(panel);
    }

    private void setComboPanel() {
        if (MAC_OS_X) {
            this.add(Box.createHorizontalStrut(5));
        } else {
            this.add(Box.createHorizontalStrut(45));
        }
        this.add(this.jStrokeCombo);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jLineStyleCombo);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jLabel2);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFillColor);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jLabel1);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jStrokeColor);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jVHButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jDropperButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jOneToOneButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jOutlineButton);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jFontCombo);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jSizeCombo);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFontBold);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFontItalic);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFontUnderline);
        this.add(Box.createHorizontalStrut(2));
        this.add(Box.createHorizontalGlue());
        this.add(this.jPNGButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jSVGButton);
        this.add(Box.createHorizontalStrut(10));
    }

    private void setColorPanel() {
        if (MAC_OS_X) {
            this.add(Box.createHorizontalStrut(5));
        } else {
            this.add(Box.createHorizontalStrut(45));
        }
        this.add(this.jStrokeCombo);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jLineStyleCombo);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jLabel2);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFillColor);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jLabel1);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jStrokeColor);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jDropperButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jOneToOneButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jOutlineButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(Box.createHorizontalGlue());
        this.add(this.jPNGButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jSVGButton);
        this.add(Box.createHorizontalStrut(10));
    }

    private void setFontPanel() {
        if (MAC_OS_X) {
            this.add(Box.createHorizontalStrut(5));
        } else {
            this.add(Box.createHorizontalStrut(45));
        }
        this.add(this.jFontCombo);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jSizeCombo);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jFontBold);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFontItalic);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jFontUnderline);
        if (MAC_OS_X) {
            this.add(Box.createHorizontalStrut(10));
        } else if (PC_WIN) {
            this.add(Box.createHorizontalStrut(8));
        } else {
            this.add(Box.createHorizontalStrut(9));
        }
        this.add(this.jLabel1);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jStrokeColor);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.jVHButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jDropperButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jDateAndTimeButton);
        this.add(Box.createHorizontalGlue());
        this.add(this.jPNGButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.jSVGButton);
        this.add(Box.createHorizontalStrut(10));
    }

    private JButton makeButtonListener(JButton b) {
        b.addActionListener(this);
        return b;
    }

    private JToggleButton makeButtonListener(JToggleButton b) {
        b.addActionListener(this);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jFontCombo)) {
            this.canvas.setFontFamily(this.jFontCombo.getSelectedItem().toString());
        } else if (actionEvent.getSource().equals(this.jSizeCombo)) {
            String size = this.jSizeCombo.getSelectedItem().toString();
            Integer sz = Integer.valueOf(size);
            this.canvas.setFontSize(sz);
        }
        if (actionEvent.getSource().equals(this.jFontBold)) {
            this.canvas.getView().getTextController().formatSelectedText(1);
        }
        if (actionEvent.getSource().equals(this.jFontItalic)) {
            this.canvas.getView().getTextController().formatSelectedText(2);
        }
        if (actionEvent.getSource().equals(this.jFontUnderline)) {
            this.canvas.getView().getTextController().formatSelectedText(4);
        }
        if (actionEvent.getSource().equals(this.jStrokeCombo)) {
            combo = (JComboBox)actionEvent.getSource();
            this.strokeId = (Integer)combo.getSelectedItem();
        } else if (actionEvent.getSource().equals(this.jLineStyleCombo)) {
            combo = (JComboBox)actionEvent.getSource();
            this.styleNum = (Integer)combo.getSelectedItem();
        }
        if (actionEvent.getSource().equals(this.jStrokeCombo) || actionEvent.getSource().equals(this.jLineStyleCombo)) {
            Stroke stroke = this.dropper.selectStroke(this.strokeId, this.styleStrings.get(this.styleNum));
            Stroke plainStroke = this.dropper.selectPlainStroke(this.strokeId, this.styleStrings.get(this.styleNum));
            this.canvas.setStroke(stroke);
            this.canvas.setPlainStroke(plainStroke);
            switch (this.styleStrings.get(this.styleNum)) {
                case "style6": {
                    this.canvas.setArrow(ArrowType.END);
                    break;
                }
                case "style7": {
                    this.canvas.setArrow(ArrowType.END);
                    break;
                }
                case "style8": {
                    this.canvas.setArrow(ArrowType.BOTH);
                    break;
                }
                case "style9": {
                    this.canvas.setArrow(ArrowType.BOTH);
                    break;
                }
                default: {
                    this.canvas.resetArrow();
                    break;
                }
            }
        } else {
            switch (actionEvent.getActionCommand()) {
                case "Stroke": {
                    Color thisColor = JColorChooser.showDialog(this.frame, "Choose a stroke color", this.canvas.getStrokeColor());
                    if (thisColor != null) {
                        this.strokeColor = thisColor;
                    }
                    this.setColor(this.strokeColor);
                    break;
                }
                case "Fill": {
                    Color thisColor = JColorChooser.showDialog(this.frame, "Choose a fill color", this.canvas.getFillColor());
                    if (thisColor != null) {
                        this.fillColor = thisColor;
                    }
                    this.setFillColor(this.fillColor);
                    break;
                }
                case "VH": {
                    this.canvas.getView().toggleVertical();
                    this.frame.setStatus("Toggle Vertical");
                    break;
                }
                case "Opacity": {
                    this.frame.setTransparency(this.jOutlineButton.getModel().isSelected());
                    break;
                }
                case "OneToOne": {
                    this.canvas.setOneToOne(this.jOneToOneButton.getModel().isSelected());
                    break;
                }
                case "DateTool": {
                    CanvasView view = this.canvas.getView();
                    if (view.getSelected() == -1 || !view.isEditing()) break;
                    Text item = (Text)view.getDrawings().get(view.getSelected());
                    this.canvas.getView().insertDateAndTime(item);
                    item.setDimensions(this.canvas);
                    this.canvas.repaint();
                    break;
                }
                case "PNG": {
                    this.frame.snapshotPNG();
                    break;
                }
                case "SVG": {
                    this.frame.showIconLibrary();
                    break;
                }
            }
        }
    }

    public void setOpacityButton(boolean isSet) {
        this.jOutlineButton.getModel().setSelected(isSet);
    }

    public void enablePNGButton(boolean isEnabled) {
        this.jPNGButton.setEnabled(isEnabled);
    }

    public void enableDropperButton(boolean isEnabled) {
        this.jDropperButton.setEnabled(isEnabled);
    }

    public void resetFormattingButtons() {
        this.jFontBold.setSelected(false);
        this.jFontItalic.setSelected(false);
        this.jFontUnderline.setSelected(false);
    }

    public void toggleFormattingButton(int b, boolean state) {
        switch (b) {
            case 1: {
                this.jFontBold.setSelected(state);
                break;
            }
            case 2: {
                this.jFontItalic.setSelected(state);
                break;
            }
            case 4: {
                this.jFontUnderline.setSelected(state);
                break;
            }
        }
    }

    public void setStrokeCombo(int strokeId) {
        this.jStrokeCombo.setSelectedIndex(strokeId);
    }

    public void setStyleCombo(String styleId) {
        this.jLineStyleCombo.setSelectedIndex(this.styleStrings.indexOf(styleId));
    }

    public void setColor(Color color) {
        this.canvas.setStrokeColor(color);
        this.jStrokeColor.setBackground(color);
    }

    public void setFillColor(Color fillcolor) {
        this.canvas.setFillColor(fillcolor);
        this.jFillColor.setBackground(fillcolor);
    }

    public void setFontCombo(String font) {
        this.jFontCombo.setSelectedIndex(this.fontFamily.indexOf(font));
    }

    public void setSizeCombo(int size) {
        int index = this.fontSize.indexOf(String.valueOf(size));
        if (index == -1) {
            index = 5;
        }
        this.jSizeCombo.setSelectedIndex(index);
    }

    public void incrementFontSize(int size) {
        int index = this.fontSize.indexOf(String.valueOf(size)) + 1;
        if (index >= this.fontSize.size()) {
            index = this.fontSize.size() - 1;
        }
        this.jSizeCombo.setSelectedIndex(index);
    }

    public void decrementFontSize(int size) {
        int index = this.fontSize.indexOf(String.valueOf(size)) - 1;
        if (index < 0) {
            index = 0;
        }
        this.jSizeCombo.setSelectedIndex(index);
    }

    public String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }
}

