/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.MainFrame;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.swing.ButtonDialog;
import net.perspective.draw.swing.DialogGroup;
import net.perspective.draw.swing.ToggleButton;
import net.perspective.draw.swing.ToolPanel;
import net.perspective.draw.util.FileUtils;

public class ToolButtons
extends JPanel
implements ActionListener {
    private final MainFrame frame;
    private final DrawingCanvas canvas;
    private final ToolPanel jToolPanel;
    private DialogGroup dialogs;
    public static final int BUTT_SELECT = 0;
    public static final int BUTT_ROTATE = 1;
    public static final int BUTT_LINE = 2;
    public static final int BUTT_HORIZ = 3;
    public static final int BUTT_VERT = 4;
    public static final int BUTT_CIRC = 5;
    public static final int BUTT_SQUARE = 6;
    public static final int BUTT_TRI = 7;
    public static final int BUTT_HEX = 8;
    public static final int BUTT_PENT = 9;
    public static final int BUTT_POLY = 10;
    public static final int BUTT_SKETCH = 11;
    public static final int BUTT_TEXT = 12;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private ButtonGroup jSelectGroup;
    private JToggleButton jButtSelect;
    private JToggleButton jButtRotate;
    private ToggleButton jButtHorizontal;
    private ToggleButton jButtVertical;
    private JToggleButton jButtLine;
    private JToggleButton jButtCircle;
    private JToggleButton jButtSquare;
    private JToggleButton jButtTriangle;
    private JToggleButton jButtHexagon;
    private JToggleButton jButtPentagram;
    private ToggleButton jButtSketch;
    private ToggleButton jButtPolygon;
    private JToggleButton jButtText;
    private JToggleButton jButtHoriz2;
    private JToggleButton jButtVert2;
    private JToggleButton jButtSketch2;
    private JToggleButton jButtPoly2;
    private JCheckBox jGridBox;
    private JLabel jGridLabel;
    private JCheckBox jGuideBox;
    private JLabel jGuideLabel;
    private ButtonDialog dummyDialog;
    private ButtonDialog lineDialog;
    private ButtonDialog sketchDialog;

    public ToolButtons(MainFrame f) {
        this.frame = f;
        this.canvas = this.frame.getCanvas();
        this.initComponents();
        this.jToolPanel = this.frame.getToolPanel();
    }

    private void initComponents() {
        this.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0), 1));
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(46, 0));
        this.setPreferredSize(new Dimension(46, 0));
        this.setLayout(new BoxLayout(this, 1));
        this.jSelectGroup = new ButtonGroup();
        this.jButtSelect = new JToggleButton();
        this.makeButtonListener(this.jButtSelect);
        this.jButtRotate = new JToggleButton();
        this.makeButtonListener(this.jButtRotate);
        this.jButtLine = new JToggleButton();
        this.makeButtonListener(this.jButtLine);
        this.jButtHorizontal = new ToggleButton(this.frame);
        this.makeButtonListener(this.jButtHorizontal);
        this.jButtVertical = new ToggleButton(this.frame);
        this.makeButtonListener(this.jButtVertical);
        this.jButtCircle = new JToggleButton();
        this.makeButtonListener(this.jButtCircle);
        this.jButtSquare = new JToggleButton();
        this.makeButtonListener(this.jButtSquare);
        this.jButtTriangle = new JToggleButton();
        this.makeButtonListener(this.jButtTriangle);
        this.jButtHexagon = new JToggleButton();
        this.makeButtonListener(this.jButtHexagon);
        this.jButtPentagram = new JToggleButton();
        this.makeButtonListener(this.jButtPentagram);
        this.jButtPolygon = new ToggleButton(this.frame);
        this.makeButtonListener(this.jButtPolygon);
        this.jButtSketch = new ToggleButton(this.frame);
        this.makeButtonListener(this.jButtSketch);
        this.jButtText = new JToggleButton();
        this.makeButtonListener(this.jButtText);
        this.jGridBox = new JCheckBox();
        this.makeCheckBoxListener(this.jGridBox);
        this.jGridLabel = new JLabel();
        this.jGuideBox = new JCheckBox();
        this.makeCheckBoxListener(this.jGuideBox);
        this.jGuideLabel = new JLabel();
        this.jSelectGroup.add(this.jButtSelect);
        this.jButtSelect.setToolTipText("Select");
        this.jButtSelect.setActionCommand("Select");
        this.jButtSelect.setFocusable(false);
        this.jButtSelect.setMaximumSize(new Dimension(46, 46));
        this.jButtSelect.setMinimumSize(new Dimension(46, 46));
        this.jButtSelect.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtRotate);
        this.jButtRotate.setToolTipText("Rotate");
        this.jButtRotate.setActionCommand("Rotate");
        this.jButtRotate.setFocusable(false);
        this.jButtRotate.setMaximumSize(new Dimension(46, 46));
        this.jButtRotate.setMinimumSize(new Dimension(46, 46));
        this.jButtRotate.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtLine);
        this.jButtLine.setToolTipText("Line");
        this.jButtLine.setActionCommand("Line");
        this.jButtLine.setFocusable(false);
        this.jButtLine.setMaximumSize(new Dimension(46, 46));
        this.jButtLine.setMinimumSize(new Dimension(46, 46));
        this.jButtLine.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtHorizontal);
        this.jButtHorizontal.setToolTipText("Horizontal");
        this.jButtHorizontal.setActionCommand("Horizontal");
        this.jButtHorizontal.setFocusable(false);
        this.jButtHorizontal.setMaximumSize(new Dimension(46, 46));
        this.jButtHorizontal.setMinimumSize(new Dimension(46, 46));
        this.jButtHorizontal.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtVertical);
        this.jButtVertical.setToolTipText("Vertical");
        this.jButtVertical.setActionCommand("Vertical");
        this.jButtVertical.setFocusable(false);
        this.jButtVertical.setMaximumSize(new Dimension(46, 46));
        this.jButtVertical.setMinimumSize(new Dimension(46, 46));
        this.jButtVertical.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtCircle);
        this.jButtCircle.setToolTipText("Circle");
        this.jButtCircle.setActionCommand("Circle");
        this.jButtCircle.setFocusable(false);
        this.jButtCircle.setMaximumSize(new Dimension(46, 46));
        this.jButtCircle.setMinimumSize(new Dimension(46, 46));
        this.jButtCircle.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtSquare);
        this.jButtSquare.setToolTipText("Square");
        this.jButtSquare.setActionCommand("Square");
        this.jButtSquare.setFocusable(false);
        this.jButtSquare.setMaximumSize(new Dimension(46, 46));
        this.jButtSquare.setMinimumSize(new Dimension(46, 46));
        this.jButtSquare.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtTriangle);
        this.jButtTriangle.setToolTipText("Triangle");
        this.jButtTriangle.setActionCommand("Triangle");
        this.jButtTriangle.setFocusable(false);
        this.jButtTriangle.setMaximumSize(new Dimension(46, 46));
        this.jButtTriangle.setMinimumSize(new Dimension(46, 46));
        this.jButtTriangle.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtHexagon);
        this.jButtHexagon.setToolTipText("Hexagon");
        this.jButtHexagon.setActionCommand("Hexagon");
        this.jButtHexagon.setFocusable(false);
        this.jButtHexagon.setMaximumSize(new Dimension(46, 46));
        this.jButtHexagon.setMinimumSize(new Dimension(46, 46));
        this.jButtHexagon.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtPentagram);
        this.jButtPentagram.setToolTipText("Pentagram");
        this.jButtPentagram.setActionCommand("Pentagram");
        this.jButtPentagram.setFocusable(false);
        this.jButtPentagram.setMaximumSize(new Dimension(46, 46));
        this.jButtPentagram.setMinimumSize(new Dimension(46, 46));
        this.jButtPentagram.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtSketch);
        this.jButtSketch.setToolTipText("Sketch");
        this.jButtSketch.setActionCommand("Sketch");
        this.jButtSketch.setFocusable(false);
        this.jButtSketch.setMaximumSize(new Dimension(46, 46));
        this.jButtSketch.setMinimumSize(new Dimension(46, 46));
        this.jButtSketch.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtPolygon);
        this.jButtPolygon.setToolTipText("Polygon");
        this.jButtPolygon.setActionCommand("Polygon");
        this.jButtPolygon.setFocusable(false);
        this.jButtPolygon.setMaximumSize(new Dimension(46, 46));
        this.jButtPolygon.setMinimumSize(new Dimension(46, 46));
        this.jButtPolygon.setPreferredSize(new Dimension(46, 46));
        this.jSelectGroup.add(this.jButtText);
        this.jButtText.setToolTipText("Text");
        this.jButtText.setActionCommand("Text");
        this.jButtText.setFocusable(false);
        this.jButtText.setMaximumSize(new Dimension(46, 46));
        this.jButtText.setMinimumSize(new Dimension(46, 46));
        this.jButtText.setPreferredSize(new Dimension(46, 46));
        this.jGridBox.setToolTipText("Show Grid");
        this.jGridBox.setActionCommand("toggleGrid");
        this.jGridBox.setContentAreaFilled(false);
        this.jGridBox.setFocusable(false);
        this.jGridBox.setHorizontalAlignment(0);
        this.jGridBox.setMaximumSize(new Dimension(46, 26));
        this.jGridBox.setMinimumSize(new Dimension(46, 26));
        this.jGridBox.setPreferredSize(new Dimension(46, 26));
        Font font = new JLabel().getFont();
        font = font.deriveFont(0, 12.0f);
        this.jGridLabel.setFont(font);
        this.jGridLabel.setHorizontalAlignment(0);
        this.jGridLabel.setLabelFor(this.jGridBox);
        this.jGridLabel.setText("Grid");
        this.jGridLabel.setFocusable(false);
        this.jGridLabel.setMaximumSize(new Dimension(46, 16));
        this.jGridLabel.setMinimumSize(new Dimension(46, 16));
        this.jGridLabel.setPreferredSize(new Dimension(46, 16));
        this.jGuideBox.setToolTipText("Enable Guides");
        this.jGuideBox.setActionCommand("toggleAlign");
        this.jGuideBox.setContentAreaFilled(false);
        this.jGuideBox.setFocusable(false);
        this.jGuideBox.setHorizontalAlignment(0);
        this.jGuideBox.setMaximumSize(new Dimension(46, 26));
        this.jGuideBox.setMinimumSize(new Dimension(46, 26));
        this.jGuideBox.setPreferredSize(new Dimension(46, 26));
        this.jGuideLabel.setFont(font);
        this.jGuideLabel.setHorizontalAlignment(0);
        this.jGuideLabel.setLabelFor(this.jGuideBox);
        this.jGuideLabel.setText("Align");
        this.jGuideLabel.setFocusable(false);
        this.jGuideLabel.setMaximumSize(new Dimension(46, 16));
        this.jGuideLabel.setMinimumSize(new Dimension(46, 16));
        this.jGuideLabel.setPreferredSize(new Dimension(46, 16));
        this.add(this.jButtSelect);
        this.add(this.jButtRotate);
        this.add(this.jButtLine);
        this.add(this.jButtHorizontal);
        this.add(this.jButtCircle);
        this.add(this.jButtSquare);
        this.add(this.jButtTriangle);
        this.add(this.jButtHexagon);
        this.add(this.jButtPentagram);
        this.add(this.jButtSketch);
        this.add(this.jButtText);
        this.add(this.jGuideBox);
        this.add(this.jGuideLabel);
        this.add(this.jGridBox);
        this.add(this.jGridLabel);
        this.jButtHoriz2 = new JToggleButton();
        this.jButtVert2 = new JToggleButton();
        this.jButtHoriz2.setToolTipText("Horizontal");
        this.jButtHoriz2.setFocusable(false);
        this.jButtHoriz2.setMaximumSize(new Dimension(46, 46));
        this.jButtHoriz2.setMinimumSize(new Dimension(46, 46));
        this.jButtHoriz2.setPreferredSize(new Dimension(46, 46));
        this.jButtHoriz2.setSelected(true);
        this.jButtVert2.setToolTipText("Vertical");
        this.jButtVert2.setFocusable(false);
        this.jButtVert2.setMaximumSize(new Dimension(46, 46));
        this.jButtVert2.setMinimumSize(new Dimension(46, 46));
        this.jButtVert2.setPreferredSize(new Dimension(46, 46));
        this.lineDialog = new ButtonDialog(this.frame, this);
        this.lineDialog.add(this.jButtHoriz2);
        this.lineDialog.add(this.jButtVert2);
        this.jButtSketch2 = new JToggleButton();
        this.jButtPoly2 = new JToggleButton();
        this.jButtSketch2.setToolTipText("Sketch");
        this.jButtSketch2.setFocusable(false);
        this.jButtSketch2.setMaximumSize(new Dimension(46, 46));
        this.jButtSketch2.setMinimumSize(new Dimension(46, 46));
        this.jButtSketch2.setPreferredSize(new Dimension(46, 46));
        this.jButtSketch2.setSelected(true);
        this.jButtPoly2.setToolTipText("Polygon");
        this.jButtPoly2.setFocusable(false);
        this.jButtPoly2.setMaximumSize(new Dimension(46, 46));
        this.jButtPoly2.setMinimumSize(new Dimension(46, 46));
        this.jButtPoly2.setPreferredSize(new Dimension(46, 46));
        this.sketchDialog = new ButtonDialog(this.frame, this);
        this.sketchDialog.add(this.jButtSketch2);
        this.sketchDialog.add(this.jButtPoly2);
        if (!MAC_OS_X) {
            this.initPlatform();
        }
        this.setImageIcons(this.frame.isDarkTheme());
        this.dialogs = new DialogGroup();
        this.lineDialog.setWidth(2);
        this.dialogs.addPropertyChangeListener("dialog", this.lineDialog);
        this.sketchDialog.setWidth(2);
        this.dialogs.addPropertyChangeListener("dialog", this.sketchDialog);
        this.dummyDialog = new ButtonDialog(this.frame, this);
        this.dialogs.addPropertyChangeListener("dialog", this.dummyDialog);
        this.jSelectGroup.setSelected(this.jButtSelect.getModel(), true);
    }

    public void setImageIcons(boolean isDarkTheme) {
        this.jButtSelect.setIcon(FileUtils.createMultiDpiImageIcon("/images/select" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtRotate.setIcon(FileUtils.createMultiDpiImageIcon("/images/rotate" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtLine.setIcon(FileUtils.createMultiDpiImageIcon("/images/line" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtHorizontal.setIcon(FileUtils.createMultiDpiImageIcon("/images/horizontal" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtVertical.setIcon(FileUtils.createMultiDpiImageIcon("/images/vertical" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtCircle.setIcon(FileUtils.createMultiDpiImageIcon("/images/circle" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtSquare.setIcon(FileUtils.createMultiDpiImageIcon("/images/square" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtTriangle.setIcon(FileUtils.createMultiDpiImageIcon("/images/triangle" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtHexagon.setIcon(FileUtils.createMultiDpiImageIcon("/images/hexagon" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtPentagram.setIcon(FileUtils.createMultiDpiImageIcon("/images/pentagram" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtSketch.setIcon(FileUtils.createMultiDpiImageIcon("/images/sketch" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtPolygon.setIcon(FileUtils.createMultiDpiImageIcon("/images/polygon" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtText.setIcon(FileUtils.createMultiDpiImageIcon("/images/text" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtHoriz2.setIcon(FileUtils.createMultiDpiImageIcon("/images/horizontal" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtVert2.setIcon(FileUtils.createMultiDpiImageIcon("/images/vertical" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtSketch2.setIcon(FileUtils.createMultiDpiImageIcon("/images/sketch" + (isDarkTheme ? "-alt" : "") + ".png"));
        this.jButtPoly2.setIcon(FileUtils.createMultiDpiImageIcon("/images/polygon" + (isDarkTheme ? "-alt" : "") + ".png"));
    }

    public void initPlatform() {
        this.setMinimumSize(new Dimension(44, 0));
        this.setPreferredSize(new Dimension(44, 0));
        this.jButtSelect.setMaximumSize(new Dimension(44, 44));
        this.jButtSelect.setMinimumSize(new Dimension(44, 44));
        this.jButtSelect.setPreferredSize(new Dimension(44, 44));
        this.jButtRotate.setMaximumSize(new Dimension(44, 44));
        this.jButtRotate.setMinimumSize(new Dimension(44, 44));
        this.jButtRotate.setPreferredSize(new Dimension(44, 44));
        this.jButtHorizontal.setMaximumSize(new Dimension(44, 44));
        this.jButtHorizontal.setMinimumSize(new Dimension(44, 44));
        this.jButtHorizontal.setPreferredSize(new Dimension(44, 44));
        this.jButtVertical.setMaximumSize(new Dimension(44, 44));
        this.jButtVertical.setMinimumSize(new Dimension(44, 44));
        this.jButtVertical.setPreferredSize(new Dimension(44, 44));
        this.jButtLine.setMaximumSize(new Dimension(44, 44));
        this.jButtLine.setMinimumSize(new Dimension(44, 44));
        this.jButtLine.setPreferredSize(new Dimension(44, 44));
        this.jButtCircle.setMaximumSize(new Dimension(44, 44));
        this.jButtCircle.setMinimumSize(new Dimension(44, 44));
        this.jButtCircle.setPreferredSize(new Dimension(44, 44));
        this.jButtSquare.setMaximumSize(new Dimension(44, 44));
        this.jButtSquare.setMinimumSize(new Dimension(44, 44));
        this.jButtSquare.setPreferredSize(new Dimension(44, 44));
        this.jButtTriangle.setMaximumSize(new Dimension(44, 44));
        this.jButtTriangle.setMinimumSize(new Dimension(44, 44));
        this.jButtTriangle.setPreferredSize(new Dimension(44, 44));
        this.jButtHexagon.setMaximumSize(new Dimension(44, 44));
        this.jButtHexagon.setMinimumSize(new Dimension(44, 44));
        this.jButtHexagon.setPreferredSize(new Dimension(44, 44));
        this.jButtPentagram.setMaximumSize(new Dimension(44, 44));
        this.jButtPentagram.setMinimumSize(new Dimension(44, 44));
        this.jButtPentagram.setPreferredSize(new Dimension(44, 44));
        this.jButtPolygon.setMaximumSize(new Dimension(44, 44));
        this.jButtPolygon.setMinimumSize(new Dimension(44, 44));
        this.jButtPolygon.setPreferredSize(new Dimension(44, 44));
        this.jButtSketch.setMaximumSize(new Dimension(44, 44));
        this.jButtSketch.setMinimumSize(new Dimension(44, 44));
        this.jButtSketch.setPreferredSize(new Dimension(44, 44));
        this.jButtText.setMaximumSize(new Dimension(44, 44));
        this.jButtText.setMinimumSize(new Dimension(44, 44));
        this.jButtText.setPreferredSize(new Dimension(44, 44));
        this.jGridBox.setMaximumSize(new Dimension(44, 26));
        this.jGridBox.setMinimumSize(new Dimension(44, 26));
        this.jGridBox.setPreferredSize(new Dimension(44, 26));
        this.jGridLabel.setMaximumSize(new Dimension(44, 16));
        this.jGridLabel.setMinimumSize(new Dimension(44, 16));
        this.jGridLabel.setPreferredSize(new Dimension(44, 16));
        this.jButtHoriz2.setMaximumSize(new Dimension(44, 44));
        this.jButtHoriz2.setMinimumSize(new Dimension(44, 44));
        this.jButtHoriz2.setPreferredSize(new Dimension(44, 44));
        this.jButtVert2.setMaximumSize(new Dimension(44, 44));
        this.jButtVert2.setMinimumSize(new Dimension(44, 44));
        this.jButtVert2.setPreferredSize(new Dimension(44, 44));
        this.jButtSketch2.setMaximumSize(new Dimension(44, 44));
        this.jButtSketch2.setMinimumSize(new Dimension(44, 44));
        this.jButtSketch2.setPreferredSize(new Dimension(44, 44));
        this.jButtPoly2.setMaximumSize(new Dimension(44, 44));
        this.jButtPoly2.setMinimumSize(new Dimension(44, 44));
        this.jButtPoly2.setPreferredSize(new Dimension(44, 44));
    }

    private JToggleButton makeButtonListener(JToggleButton b) {
        b.addActionListener(this);
        return b;
    }

    private JCheckBox makeCheckBoxListener(JCheckBox c) {
        c.addActionListener(this);
        return c;
    }

    public void setButtonMode(int control) {
        switch (control) {
            case 0: {
                this.jSelectGroup.setSelected(this.jButtSelect.getModel(), true);
                this.canvas.setDrawType(null);
                this.canvas.changeHandler(MouseHandlerType.SELECTION);
                this.jToolPanel.setPanel(1);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 1: {
                this.jSelectGroup.setSelected(this.jButtRotate.getModel(), true);
                this.canvas.setDrawType(null);
                this.canvas.changeHandler(MouseHandlerType.ROTATION);
                this.jToolPanel.setPanel(1);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 2: {
                this.jSelectGroup.setSelected(this.jButtLine.getModel(), true);
                this.canvas.setDrawType(DrawingType.LINE);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 3: {
                this.remove(3);
                this.add((Component)this.jButtHorizontal, 3);
                this.repaint();
                this.jSelectGroup.setSelected(this.jButtHorizontal.getModel(), true);
                SwingUtilities.updateComponentTreeUI(this);
                this.canvas.setDrawType(DrawingType.HORIZONTAL);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                if (this.jButtHorizontal.isClicked()) {
                    this.lineDialog.setLocation(this.jButtHorizontal);
                    this.lineDialog.setResizable(false);
                    boolean visible = this.lineDialog.isVisible();
                    this.lineDialog.setVisible(!visible);
                }
                this.dialogs.setDialog(this.lineDialog);
                break;
            }
            case 4: {
                this.remove(3);
                this.add((Component)this.jButtVertical, 3);
                this.repaint();
                this.jSelectGroup.setSelected(this.jButtVertical.getModel(), true);
                SwingUtilities.updateComponentTreeUI(this);
                this.canvas.setDrawType(DrawingType.VERTICAL);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                if (this.jButtVertical.isClicked()) {
                    this.lineDialog.setLocation(this.jButtVertical);
                    this.lineDialog.setResizable(false);
                    boolean visible = this.lineDialog.isVisible();
                    this.lineDialog.setVisible(!visible);
                }
                this.dialogs.setDialog(this.lineDialog);
                break;
            }
            case 5: {
                this.jSelectGroup.setSelected(this.jButtCircle.getModel(), true);
                this.canvas.setDrawType(DrawingType.ELLIPSE);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                break;
            }
            case 6: {
                this.jSelectGroup.setSelected(this.jButtSquare.getModel(), true);
                this.canvas.setDrawType(DrawingType.RECTANGLE);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                break;
            }
            case 7: {
                this.jSelectGroup.setSelected(this.jButtTriangle.getModel(), true);
                this.canvas.setDrawType(DrawingType.ISOSCELES);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 8: {
                this.jSelectGroup.setSelected(this.jButtHexagon.getModel(), true);
                this.canvas.setDrawType(DrawingType.HEXAGON);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 9: {
                this.jSelectGroup.setSelected(this.jButtPentagram.getModel(), true);
                this.canvas.setDrawType(DrawingType.PENTAGRAM);
                this.canvas.changeHandler(MouseHandlerType.DRAWITEM);
                this.jToolPanel.setPanel(2);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            case 11: {
                this.remove(9);
                this.add((Component)this.jButtSketch, 9);
                this.repaint();
                this.jSelectGroup.setSelected(this.jButtSketch.getModel(), true);
                SwingUtilities.updateComponentTreeUI(this);
                this.canvas.setDrawType(DrawingType.SKETCH);
                this.canvas.changeHandler(MouseHandlerType.SKETCH);
                this.jToolPanel.setPanel(2);
                if (this.jButtSketch.isClicked()) {
                    this.sketchDialog.setLocation(this.jButtSketch);
                    this.sketchDialog.setResizable(false);
                    boolean visible = this.sketchDialog.isVisible();
                    this.sketchDialog.setVisible(!visible);
                }
                this.dialogs.setDialog(this.sketchDialog);
                break;
            }
            case 10: {
                this.remove(9);
                this.add((Component)this.jButtPolygon, 9);
                this.repaint();
                this.jSelectGroup.setSelected(this.jButtPolygon.getModel(), true);
                SwingUtilities.updateComponentTreeUI(this);
                this.canvas.setDrawType(DrawingType.POLYGON);
                this.canvas.changeHandler(MouseHandlerType.SKETCH);
                this.jToolPanel.setPanel(2);
                if (this.jButtPolygon.isClicked()) {
                    this.sketchDialog.setLocation(this.jButtPolygon);
                    this.sketchDialog.setResizable(false);
                    boolean visible = this.sketchDialog.isVisible();
                    this.sketchDialog.setVisible(!visible);
                }
                this.dialogs.setDialog(this.sketchDialog);
                break;
            }
            case 12: {
                this.jSelectGroup.setSelected(this.jButtText.getModel(), true);
                this.canvas.setDrawType(DrawingType.TEXT);
                this.canvas.changeHandler(MouseHandlerType.TEXT);
                this.jToolPanel.setPanel(3);
                this.dialogs.setDialog(this.dummyDialog);
                break;
            }
            default: {
                this.jSelectGroup.setSelected(this.jButtSelect.getModel(), true);
                this.dialogs.setDialog(this.dummyDialog);
            }
        }
        if (this.canvas.getView().getTextController().isRichText()) {
            this.canvas.setFontStyle(0);
            this.canvas.getToolPanel().resetFormattingButtons();
        }
        this.canvas.getView().setEditing(KeyboardHandlerType.MOVE);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String cmd;
        switch (cmd = actionEvent.getActionCommand()) {
            case "Select": {
                this.frame.setStatus("Selection mode.");
                this.setButtonMode(0);
                break;
            }
            case "Rotate": {
                this.frame.setStatus("Rotation mode.");
                this.setButtonMode(1);
                break;
            }
            case "Line": {
                this.frame.setInsertMenu(0);
                this.setButtonMode(2);
                break;
            }
            case "Horizontal": {
                this.frame.setInsertMenu(1);
                this.setButtonMode(3);
                break;
            }
            case "Vertical": {
                this.frame.setInsertMenu(2);
                this.setButtonMode(4);
                break;
            }
            case "Circle": {
                this.frame.setInsertMenu(3);
                this.setButtonMode(5);
                break;
            }
            case "Square": {
                this.frame.setInsertMenu(4);
                this.setButtonMode(6);
                break;
            }
            case "Triangle": {
                this.frame.setInsertMenu(5);
                this.setButtonMode(7);
                break;
            }
            case "Hexagon": {
                this.frame.setInsertMenu(6);
                this.setButtonMode(8);
                break;
            }
            case "Pentagram": {
                this.frame.setInsertMenu(7);
                this.setButtonMode(9);
                break;
            }
            case "Polygon": {
                this.frame.setInsertMenu(8);
                this.setButtonMode(10);
                break;
            }
            case "Sketch": {
                this.frame.setInsertMenu(9);
                this.setButtonMode(11);
                break;
            }
            case "Text": {
                this.frame.setInsertMenu(10);
                this.setButtonMode(12);
                break;
            }
            case "toggleGrid": {
                boolean gridVisible = this.canvas.isGridVisible();
                this.canvas.setGrid(!gridVisible);
                this.canvas.setSnapTo(!gridVisible);
                this.canvas.repaint();
                break;
            }
            case "toggleAlign": {
                this.canvas.setGuideEnabled(this.jGuideBox.getModel().isSelected());
            }
        }
    }

    public void updateComponentUI() {
        SwingUtilities.updateComponentTreeUI(this.lineDialog);
        SwingUtilities.updateComponentTreeUI(this.sketchDialog);
        this.redraw(this.jButtHorizontal);
        this.redraw(this.jButtVertical);
        this.redraw(this.jButtSketch);
        this.redraw(this.jButtPolygon);
    }

    private void redraw(JComponent component) {
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public void toggleButton(ButtonDialog dialog) {
        if (dialog.equals(this.lineDialog)) {
            int i = this.lineDialog.getSelected();
            switch (i) {
                case 0: {
                    this.frame.setInsertMenu(1);
                    this.setButtonMode(3);
                    break;
                }
                case 1: {
                    this.frame.setInsertMenu(2);
                    this.setButtonMode(4);
                    break;
                }
            }
        } else if (dialog.equals(this.sketchDialog)) {
            int i = this.sketchDialog.getSelected();
            switch (i) {
                case 0: {
                    this.frame.setInsertMenu(9);
                    this.setButtonMode(11);
                    break;
                }
                case 1: {
                    this.frame.setInsertMenu(8);
                    this.setButtonMode(10);
                    break;
                }
            }
        }
    }
}

