/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JToggleButton;
import net.perspective.draw.MainFrame;

public class ToggleButton
extends JToggleButton {
    public boolean clicked;
    private final MainFrame frame;
    private static final long serialVersionUID = 1L;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public ToggleButton(MainFrame f) {
        this.frame = f;
        this.addMouseListener(new MouseHandler());
        this.clicked = false;
    }

    @Override
    public void paintComponent(Graphics g) {
        int[] xs = new int[]{0, 0, 0, 0};
        int[] ys = new int[]{0, 0, 0, 0};
        super.paintComponent(g);
        g.setColor(this.frame.getThemeAccentColor());
        Dimension size = super.getPreferredSize();
        int right = size.width - 5;
        int bottom = MAC_OS_X ? size.height - 4 : size.height - 3;
        xs[0] = right - 6;
        ys[0] = bottom;
        xs[1] = right;
        ys[1] = bottom;
        xs[2] = right;
        ys[2] = bottom - 6;
        g.fillPolygon(xs, ys, 3);
        g.drawPolygon(xs, ys, 3);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public boolean isClicked() {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Dimension size = ToggleButton.this.getPreferredSize();
            int left = size.height - 15;
            int top = size.width - 15;
            Rectangle2D.Float target = new Rectangle2D.Float(left, top, 15.0f, 15.0f);
            if (target.contains(x, y)) {
                ToggleButton.this.clicked = true;
            }
        }
    }
}

