/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.rtf.RTFEditorKit;
import net.perspective.draw.MainFrame;
import net.perspective.draw.util.ReplacingReader;

public class KeyboardHelp
extends JFrame
implements ActionListener {
    protected int aboutTop;
    protected int aboutLeft;
    private final MainFrame frame;
    private JEditorPane jEditorPane;
    private JButton jOkButton;
    private JScrollPane jScrollPane;
    private JPanel bottomPanel;
    protected static int aboutWidth = 500;
    protected static int aboutHeight = 550;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final Logger logger = Logger.getLogger(KeyboardHelp.class.getName());

    public KeyboardHelp(MainFrame frame) {
        super("");
        this.frame = frame;
        this.initComponents();
    }

    public void init() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.jEditorPane.setEditorKit(new RTFEditorKit());
        this.pack();
        this.setSize(aboutWidth, aboutHeight);
    }

    public void readDocument(boolean isDarkMode) {
        this.jEditorPane.setOpaque(true);
        this.jEditorPane.setBackground(this.frame.getThemeBackgroundColor());
        try {
            int b;
            byte[] search = "\\cf0".getBytes("UTF-8");
            byte[] replacement = isDarkMode ? "\\cf1".getBytes("UTF-8") : "\\cf0".getBytes("UTF-8");
            ReplacingReader replacer = MAC_OS_X ? new ReplacingReader(new InputStreamReader(this.getClass().getResource("/accelerators-mac.rtf").openStream()), search, replacement) : new ReplacingReader(new InputStreamReader(this.getClass().getResource("/accelerators.rtf").openStream()), search, replacement);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (-1 != (b = replacer.read())) {
                bos.write(b);
            }
            StringReader reader = new StringReader(bos.toString());
            this.jEditorPane.read(reader, (Object)this);
            this.jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.jEditorPane.setFont(new Font("Inter", 0, 14));
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.jOkButton = new JButton();
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setMargin(new Insets(5, 8, 0, 8));
        this.jScrollPane.setViewportView(this.jEditorPane);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.jOkButton.setText("OK");
        this.jOkButton.addActionListener(e -> this.setVisible(false));
        this.jOkButton.setAlignmentX(0.5f);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.add(this.jOkButton);
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.bottomPanel, "Last");
    }

    @Override
    public void setLocation(int left, int top) {
        Rectangle bounds = this.getBounds();
        this.aboutLeft = left - bounds.width / 2;
        this.aboutTop = top - bounds.height / 2;
        super.setLocation(this.aboutLeft, this.aboutTop);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            KeyboardHelp.this.setVisible(false);
        }
    }
}

