/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.perspective.draw.CanvasView;
import net.perspective.draw.ImageItem;
import net.perspective.draw.MainFrame;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.svg.SVGUtils;
import net.perspective.draw.util.FileUtils;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class IconLibrary
extends JFrame
implements ActionListener {
    private final MainFrame application;
    private final CanvasView view;
    private final ExecutorService executor;
    private static final Logger logger = Logger.getLogger(IconLibrary.class.getName());
    private double shift = 20.0;
    List<String> svgStrings = Arrays.asList("bed.svg", "bridge-water.svg", "bridge.svg", "bullhorn.svg", "bus.svg", "cable-car.svg", "camera.svg", "campground.svg", "car-side.svg", "car.svg", "caravan.svg", "cart-flatbed.svg", "cat.svg", "child-dress.svg", "child.svg", "children.svg", "circle-exclamation.svg", "circle-h.svg", "circle-info.svg", "city.svg", "compass.svg", "dog.svg", "fish-fins.svg", "gas-pump.svg", "gear.svg", "gift.svg", "house.svg", "industry.svg", "landmark.svg", "location-dot.svg", "masks-theater.svg", "motorcycle.svg", "mountains.svg", "mug-saucer.svg", "people-line.svg", "people-pulling.svg", "people-roof.svg", "person-biking.svg", "person-digging.svg", "person-dress.svg", "person-falling.svg", "person-hiking.svg", "person-shelter.svg", "person-skiing.svg", "person-swimming.svg", "person-walking-luggage.svg", "person.svg", "phone-volume.svg", "plane-departure.svg", "plane.svg", "recycle.svg", "restroom.svg", "road-barrier.svg", "sailboat.svg", "school.svg", "ship.svg", "square-phone.svg", "tractor.svg", "train-subway.svg", "trees.svg", "truck-field.svg", "utensils.svg", "water.svg", "wheelchair.svg");

    public IconLibrary(MainFrame application) {
        super("");
        this.application = application;
        this.view = application.getCanvas().getView();
        this.executor = Executors.newCachedThreadPool();
        this.initComponents();
    }

    public void init() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.pack();
        this.setSize(512, 512);
    }

    private void initComponents() {
        this.setLayout(new GridLayout(8, 8));
        this.prepareIconLibrary();
    }

    public void redraw() {
        SwingUtilities.updateComponentTreeUI(this);
        this.getRootPane().getContentPane().removeAll();
        this.prepareIconLibrary();
    }

    private void prepareIconLibrary() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                try {
                    BufferedImage image = this.rasterizeSVGResource(this.svgStrings.get(i * 8 + j), this.toRGBCode(this.application.getThemeAccentColor()), Float.valueOf(36.0f));
                    JButton iconButton = new JButton(new ImageIcon(image));
                    iconButton.setActionCommand("ia_" + this.svgStrings.get(i * 8 + j));
                    iconButton.addActionListener(ev -> this.insertSVGAction(ev));
                    iconButton.setFocusable(false);
                    this.add(iconButton);
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Can't fetch resource {0}", this.svgStrings.get(i * 8 + j));
                }
            }
        }
    }

    public void resetShift() {
        this.shift = 20.0;
    }

    public void insertVectorSVGAction(ActionEvent ev) {
        String filename = ((JButton)ev.getSource()).getActionCommand().substring(3);
        SVGUtils svgreader = new SVGUtils(this.application);
        CompletableFuture.runAsync(() -> svgreader.parseSVG(filename, this.shift), this.executor).thenRun(() -> this.shift += 45.0);
    }

    public void insertSVGAction(ActionEvent ev) {
        String filename = ((JButton)ev.getSource()).getActionCommand().substring(3);
        CompletableFuture.runAsync(() -> {
            try {
                BufferedImage image = this.rasterizeSVGResource(filename, this.toRGBCode(this.application.getCanvas().getFillColor()), Float.valueOf(512.0f));
                Picture picture = new Picture(this.shift, this.shift);
                ImageItem item = new ImageItem(image);
                item.setFormat(FileUtils.getExtension(filename));
                int index = this.view.setImageItem(item);
                double width = image.getWidth();
                double height = image.getHeight();
                double scale = 64.0 / height;
                logger.log(Level.FINEST, "Image relative scale: {0}", scale);
                picture.setImage(index, width, height);
                picture.setScale(scale);
                SwingUtilities.invokeLater(() -> {
                    this.view.setNewItem(picture);
                    this.view.addItemToCanvas(picture);
                });
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Can't fetch resource {0}", filename);
            }
        }, this.executor).thenRun(() -> this.shift += 45.0);
    }

    private BufferedImage rasterizeSVGResource(String filename, String fillColor, Float size) throws IOException {
        final BufferedImage[] imagePointer = new BufferedImage[1];
        String css = "svg {shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;fill: " + fillColor + ";}";
        Path cssFile = Files.createTempFile(Files.createTempDirectory("temp-dir", new FileAttribute[0]), "batik-default-override-", ".css", new FileAttribute[0]);
        FileUtils.writeStringToFile(cssFile.toFile(), css);
        TranscodingHints transcoderHints = new TranscodingHints();
        transcoderHints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)cssFile.toUri().toString());
        transcoderHints.put((Object)SVGAbstractTranscoder.KEY_ALLOW_EXTERNAL_RESOURCES, (Object)Boolean.TRUE);
        transcoderHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)size);
        try (InputStream file = this.getClass().getResourceAsStream("/svg/" + filename);){
            TranscoderInput input = new TranscoderInput(file);
            ImageTranscoder t = new ImageTranscoder(this){

                public BufferedImage createImage(int width, int height) {
                    return new BufferedImage(width, height, 2);
                }

                public void writeImage(BufferedImage image, TranscoderOutput out) throws TranscoderException {
                    imagePointer[0] = image;
                }
            };
            t.setTranscodingHints(transcoderHints);
            t.transcode(input, null);
        }
        catch (TranscoderException ex) {
            logger.log(Level.SEVERE, "Couldn't convert {0}", filename);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Couldn't read SVG image {0}", filename);
        }
        return imagePointer[0];
    }

    public String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            IconLibrary.this.setVisible(false);
        }
    }
}

