/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.util.RailwayStroke;
import org.jhotdraw.geom.DoubleStroke;

public class Dropper {
    List<Float> strokeTypes = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(8.0f), Float.valueOf(10.0f));
    List<List<Float>> dashes1 = Arrays.asList(Arrays.asList(Float.valueOf(1.5f), Float.valueOf(1.5f)), Arrays.asList(Float.valueOf(1.5f), Float.valueOf(1.5f)), Arrays.asList(Float.valueOf(2.0f), Float.valueOf(2.0f)), Arrays.asList(Float.valueOf(3.0f), Float.valueOf(3.0f)), Arrays.asList(Float.valueOf(4.0f), Float.valueOf(4.0f)), Arrays.asList(Float.valueOf(5.0f), Float.valueOf(5.0f)), Arrays.asList(Float.valueOf(6.0f), Float.valueOf(6.0f)), Arrays.asList(Float.valueOf(8.0f), Float.valueOf(8.0f)), Arrays.asList(Float.valueOf(10.0f), Float.valueOf(10.0f)));
    List<List<Float>> dashes2 = Arrays.asList(Arrays.asList(Float.valueOf(2.0f), Float.valueOf(2.0f)), Arrays.asList(Float.valueOf(3.0f), Float.valueOf(3.0f)), Arrays.asList(Float.valueOf(4.0f), Float.valueOf(4.0f)), Arrays.asList(Float.valueOf(5.0f), Float.valueOf(5.0f)), Arrays.asList(Float.valueOf(6.0f), Float.valueOf(6.0f)), Arrays.asList(Float.valueOf(8.0f), Float.valueOf(8.0f)), Arrays.asList(Float.valueOf(10.0f), Float.valueOf(10.0f)), Arrays.asList(Float.valueOf(12.0f), Float.valueOf(12.0f)), Arrays.asList(Float.valueOf(14.0f), Float.valueOf(14.0f)));
    List<List<Float>> dashes3 = Arrays.asList(Arrays.asList(Float.valueOf(4.0f), Float.valueOf(4.0f)), Arrays.asList(Float.valueOf(6.0f), Float.valueOf(6.0f)), Arrays.asList(Float.valueOf(8.0f), Float.valueOf(8.0f)), Arrays.asList(Float.valueOf(10.0f), Float.valueOf(10.0f)), Arrays.asList(Float.valueOf(12.0f), Float.valueOf(12.0f)), Arrays.asList(Float.valueOf(14.0f), Float.valueOf(14.0f)), Arrays.asList(Float.valueOf(16.0f), Float.valueOf(16.0f)), Arrays.asList(Float.valueOf(18.0f), Float.valueOf(18.0f)), Arrays.asList(Float.valueOf(20.0f), Float.valueOf(20.0f)));
    List<List<Float>> dashes4 = Arrays.asList(Arrays.asList(Float.valueOf(3.0f), Float.valueOf(2.0f), Float.valueOf(2.0f), Float.valueOf(2.0f)), Arrays.asList(Float.valueOf(5.0f), Float.valueOf(3.0f), Float.valueOf(3.0f), Float.valueOf(3.0f)), Arrays.asList(Float.valueOf(8.0f), Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(4.0f)), Arrays.asList(Float.valueOf(10.0f), Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(5.0f)), Arrays.asList(Float.valueOf(12.0f), Float.valueOf(6.0f), Float.valueOf(6.0f), Float.valueOf(6.0f)), Arrays.asList(Float.valueOf(16.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f)), Arrays.asList(Float.valueOf(18.0f), Float.valueOf(10.0f), Float.valueOf(10.0f), Float.valueOf(10.0f)), Arrays.asList(Float.valueOf(24.0f), Float.valueOf(12.0f), Float.valueOf(12.0f), Float.valueOf(12.0f)), Arrays.asList(Float.valueOf(28.0f), Float.valueOf(14.0f), Float.valueOf(14.0f), Float.valueOf(14.0f)));

    protected Stroke selectStroke(Integer strokeId, String strokeStyle) {
        Stroke stroke = switch (strokeStyle) {
            case "style1" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style2" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes1.get(strokeId)), 0.0f);
            case "style3" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes2.get(strokeId)), 0.0f);
            case "style4" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes3.get(strokeId)), 0.0f);
            case "style5" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes4.get(strokeId)), 0.0f);
            case "style6" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style7" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes1.get(strokeId)), 0.0f);
            case "style8" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style9" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes1.get(strokeId)), 0.0f);
            case "style10" -> new DoubleStroke(3.0, 1.0);
            case "style11" -> new DoubleStroke(4.0, 2.0);
            case "style12" -> new DoubleStroke(10.0, 3.0);
            case "style13" -> new RailwayStroke(8.0f, 2.0f);
            default -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
        };
        return stroke;
    }

    protected Stroke selectPlainStroke(Integer strokeId, String strokeStyle) {
        BasicStroke stroke = switch (strokeStyle) {
            case "style1" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style2" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes1.get(strokeId)), 0.0f);
            case "style3" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes2.get(strokeId)), 0.0f);
            case "style4" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes3.get(strokeId)), 0.0f);
            case "style5" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 0, 0, 1.0f, this.getDashes(this.dashes4.get(strokeId)), 0.0f);
            case "style6" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style7" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style8" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style9" -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
            case "style10" -> new BasicStroke(3.0f, 1, 1);
            case "style11" -> new BasicStroke(5.0f, 1, 1);
            case "style12" -> new BasicStroke(12.0f, 1, 1);
            case "style13" -> new BasicStroke(12.0f, 1, 1);
            default -> new BasicStroke(this.strokeTypes.get(strokeId).floatValue(), 1, 1);
        };
        return stroke;
    }

    public int getStrokeIdLinear(BasicStroke stroke) {
        float width = stroke.getLineWidth();
        int i = 0;
        while (!(this.strokeTypes.get(i).floatValue() > width) && ++i < this.strokeTypes.size()) {
        }
        return i - 1;
    }

    public int getStrokeIdBinary(BasicStroke stroke) {
        float width = stroke.getLineWidth();
        int j = 0;
        int i = this.strokeTypes.size();
        int k = (i + j) / 2;
        while (true) {
            if (this.strokeTypes.get(k).floatValue() <= width) {
                j = k;
            }
            if (this.strokeTypes.get(k).floatValue() > width) {
                i = k;
            }
            if (i - j < 2) break;
            k = (i + j) / 2;
        }
        return j;
    }

    public int getStrokeIdFunctionalStream(BasicStroke stroke) {
        return IntStream.range(0, this.strokeTypes.size()).filter(i -> this.strokeTypes.get(i).floatValue() <= stroke.getLineWidth()).max().getAsInt();
    }

    public String getStyleSelector(Stroke stroke, ArrowType arrow) {
        String styleId = "style1";
        if (stroke instanceof RailwayStroke) {
            return "style13";
        }
        if (stroke instanceof DoubleStroke) {
            DoubleStroke doubleStroke = (DoubleStroke)stroke;
            if (doubleStroke.getInnerWidth() == 3.0) {
                return "style10";
            }
            if (doubleStroke.getInnerWidth() == 4.0) {
                return "style11";
            }
            if (doubleStroke.getInnerWidth() == 10.0) {
                return "style12";
            }
        }
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int strokeId = this.getStrokeIdBinary(basicStroke);
            float[] dash = basicStroke.getDashArray();
            if (dash == null) {
                dash = new float[]{};
            }
            if (dash.length == 0) {
                switch (arrow) {
                    case NONE: {
                        String string = "style1";
                        break;
                    }
                    case END: {
                        String string = "style6";
                        break;
                    }
                    case BOTH: {
                        String string = "style8";
                        break;
                    }
                    default: {
                        String string = styleId = "style1";
                    }
                }
            }
            if (this.compareDashes(dash, this.getDashes(this.dashes1.get(strokeId)))) {
                switch (arrow) {
                    case NONE: {
                        String string = "style2";
                        break;
                    }
                    case END: {
                        String string = "style7";
                        break;
                    }
                    case BOTH: {
                        String string = "style9";
                        break;
                    }
                    default: {
                        String string = styleId = "style2";
                    }
                }
            }
            if (this.compareDashes(dash, this.getDashes(this.dashes2.get(strokeId)))) {
                styleId = "style3";
            }
            if (this.compareDashes(dash, this.getDashes(this.dashes3.get(strokeId)))) {
                styleId = "style4";
            }
            if (this.compareDashes(dash, this.getDashes(this.dashes4.get(strokeId)))) {
                styleId = "style5";
            }
        }
        return styleId;
    }

    private float[] getDashes(List<Float> items) {
        float[] value = new float[4];
        int i = 0;
        for (Float item : items) {
            value[i] = item.floatValue();
            ++i;
        }
        return value;
    }

    private boolean compareDashes(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

