/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.perspective.draw.swing.ToolButtons;

public class ButtonDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    ToolButtons toolbar;
    private ButtonGroup group;
    private int selection = 0;
    private JPanel panel;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public ButtonDialog(JFrame frame, ToolButtons parent) {
        super((Frame)frame, true);
        this.toolbar = parent;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.setFocusable(false);
        this.setUndecorated(true);
        this.setModal(false);
        this.setMinimumSize(new Dimension(0, 46));
        this.setMaximumSize(new Dimension(46, 46));
        this.setPreferredSize(new Dimension(92, 46));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        super.add(this.panel);
        this.group = new ButtonGroup();
    }

    public void setWidth(int n) {
        this.setSize(n * 46, 46);
        if (!MAC_OS_X) {
            this.setSize(n * 44, 44);
        }
    }

    private JToggleButton makeButtonListener(JToggleButton b) {
        b.addActionListener(this);
        return b;
    }

    @Override
    public Component add(Component b) {
        this.panel.add(b);
        if (b instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)b;
            this.group.add(button);
            button.setActionCommand("Button");
            this.makeButtonListener(button);
        }
        return this;
    }

    public void setLocation(AbstractButton b) {
        Point position = b.getLocationOnScreen();
        int left = position.x + b.getWidth();
        int top = position.y + b.getHeight();
        this.setLocation(left, top - 5);
    }

    public void setSelected(ButtonModel m) {
        int i = 0;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            if (buttons.nextElement().getModel().equals(m)) {
                this.selection = i;
            }
            ++i;
        }
        this.toolbar.toggleButton(this);
    }

    public int getSelected() {
        return this.selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Button")) {
            this.setSelected(this.group.getSelection());
            this.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (!newValue.equals(this)) {
            super.setVisible(false);
        }
    }
}

