/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.svg;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.svg.SVGUtils;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.ParseException;

class SubPathIterator
extends DefaultPathHandler {
    private final SVGUtils svgHandler;
    private final List<Path2D.Double> subPaths = new ArrayList<Path2D.Double>();
    private Path2D.Double currentPath = null;
    private Point2D.Double lastCubicControlPoint = null;
    private Point2D.Double lastQuadraticControlPoint = null;
    private boolean lastWasCubic = false;
    private boolean lastWasQuadratic = false;
    private static final Logger logger = Logger.getLogger(SubPathIterator.class.getName());

    SubPathIterator(SVGUtils svgHandler) {
        this.svgHandler = svgHandler;
    }

    public List<Path2D.Double> getSubPaths() {
        this.finalizeCurrentPath();
        return new ArrayList<Path2D.Double>(this.subPaths);
    }

    private void startNewSubPath() {
        this.finalizeCurrentPath();
        this.currentPath = new Path2D.Double();
        this.lastCubicControlPoint = null;
        this.lastQuadraticControlPoint = null;
        this.lastWasCubic = false;
        this.lastWasQuadratic = false;
        logger.finest("Started new subpath");
    }

    private void finalizeCurrentPath() {
        if (this.currentPath != null && !this.isPathEmpty(this.currentPath)) {
            this.subPaths.add(this.currentPath);
            logger.log(Level.FINEST, "Finalized subpath {0}", this.subPaths.size());
        }
        this.currentPath = null;
    }

    private boolean isPathEmpty(Path2D path) {
        return path.getCurrentPoint() == null;
    }

    private void resetCurveTracking() {
        this.lastWasCubic = false;
        this.lastWasQuadratic = false;
    }

    public void movetoAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: movetoAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        this.startNewSubPath();
        this.currentPath.moveTo(x, y);
        this.resetCurveTracking();
    }

    public void movetoRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: movetoRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        this.startNewSubPath();
        Point2D currentPoint = this.currentPath.getCurrentPoint();
        if (currentPoint != null) {
            this.currentPath.moveTo(currentPoint.getX() + (double)x, currentPoint.getY() + (double)y);
        } else {
            this.currentPath.moveTo(x, y);
        }
        this.resetCurveTracking();
    }

    public void linetoAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            this.currentPath.lineTo(x, y);
        }
        this.resetCurveTracking();
    }

    public void linetoRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.currentPath.lineTo(currentPoint.getX() + (double)x, currentPoint.getY() + (double)y);
            } else {
                this.currentPath.lineTo(x, y);
            }
        }
        this.resetCurveTracking();
    }

    public void curvetoCubicAbs(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoCubicAbs({0}, {1}, {2}, {3}, {4}, {5})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x3, y3);
        } else {
            this.currentPath.curveTo(x1, y1, x2, y2, x3, y3);
        }
        this.lastCubicControlPoint = new Point2D.Double(x2, y2);
        this.lastWasCubic = true;
        this.lastWasQuadratic = false;
    }

    public void curvetoCubicRel(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x3, y3);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                double baseX = currentPoint.getX();
                double baseY = currentPoint.getY();
                this.currentPath.curveTo(baseX + (double)x1, baseY + (double)y1, baseX + (double)x2, baseY + (double)y2, baseX + (double)x3, baseY + (double)y3);
                this.lastCubicControlPoint = new Point2D.Double(baseX + (double)x2, baseY + (double)y2);
            } else {
                this.currentPath.curveTo(x1, y1, x2, y2, x3, y3);
                this.lastCubicControlPoint = new Point2D.Double(x2, y2);
            }
        }
        this.lastWasCubic = true;
        this.lastWasQuadratic = false;
    }

    public void curvetoQuadraticAbs(float x1, float y1, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoQuadraticAbs({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            this.currentPath.quadTo(x1, y1, x, y);
        }
        this.lastQuadraticControlPoint = new Point2D.Double(x1, y1);
        this.lastWasQuadratic = true;
        this.lastWasCubic = false;
    }

    public void curvetoQuadraticRel(float x1, float y1, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoQuadraticRel({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                double baseX = currentPoint.getX();
                double baseY = currentPoint.getY();
                this.currentPath.quadTo((float)(baseX + (double)x1), (float)(baseY + (double)y1), (float)(baseX + (double)x), (float)(baseY + (double)y));
                this.lastQuadraticControlPoint = new Point2D.Double(baseX + (double)x1, baseY + (double)y1);
            } else {
                this.currentPath.quadTo(x1, y1, x, y);
                this.lastQuadraticControlPoint = new Point2D.Double(x1, y1);
            }
        }
        this.lastWasQuadratic = true;
        this.lastWasCubic = false;
    }

    public void curvetoCubicSmoothAbs(float x2, float y2, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoCubicSmoothAbs({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                float y1;
                float x1;
                if (this.lastWasCubic && this.lastCubicControlPoint != null) {
                    x1 = (float)(2.0 * currentPoint.getX() - this.lastCubicControlPoint.getX());
                    y1 = (float)(2.0 * currentPoint.getY() - this.lastCubicControlPoint.getY());
                } else {
                    x1 = (float)currentPoint.getX();
                    y1 = (float)currentPoint.getY();
                }
                this.currentPath.curveTo(x1, y1, x2, y2, x, y);
            } else {
                this.currentPath.curveTo(x2, y2, x2, y2, x, y);
            }
        }
        this.lastCubicControlPoint = new Point2D.Double(x2, y2);
        this.lastWasCubic = true;
        this.lastWasQuadratic = false;
    }

    public void curvetoCubicSmoothRel(float x2, float y2, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoCubicSmoothRel({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                float y1;
                float x1;
                double baseX = currentPoint.getX();
                double baseY = currentPoint.getY();
                if (this.lastWasCubic && this.lastCubicControlPoint != null) {
                    x1 = (float)(2.0 * baseX - this.lastCubicControlPoint.getX());
                    y1 = (float)(2.0 * baseY - this.lastCubicControlPoint.getY());
                } else {
                    x1 = (float)baseX;
                    y1 = (float)baseY;
                }
                this.currentPath.curveTo(x1, y1, (float)(baseX + (double)x2), (float)(baseY + (double)y2), (float)(baseX + (double)x), (float)(baseY + (double)y));
                this.lastCubicControlPoint = new Point2D.Double(baseX + (double)x2, baseY + (double)y2);
            } else {
                this.currentPath.curveTo(x2, y2, x2, y2, x, y);
                this.lastCubicControlPoint = new Point2D.Double(x2, y2);
            }
        }
        this.lastWasCubic = true;
        this.lastWasQuadratic = false;
    }

    public void curvetoQuadraticSmoothAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoQuadraticSmoothAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                float y1;
                float x1;
                if (this.lastWasQuadratic && this.lastQuadraticControlPoint != null) {
                    x1 = (float)(2.0 * currentPoint.getX() - this.lastQuadraticControlPoint.getX());
                    y1 = (float)(2.0 * currentPoint.getY() - this.lastQuadraticControlPoint.getY());
                } else {
                    x1 = (float)currentPoint.getX();
                    y1 = (float)currentPoint.getY();
                }
                this.currentPath.quadTo(x1, y1, x, y);
                this.lastQuadraticControlPoint = new Point2D.Double(x1, y1);
            } else {
                this.currentPath.quadTo(x, y, x, y);
                this.lastQuadraticControlPoint = new Point2D.Double(x, y);
            }
        }
        this.lastWasQuadratic = true;
        this.lastWasCubic = false;
    }

    public void curvetoQuadraticSmoothRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: curvetoQuadraticSmoothRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                float y1;
                float x1;
                double baseX = currentPoint.getX();
                double baseY = currentPoint.getY();
                if (this.lastWasQuadratic && this.lastQuadraticControlPoint != null) {
                    x1 = (float)(2.0 * baseX - this.lastQuadraticControlPoint.getX());
                    y1 = (float)(2.0 * baseY - this.lastQuadraticControlPoint.getY());
                } else {
                    x1 = (float)baseX;
                    y1 = (float)baseY;
                }
                this.currentPath.quadTo(x1, y1, (float)(baseX + (double)x), (float)(baseY + (double)y));
                this.lastQuadraticControlPoint = new Point2D.Double(x1, y1);
            } else {
                this.currentPath.quadTo(x, y, x, y);
                this.lastQuadraticControlPoint = new Point2D.Double(x, y);
            }
        }
        this.lastWasQuadratic = true;
        this.lastWasCubic = false;
    }

    public void linetoHorizontalAbs(float x) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoHorizontalAbs({0})", Float.valueOf(x));
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, 0.0);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.currentPath.lineTo(x, currentPoint.getY());
            } else {
                this.currentPath.lineTo(x, 0.0);
            }
        }
        this.resetCurveTracking();
    }

    public void linetoHorizontalRel(float x) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoHorizontalRel({0})", Float.valueOf(x));
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, 0.0);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.currentPath.lineTo(currentPoint.getX() + (double)x, currentPoint.getY());
            } else {
                this.currentPath.lineTo(x, 0.0);
            }
        }
        this.resetCurveTracking();
    }

    public void linetoVerticalAbs(float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoVerticalAbs({0})", Float.valueOf(y));
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(0.0, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.currentPath.lineTo(currentPoint.getX(), y);
            } else {
                this.currentPath.lineTo(0.0, y);
            }
        }
        this.resetCurveTracking();
    }

    public void linetoVerticalRel(float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: linetoVerticalRel({0})", Float.valueOf(y));
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(0.0, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.currentPath.lineTo(currentPoint.getX(), currentPoint.getY() + (double)y);
            } else {
                this.currentPath.lineTo(0.0, y);
            }
        }
        this.resetCurveTracking();
    }

    public void arcAbs(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: arcAbs({0}, {1}, {2}, {3}, {4}, {5}, {6})", new Object[]{Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(xAxisRotation), largeArcFlag, sweepFlag, Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            this.svgHandler.addArcToPath(this.currentPath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, true);
        }
        this.resetCurveTracking();
    }

    public void arcRel(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "SubPathIterator: arcRel({0}, {1}, {2}, {3}, {4}, {5}, {6})", new Object[]{Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(xAxisRotation), largeArcFlag, sweepFlag, Float.valueOf(x), Float.valueOf(y)});
        if (this.currentPath == null) {
            this.startNewSubPath();
            this.currentPath.moveTo(x, y);
        } else {
            Point2D currentPoint = this.currentPath.getCurrentPoint();
            if (currentPoint != null) {
                this.svgHandler.addArcToPath(this.currentPath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, (float)(currentPoint.getX() + (double)x), (float)(currentPoint.getY() + (double)y), false);
            } else {
                this.svgHandler.addArcToPath(this.currentPath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, false);
            }
        }
        this.resetCurveTracking();
    }

    public void closePath() throws ParseException {
        logger.finest("SubPathIterator: closePath()");
        if (this.currentPath != null) {
            this.currentPath.closePath();
        }
        this.resetCurveTracking();
    }
}

