/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.svg;

import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import net.perspective.draw.svg.SVGUtils;
import org.w3c.dom.Element;

class SubPathInfo {
    private final Path2D.Double path2D;
    private final int index;
    private final Element originalElement;
    private final boolean isHole;
    private Color strokeColor;
    private Color fillColor;
    private Stroke stroke;
    private AffineTransform transform;
    private final SVGUtils svgUtils;

    public SubPathInfo(Path2D.Double path2D, int index, Element originalElement, boolean isHole, SVGUtils subpathInfo) {
        this.svgUtils = subpathInfo;
        this.path2D = path2D;
        this.index = index;
        this.originalElement = originalElement;
        this.isHole = isHole;
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.strokeColor = this.svgUtils.extractStrokeColor(this.originalElement);
        this.fillColor = this.svgUtils.extractFillColor(this.originalElement).orElse(null);
        this.stroke = this.svgUtils.createStrokeFromElement(this.originalElement);
        this.transform = this.svgUtils.getPathTransform(this.originalElement);
        this.customizeForSubPath();
    }

    private void customizeForSubPath() {
        if (this.isHole) {
            this.fillColor = null;
            if (this.strokeColor != null) {
                this.strokeColor = this.strokeColor.darker();
            }
        } else if (this.index > 0 && this.strokeColor != null) {
            this.strokeColor = this.adjustColorForSubPath(this.strokeColor, this.index);
        }
    }

    private Color adjustColorForSubPath(Color baseColor, int subPathIndex) {
        if (baseColor == null) {
            return null;
        }
        float[] hsb = Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), null);
        float brightnessFactor = 1.0f - (float)subPathIndex * 0.15f;
        hsb[2] = Math.max(0.2f, hsb[2] * brightnessFactor);
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public boolean isHole() {
        return this.isHole;
    }

    public Path2D.Double getPath2D() {
        return this.path2D;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public int getIndex() {
        return this.index;
    }

    public Element getOriginalElement() {
        return this.originalElement;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

