/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.svg;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.svg.SVGUtils;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.ParseException;

class CompositePathHandler
extends DefaultPathHandler {
    private final SVGUtils svgHandler;
    private final Path2D.Double compositePath;
    private static final Logger logger = Logger.getLogger(CompositePathHandler.class.getName());
    private float lastControlX = 0.0f;
    private float lastControlY = 0.0f;
    private boolean hasLastControlPoint = false;
    private String lastCommand = "";

    public CompositePathHandler(Path2D.Double compositePath, SVGUtils svghHandler) {
        this.svgHandler = svghHandler;
        this.compositePath = compositePath;
    }

    private void resetControlPoint() {
        this.hasLastControlPoint = false;
        this.lastCommand = "";
    }

    public void movetoAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: movetoAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        this.compositePath.moveTo(x, y);
        this.resetControlPoint();
    }

    public void movetoRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: movetoRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.moveTo(currentPoint.getX() + (double)x, currentPoint.getY() + (double)y);
        } else {
            this.compositePath.moveTo(x, y);
        }
        this.resetControlPoint();
    }

    public void linetoAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        this.compositePath.lineTo(x, y);
        this.resetControlPoint();
    }

    public void linetoRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.lineTo(currentPoint.getX() + (double)x, currentPoint.getY() + (double)y);
        } else {
            this.compositePath.lineTo(x, y);
        }
        this.resetControlPoint();
    }

    public void curvetoCubicAbs(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoCubicAbs({0}, {1}, {2}, {3}, {4}, {5})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3)});
        this.compositePath.curveTo(x1, y1, x2, y2, x3, y3);
        this.lastControlX = x2;
        this.lastControlY = y2;
        this.hasLastControlPoint = true;
        this.lastCommand = "C";
    }

    public void curvetoCubicRel(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoCubicRel({0}, {1}, {2}, {3}, {4}, {5})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            double baseX = currentPoint.getX();
            double baseY = currentPoint.getY();
            this.compositePath.curveTo(baseX + (double)x1, baseY + (double)y1, baseX + (double)x2, baseY + (double)y2, baseX + (double)x3, baseY + (double)y3);
            this.lastControlX = (float)(baseX + (double)x2);
            this.lastControlY = (float)(baseY + (double)y2);
        } else {
            this.compositePath.curveTo(x1, y1, x2, y2, x3, y3);
            this.lastControlX = x2;
            this.lastControlY = y2;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "C";
    }

    public void curvetoQuadraticAbs(float x1, float y1, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoQuadraticAbs({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x), Float.valueOf(y)});
        this.compositePath.quadTo(x1, y1, x, y);
        this.lastControlX = x1;
        this.lastControlY = y1;
        this.hasLastControlPoint = true;
        this.lastCommand = "Q";
    }

    public void curvetoQuadraticRel(float x1, float y1, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoQuadraticRel({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            double baseX = currentPoint.getX();
            double baseY = currentPoint.getY();
            this.compositePath.quadTo(baseX + (double)x1, baseY + (double)y1, baseX + (double)x, baseY + (double)y);
            this.lastControlX = (float)(baseX + (double)x1);
            this.lastControlY = (float)(baseY + (double)y1);
        } else {
            this.compositePath.quadTo(x1, y1, x, y);
            this.lastControlX = x1;
            this.lastControlY = y1;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "Q";
    }

    public void curvetoCubicSmoothAbs(float x2, float y2, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoCubicSmoothAbs({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            float y1;
            float x1;
            if (this.hasLastControlPoint && "C".equals(this.lastCommand)) {
                x1 = 2.0f * (float)currentPoint.getX() - this.lastControlX;
                y1 = 2.0f * (float)currentPoint.getY() - this.lastControlY;
            } else {
                x1 = (float)currentPoint.getX();
                y1 = (float)currentPoint.getY();
            }
            this.compositePath.curveTo(x1, y1, x2, y2, x, y);
            this.lastControlX = x2;
            this.lastControlY = y2;
        } else {
            this.compositePath.curveTo(x2, y2, x2, y2, x, y);
            this.lastControlX = x2;
            this.lastControlY = y2;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "C";
    }

    public void curvetoCubicSmoothRel(float x2, float y2, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoCubicSmoothRel({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            float y1;
            float x1;
            double baseX = currentPoint.getX();
            double baseY = currentPoint.getY();
            if (this.hasLastControlPoint && "C".equals(this.lastCommand)) {
                x1 = 2.0f * (float)baseX - this.lastControlX;
                y1 = 2.0f * (float)baseY - this.lastControlY;
            } else {
                x1 = (float)baseX;
                y1 = (float)baseY;
            }
            this.compositePath.curveTo(x1, y1, baseX + (double)x2, baseY + (double)y2, baseX + (double)x, baseY + (double)y);
            this.lastControlX = (float)(baseX + (double)x2);
            this.lastControlY = (float)(baseY + (double)y2);
        } else {
            this.compositePath.curveTo(x2, y2, x2, y2, x, y);
            this.lastControlX = x2;
            this.lastControlY = y2;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "C";
    }

    public void curvetoQuadraticSmoothAbs(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoQuadraticSmoothAbs({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            float y1;
            float x1;
            if (this.hasLastControlPoint && "Q".equals(this.lastCommand)) {
                x1 = 2.0f * (float)currentPoint.getX() - this.lastControlX;
                y1 = 2.0f * (float)currentPoint.getY() - this.lastControlY;
            } else {
                x1 = (float)currentPoint.getX();
                y1 = (float)currentPoint.getY();
            }
            this.compositePath.quadTo(x1, y1, x, y);
            this.lastControlX = x1;
            this.lastControlY = y1;
        } else {
            this.compositePath.quadTo(x, y, x, y);
            this.lastControlX = x;
            this.lastControlY = y;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "Q";
    }

    public void curvetoQuadraticSmoothRel(float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: curvetoQuadraticSmoothRel({0}, {1})", new Object[]{Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            float y1;
            float x1;
            double baseX = currentPoint.getX();
            double baseY = currentPoint.getY();
            if (this.hasLastControlPoint && "Q".equals(this.lastCommand)) {
                x1 = 2.0f * (float)baseX - this.lastControlX;
                y1 = 2.0f * (float)baseY - this.lastControlY;
            } else {
                x1 = (float)baseX;
                y1 = (float)baseY;
            }
            this.compositePath.quadTo(x1, y1, baseX + (double)x, baseY + (double)y);
            this.lastControlX = x1;
            this.lastControlY = y1;
        } else {
            this.compositePath.quadTo(x, y, x, y);
            this.lastControlX = x;
            this.lastControlY = y;
        }
        this.hasLastControlPoint = true;
        this.lastCommand = "Q";
    }

    public void linetoHorizontalAbs(float x) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoHorizontalAbs({0})", new Object[]{Float.valueOf(x)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.lineTo(x, currentPoint.getY());
        } else {
            this.compositePath.lineTo(x, 0.0);
        }
        this.resetControlPoint();
    }

    public void linetoHorizontalRel(float x) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoHorizontalRel({0})", new Object[]{Float.valueOf(x)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.lineTo(currentPoint.getX() + (double)x, currentPoint.getY());
        } else {
            this.compositePath.lineTo(x, 0.0);
        }
        this.resetControlPoint();
    }

    public void linetoVerticalAbs(float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoVerticalAbs({0})", new Object[]{Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.lineTo(currentPoint.getX(), y);
        } else {
            this.compositePath.lineTo(0.0, y);
        }
        this.resetControlPoint();
    }

    public void linetoVerticalRel(float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: linetoVerticalRel({0})", new Object[]{Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.compositePath.lineTo(currentPoint.getX(), currentPoint.getY() + (double)y);
        } else {
            this.compositePath.lineTo(0.0, y);
        }
        this.resetControlPoint();
    }

    public void arcAbs(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: arcAbs({0}, {1}, {2}, {3}, {4}, {5}, {6})", new Object[]{Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(xAxisRotation), largeArcFlag, sweepFlag, Float.valueOf(x), Float.valueOf(y)});
        this.svgHandler.addArcToPath(this.compositePath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, true);
        this.resetControlPoint();
    }

    public void arcRel(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
        logger.log(Level.FINEST, "CompositePathHandler: arcRel({0}, {1}, {2}, {3}, {4}, {5}, {6})", new Object[]{Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(xAxisRotation), largeArcFlag, sweepFlag, Float.valueOf(x), Float.valueOf(y)});
        Point2D currentPoint = this.compositePath.getCurrentPoint();
        if (currentPoint != null) {
            this.svgHandler.addArcToPath(this.compositePath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, (float)(currentPoint.getX() + (double)x), (float)(currentPoint.getY() + (double)y), false);
        } else {
            this.svgHandler.addArcToPath(this.compositePath, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, false);
        }
        this.resetControlPoint();
    }

    public void closePath() throws ParseException {
        logger.finest("CompositePathHandler: closePath()");
        this.compositePath.closePath();
        this.resetControlPoint();
    }
}

