/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.serialise;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import net.perspective.draw.serialise.PathData;
import net.perspective.draw.serialise.PathFactory;

public class Path2DPersistenceDelegate
extends DefaultPersistenceDelegate {
    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        if (!(oldInstance instanceof Path2D.Double) || !(newInstance instanceof Path2D.Double)) {
            return false;
        }
        Path2D.Double oldPath = (Path2D.Double)oldInstance;
        Path2D.Double newPath = (Path2D.Double)newInstance;
        if (oldPath.getWindingRule() != newPath.getWindingRule()) {
            return false;
        }
        double[][] oldData = this.getPathData(oldPath);
        double[][] newData = this.getPathData(newPath);
        return Arrays.deepEquals((Object[])oldData, (Object[])newData);
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        Path2D.Double path = (Path2D.Double)oldInstance;
        return new Expression(path, PathFactory.class, "createPath", new Object[]{path.getWindingRule(), new PathData(this.getPathData(path))});
    }

    private double[][] getPathData(Path2D.Double path) {
        ArrayList<double[]> pathData = new ArrayList<double[]>();
        double[] coords = new double[6];
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    pathData.add(new double[]{0.0, coords[0], coords[1]});
                    break;
                }
                case 1: {
                    pathData.add(new double[]{1.0, coords[0], coords[1]});
                    break;
                }
                case 2: {
                    pathData.add(new double[]{2.0, coords[0], coords[1], coords[2], coords[3]});
                    break;
                }
                case 3: {
                    pathData.add(new double[]{3.0, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]});
                    break;
                }
                case 4: {
                    pathData.add(new double[]{4.0});
                }
            }
            iterator.next();
        }
        return (double[][])pathData.toArray(x$0 -> new double[x$0][]);
    }
}

