/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.network;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.logging.Logger;
import net.perspective.draw.DrawItemTransferable;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.network.Operation;

public class Request {
    private Operation op;
    private int index;
    private DrawItemTransferable drawitem;
    private DataFlavor drawItemFlavor;
    private final String mimeType = "application/x-java-serialized-object;class=net.perspective.draw.geom.DrawItem";
    private static final Logger logger = Logger.getLogger(Request.class.getName());

    public Request(Operation op, int index) {
        try {
            this.drawItemFlavor = new DataFlavor("application/x-java-serialized-object;class=net.perspective.draw.geom.DrawItem");
        }
        catch (ClassNotFoundException e) {
            logger.severe("mimeType failed in Packet serializer.");
        }
        this.op = op;
        this.index = index;
        this.drawitem = null;
    }

    public void setCommand(Operation op) {
        this.op = op;
    }

    public Operation getCommand() {
        return this.op;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDrawItem(DrawItem d) {
        this.drawitem = new DrawItemTransferable(d);
    }

    public DrawItem getDrawItem() {
        DrawItem item = null;
        if (this.hasDrawItemFlavor(this.drawitem.getTransferDataFlavors())) {
            try {
                Object object = this.drawitem.getTransferData(this.drawItemFlavor);
                if (object instanceof DrawItem) {
                    DrawItem drawItem;
                    item = drawItem = (DrawItem)object;
                    item.moveTo(0.0, 0.0);
                }
            }
            catch (UnsupportedFlavorException e) {
                logger.warning("importData: unsupported data flavor");
            }
        }
        return item;
    }

    protected boolean hasDrawItemFlavor(DataFlavor[] flavors) {
        if (this.drawItemFlavor == null) {
            return false;
        }
        for (DataFlavor f : flavors) {
            if (!this.drawItemFlavor.equals(f)) continue;
            return true;
        }
        return false;
    }
}

