/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.network;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import net.perspective.draw.CanvasView;
import net.perspective.draw.ImageItem;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.network.Synchroniser;

public final class NullSyncImpl
extends Synchroniser {
    private final List<Integer> deletions = new ArrayList<Integer>();
    private static final Logger logger = Logger.getLogger(NullSyncImpl.class.getName());

    public NullSyncImpl(CanvasView view) {
        super(view);
    }

    @Override
    public void register() {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void init() {
        this.view.setSelected(-1);
        this.view.setEditing(KeyboardHandlerType.MOVE);
        this.synchronise();
    }

    @Override
    public void synchronise() {
    }

    @Override
    public void update(Boolean sync) {
    }

    @Override
    public void clear() {
        this.expungePictures();
        this.reset();
    }

    private void reset() {
        this.view.setSelected(-1);
        this.view.setEditing(KeyboardHandlerType.MOVE);
        this.view.getDrawings().clear();
        this.view.getImageItems().clear();
    }

    @Override
    public void addTo(int index) {
        boolean okToAdd = true;
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        try {
            this.addPicture(item);
        }
        catch (NullPointerException e) {
            logger.warning("Image has been deleted.");
            drawings.remove(item);
            okToAdd = false;
        }
        this.expungePictures();
        if (okToAdd) {
            this.view.setSelected(-1);
            this.view.setNewItem(null);
        }
    }

    @Override
    public void add(int index) {
        this.view.setSelected(-1);
        this.view.setNewItem(null);
    }

    @Override
    public void copyTo(int index) {
        this.view.setNewItem(null);
    }

    @Override
    public void updateTo(int index) {
    }

    @Override
    public void deleteFrom(int index) {
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        this.checkPictures(item);
        this.view.setSelected(-1);
    }

    @Override
    public void delete(int index) {
        this.view.setSelected(-1);
    }

    @Override
    public void deleteAll() {
        this.view.setSelected(-1);
    }

    private void addPicture(DrawItem item) throws NullPointerException {
        List<ImageItem> pictures = this.view.getImageItems();
        DrawItem drawItem = item;
        Objects.requireNonNull(drawItem);
        DrawItem drawItem2 = drawItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Picture.class, Grouped.class}, (Object)drawItem2, n)) {
            case 0: {
                Picture picture = (Picture)drawItem2;
                int index = picture.getImageIndex();
                try {
                    ImageItem image = pictures.get(index);
                    int c = image.getReferenceCount();
                    int count = c > 0 ? image.getReferenceCount() + 1 : 1;
                    image.setReferenceCount(count);
                    pictures.set(index, image);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warning("Image not available.");
                }
                break;
            }
            case 1: {
                Grouped grouped = (Grouped)drawItem2;
                for (DrawItem shape : grouped.getDrawItems()) {
                    this.addPicture(shape);
                }
                break;
            }
        }
    }

    private void checkPictures(DrawItem item) {
        List<ImageItem> pictures = this.view.getImageItems();
        DrawItem drawItem = item;
        Objects.requireNonNull(drawItem);
        DrawItem drawItem2 = drawItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Picture.class, Grouped.class}, (Object)drawItem2, n)) {
            case 0: {
                Picture picture = (Picture)drawItem2;
                try {
                    int index = picture.getImageIndex();
                    ImageItem image = pictures.get(index);
                    int count = image.getReferenceCount() - 1;
                    image.setReferenceCount(count);
                    pictures.set(index, image);
                    if (count >= 1) break;
                    this.deletions.add(index);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warning("Image not available.");
                }
                break;
            }
            case 1: {
                Grouped grouped = (Grouped)drawItem2;
                for (DrawItem shape : grouped.getDrawItems()) {
                    this.checkPictures(shape);
                }
                break;
            }
        }
    }

    @Override
    public void expungePictures() {
        List<ImageItem> pictures = this.view.getImageItems();
        for (Integer picture : this.deletions) {
            int count = pictures.get(picture).getReferenceCount();
            if (count >= 1) continue;
            pictures.get(picture).setImage(null);
        }
        this.deletions.clear();
    }
}

