/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.network;

import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.perspective.draw.CanvasView;
import net.perspective.draw.ImageItem;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.network.Operation;
import net.perspective.draw.network.Request;
import net.perspective.draw.network.Requests;
import net.perspective.draw.network.Synchroniser;

public final class ModelSyncImpl
extends Synchroniser {
    private final Requests requests = new Requests();
    private final List<Integer> deletions = new ArrayList<Integer>();
    private String token;
    private static final Logger logger = Logger.getLogger(ModelSyncImpl.class.getName());

    public ModelSyncImpl(CanvasView view) {
        super(view);
    }

    @Override
    public void register() {
        this.endpoint.addPropertyChangeListener("changed", this.view);
        this.endpoint.connect();
        this.token = this.endpoint.getInitialToken();
        logger.info("Connected to Endpoint.");
    }

    @Override
    public void disconnect() {
        this.endpoint.removePropertyChangeListener("changed", this.view);
        this.endpoint.disconnect();
        logger.info("Disconnected from Endpoint.");
    }

    @Override
    public void init() {
        this.synchronise();
    }

    @Override
    public void synchronise() {
        this.reset();
        this.expungePictures();
        this.readRequests(this.endpoint.getRequests(this.endpoint.getInitialToken()));
        this.endpoint.setChanged(false);
    }

    @Override
    public void update(Boolean sync) {
        Requests reqsA = this.endpoint.getRequests(this.token);
        logger.log(Level.FINEST, "get requests #1 with token {0}", this.token);
        try {
            SwingUtilities.invokeAndWait(() -> this.readRequests(reqsA));
        }
        catch (InterruptedException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (!this.requests.getRequests().isEmpty()) {
            logger.log(Level.FINER, "put requests with token {0}", this.token);
            this.endpoint.setObsCount();
            this.token = this.endpoint.readRequests(this.requests).getToken();
        }
        Requests reqsB = this.endpoint.getRequests(this.token);
        logger.log(Level.FINEST, "get request #2 with token {0}", reqsB.getToken());
        SwingUtilities.invokeLater(() -> {
            this.readRequests(reqsB);
            if (sync.booleanValue()) {
                this.expungePictures();
                this.view.getImageItems().clear();
            }
            this.requests.getRequests().clear();
        });
    }

    private void readRequests(Requests reqs) {
        boolean added = false;
        this.token = reqs.getToken();
        reqs = this.filterRequest(reqs);
        for (Request p : reqs.getRequests()) {
            switch (p.getCommand()) {
                case CREATE: {
                    this.view.addItem(p.getIndex(), p.getDrawItem());
                    break;
                }
                case UPDATE: {
                    this.view.replaceItem(p.getIndex(), p.getDrawItem());
                    break;
                }
                case DELETE: {
                    DrawItem deleted = this.view.deleteItem(p.getIndex());
                    if (deleted == null) break;
                    this.removePicture(deleted);
                    break;
                }
            }
            added = true;
        }
        if (added) {
            this.view.removeItems();
            this.view.callRepaint();
        }
    }

    private void addCreateRequest(int index, DrawItem item) {
        Request p = new Request(Operation.CREATE, index);
        p.setDrawItem(item);
        this.requests.getRequests().add(p);
        this.requests.setToken(this.token);
    }

    private void addUpdateRequest(int index, DrawItem item) {
        Request p = new Request(Operation.UPDATE, index);
        p.setDrawItem(item);
        this.requests.getRequests().add(p);
        this.requests.setToken(this.token);
    }

    private void addDeleteRequest(int index) {
        Request p = new Request(Operation.DELETE, index);
        this.requests.getRequests().add(p);
        this.requests.setToken(this.token);
    }

    private Requests filterRequest(Requests reqs) {
        if (this.requests.getRequests().isEmpty()) {
            return reqs;
        }
        Requests p = new Requests();
        for (Request request : reqs.getRequests()) {
            if (!this.requestIn(request.getIndex())) continue;
            p.getRequests().add(request);
        }
        for (Request request : p.getRequests()) {
            reqs.getRequests().remove(request);
        }
        return reqs;
    }

    private boolean requestIn(int index) {
        boolean in = false;
        for (Request request : this.requests.getRequests()) {
            if (request.getIndex() != index) continue;
            in = true;
        }
        return in;
    }

    @Override
    public void clear() {
        this.view.getDrawings().clear();
        this.view.getImageItems().clear();
        this.reset();
    }

    private void reset() {
        this.view.setSelected(-1);
        this.view.setEditing(KeyboardHandlerType.MOVE);
    }

    @Override
    public void addTo(int index) {
        boolean okToAdd = true;
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        try {
            this.addPicture(item);
        }
        catch (NullPointerException e) {
            logger.warning("Image has been deleted.");
            drawings.remove(item);
            okToAdd = false;
        }
        this.expungePictures();
        if (okToAdd) {
            this.addCreateRequest(index, item);
            this.view.setSelected(-1);
            this.view.setNewItem(null);
            this.endpoint.setChanged(false);
        }
    }

    @Override
    public void add(int index) {
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        this.addCreateRequest(index, item);
        this.view.setSelected(-1);
        this.view.setNewItem(null);
        this.endpoint.setChanged(false);
    }

    @Override
    public void copyTo(int index) {
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        this.addCreateRequest(index, item);
        this.view.setNewItem(null);
        this.endpoint.setChanged(false);
    }

    @Override
    public void updateTo(int index) {
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        this.addUpdateRequest(index, item);
        this.endpoint.setChanged(false);
    }

    @Override
    public void deleteFrom(int index) {
        List<DrawItem> drawings = this.view.getDrawings();
        DrawItem item = drawings.get(index);
        this.checkPictures(item);
        this.addDeleteRequest(index);
        this.view.setSelected(-1);
        this.endpoint.setChanged(false);
    }

    @Override
    public void delete(int index) {
        this.addDeleteRequest(index);
        this.view.setSelected(-1);
        this.endpoint.setChanged(false);
    }

    @Override
    public void deleteAll() {
        for (int index = this.view.getDrawings().size() - 1; index >= 0; --index) {
            this.addDeleteRequest(index);
        }
        this.view.setSelected(-1);
        this.endpoint.setChanged(true);
    }

    private void addPicture(DrawItem item) throws NullPointerException {
        List<ImageItem> pictures = this.view.getImageItems();
        DrawItem drawItem = item;
        Objects.requireNonNull(drawItem);
        DrawItem drawItem2 = drawItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Picture.class, Grouped.class}, (Object)drawItem2, n)) {
            case 0: {
                Picture picture = (Picture)drawItem2;
                int index = picture.getImageIndex();
                try {
                    ImageItem image = pictures.get(index);
                    int c = image.getReferenceCount();
                    int count = c > 0 ? image.getReferenceCount() + 1 : 1;
                    image.setReferenceCount(count);
                    pictures.set(index, image);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warning("Image not available.");
                }
                break;
            }
            case 1: {
                Grouped grouped = (Grouped)drawItem2;
                for (DrawItem shape : grouped.getDrawItems()) {
                    this.addPicture(shape);
                }
                break;
            }
        }
    }

    private void removePicture(DrawItem item) {
        List<ImageItem> pictures = this.view.getImageItems();
        DrawItem drawItem = item;
        Objects.requireNonNull(drawItem);
        DrawItem drawItem2 = drawItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Picture.class, Grouped.class}, (Object)drawItem2, n)) {
            case 0: {
                Picture picture = (Picture)drawItem2;
                int index = picture.getImageIndex();
                int count = pictures.get(index).getReferenceCount();
                if (count >= 1) break;
                pictures.get(index).setImage(null);
                break;
            }
            case 1: {
                Grouped grouped = (Grouped)drawItem2;
                for (DrawItem shape : grouped.getDrawItems()) {
                    this.removePicture(shape);
                }
                break;
            }
        }
    }

    private void checkPictures(DrawItem item) {
        List<ImageItem> pictures = this.view.getImageItems();
        DrawItem drawItem = item;
        Objects.requireNonNull(drawItem);
        DrawItem drawItem2 = drawItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Picture.class, Grouped.class}, (Object)drawItem2, n)) {
            case 0: {
                Picture picture = (Picture)drawItem2;
                try {
                    int index = picture.getImageIndex();
                    ImageItem image = pictures.get(index);
                    int count = image.getReferenceCount() - 1;
                    image.setReferenceCount(count);
                    pictures.set(index, image);
                    if (count >= 1) break;
                    this.deletions.add(index);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warning("Image not available.");
                }
                break;
            }
            case 1: {
                Grouped grouped = (Grouped)drawItem2;
                for (DrawItem shape : grouped.getDrawItems()) {
                    this.checkPictures(shape);
                }
                break;
            }
        }
    }

    @Override
    public void expungePictures() {
        List<ImageItem> pictures = this.view.getImageItems();
        for (Integer picture : this.deletions) {
            int count = pictures.get(picture).getReferenceCount();
            if (count >= 1) continue;
            pictures.get(picture).setImage(null);
        }
        this.deletions.clear();
    }
}

