/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.network;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.Instant;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.network.Requests;

public abstract class Endpoint {
    protected int observerCount;
    private boolean changed;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(property, listener);
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged(boolean newValue) {
        this.changed = newValue;
        this.pcs.firePropertyChange("changed", !newValue, newValue);
    }

    public void setObsCount() {
        this.observerCount = 2 * (this.pcs.getPropertyChangeListeners().length - 1);
    }

    protected int getObsCount() {
        return this.observerCount;
    }

    protected void decrementObsCount() {
        --this.observerCount;
    }

    public abstract void connect();

    public abstract void disconnect();

    public abstract Requests readRequests(Requests var1);

    public abstract Requests getRequests(String var1);

    public abstract void addItem(int var1, DrawItem var2);

    public abstract void replaceItem(int var1, DrawItem var2);

    public abstract void deleteItem(int var1);

    public abstract Instant getTimestamp();

    public abstract String getInitialToken();
}

