/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.network;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.network.DocItem;
import net.perspective.draw.network.Endpoint;
import net.perspective.draw.network.Operation;
import net.perspective.draw.network.Request;
import net.perspective.draw.network.Requests;
import net.perspective.draw.util.NanoClock;
import org.apache.commons.codec.binary.Base64;

public class Document
extends Endpoint {
    private final List<DocItem> items = new ArrayList<DocItem>();
    private final List<DocItem> removed = new ArrayList<DocItem>();
    private final Instant initial = Instant.now();
    private Instant timestamp = Instant.now();
    private final Clock clock = new NanoClock();
    private final MathContext mathContext = new MathContext(3, RoundingMode.HALF_UP);
    private static final Logger logger = Logger.getLogger(Document.class.getName());

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public Requests readRequests(Requests requests) {
        int deleteCount = 0;
        for (Request p : requests.getRequests()) {
            switch (p.getCommand()) {
                case CREATE: {
                    this.addItem(p.getIndex(), p.getDrawItem());
                    break;
                }
                case READ: 
                case UPDATE: {
                    this.replaceItem(p.getIndex(), p.getDrawItem());
                    break;
                }
                case DELETE: {
                    this.deleteItem(p.getIndex());
                    ++deleteCount;
                    break;
                }
            }
        }
        Requests req = new Requests();
        req.setDc(deleteCount);
        req.setToken(this.getTimeToken());
        return req;
    }

    @Override
    public Requests getRequests(String token) {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        Requests requests = new Requests();
        Instant tm_stamp = this.decodeToken(token);
        Instant startTime = Instant.now(this.clock);
        this.decrementObsCount();
        for (DocItem item : this.items) {
            Instant stamp = item.getTimestamp();
            if (item.getOp().equals((Object)Operation.DELETE)) {
                if (stamp.isBefore(tm_stamp)) {
                    selection.add(this.items.indexOf(item));
                }
                this.removed.add(item);
                continue;
            }
            if (stamp.isAfter(tm_stamp)) {
                switch (item.getOp()) {
                    case CREATE: {
                        Request p = new Request(Operation.CREATE, this.items.indexOf(item));
                        p.setDrawItem(item.getItem());
                        requests.add(p);
                        break;
                    }
                    default: {
                        Request p = new Request(Operation.UPDATE, this.items.indexOf(item));
                        p.setDrawItem(item.getItem());
                        requests.add(p);
                    }
                }
            }
            if (this.getObsCount() >= 1 || !item.getOp().equals((Object)Operation.CREATE)) continue;
            item.setOp(Operation.UPDATE);
        }
        Collections.sort(selection);
        for (Integer index : selection) {
            Request request = new Request(Operation.DELETE, index);
            requests.prepend(request);
        }
        if (this.getObsCount() < 1) {
            ListIterator<DocItem> iterator = this.removed.listIterator(this.removed.size());
            while (iterator.hasPrevious()) {
                DocItem item;
                item = iterator.previous();
                logger.log(Level.FINER, "Remove queued item at index {0}", this.items.indexOf(item));
                this.items.remove(item);
            }
            this.removed.clear();
        }
        requests.setToken(this.getTimeToken());
        Instant endTime = Instant.now(this.clock);
        String duration = String.format(Locale.UK, "%,.0f", BigDecimal.valueOf(Duration.between(startTime, endTime).toNanos()).round(this.mathContext));
        logger.log(Level.FINEST, "GET elapsed time: {0}ns", duration);
        return requests;
    }

    @Override
    public void addItem(int index, DrawItem d) {
        this.timestamp = Instant.now();
        DocItem item = new DocItem(this.timestamp, Operation.CREATE, d);
        if (index >= this.items.size()) {
            this.items.add(item);
            logger.log(Level.INFO, "Added item at Index: {0}", this.items.indexOf(item));
        } else {
            this.items.add(index, item);
            logger.log(Level.INFO, "Inserted item at Index: {0}", index);
        }
    }

    @Override
    public void replaceItem(int index, DrawItem d) {
        this.timestamp = Instant.now();
        DocItem item = new DocItem(this.timestamp, Operation.UPDATE, d);
        if (index >= this.items.size()) {
            this.items.add(item);
            logger.log(Level.INFO, "Inserted item at Index: {0}", this.items.indexOf(item));
        } else {
            this.items.set(index, item);
            logger.log(Level.INFO, "Replaced item at Index: {0}", index);
        }
    }

    @Override
    public void deleteItem(int index) {
        this.timestamp = Instant.now();
        try {
            this.items.get(index).setOp(Operation.DELETE);
            this.items.get(index).setTimestamp(this.timestamp);
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "Delete: {0}", e.getMessage());
        }
        logger.log(Level.INFO, "Deleted item at Index: {0}", index);
    }

    @Override
    public Instant getTimestamp() {
        return Instant.now();
    }

    @Override
    public String getInitialToken() {
        return this.getToken(this.initial);
    }

    private String getTimeToken() {
        this.timestamp = Instant.now();
        return this.getToken(this.timestamp);
    }

    private String getToken(Instant d) {
        String token = "1:" + d.toEpochMilli();
        return Base64.encodeBase64String((byte[])token.getBytes());
    }

    private Instant decodeToken(String token) {
        Instant d = Instant.now();
        try {
            byte[] b = Base64.decodeBase64((String)token);
            String t = new String(b, "UTF-8");
            String[] result = t.split(":");
            d = Instant.ofEpochMilli(Long.parseLong(result[1]));
        }
        catch (UnsupportedEncodingException e) {
            logger.severe(e.getMessage());
        }
        return d;
    }
}

