/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.maps;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.maps.MapService;
import net.perspective.draw.maps.MappingService;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public final class Mapping
implements MappingService,
TileLoaderListener {
    private DrawingCanvas panel;
    private StreetMap map;
    private double width;
    private double height;
    private List<MapRectangle> mapRectangleList;
    private TileSource tileSource;
    private TileController tileController;
    private TileCache tileCache;
    private boolean mapRectanglesVisible;
    private boolean tileGridVisible;
    Point center;
    int zoom;
    private static Mapping instance = null;
    static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 2;
    private Image attrImage;
    private String attrTermsUrl;
    public static final Font ATTR_FONT = OsmMercator.isRetina() ? new Font("Arial", 0, 20) : new Font("Arial", 0, 10);
    public static final Font ATTR_LINK_FONT;

    @Override
    public void connect(DrawingCanvas panel, StreetMap map) {
        this.tileSource = this.getMapService(panel.getMapSource());
        if (this.tileCache == null) {
            this.tileCache = new MemoryTileCache();
        }
        this.tileController = new TileController(this.tileSource, this.tileCache, this);
        this.mapRectangleList = new LinkedList<MapRectangle>();
        this.mapRectanglesVisible = true;
        this.tileGridVisible = false;
        this.panel = panel;
        this.map = map;
        boolean requireAttr = this.tileSource.requiresAttribution();
        if (requireAttr) {
            this.attrImage = this.tileSource.getAttributionImage();
            this.attrTermsUrl = this.tileSource.getTermsOfUseURL();
        } else {
            this.attrImage = null;
            this.attrTermsUrl = null;
        }
        panel.getMapController().initializeZoomSlider(map);
        this.setDisplayPosition(new Coordinate(map.getLatitude(), map.getLongitude()), map.getZoom());
    }

    @Override
    public void refresh() {
        int index = this.map.getImageIndex();
        BufferedImage image = this.panel.getMapController().getImage(index);
        if (image == null) {
            image = this.panel.getMapController().createCompatibleImage((int)this.map.getEnd().getX(), (int)this.map.getEnd().getY());
        }
        this.paintImage(image);
        this.panel.getView().replaceImage(index, image);
        ICoordinate coord = this.getPosition();
        this.map.setLatitude(coord.getLat());
        this.map.setLongitude(coord.getLon());
        this.map.setZoom(this.zoom);
        this.panel.repaint();
    }

    public void refresh(StreetMap map) {
        int index = map.getImageIndex();
        BufferedImage image = this.panel.getMapController().createCompatibleImage((int)map.getEnd().getX(), (int)map.getEnd().getY());
        this.paintImage(image);
        this.panel.getView().replaceImage(index, image);
        ICoordinate coord = this.getPosition();
        map.setLatitude(coord.getLat());
        map.setLongitude(coord.getLon());
        map.setZoom(this.zoom);
        this.panel.repaint();
    }

    @Override
    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public TileSource getMapService(MapService service) {
        return switch (service) {
            case MapService.STREETMAP -> new OsmTileSource.Mapnik();
            case MapService.CYCLEMAP -> new OsmTileSource.CycleMap();
            case MapService.TRANSPORT -> new OsmTileSource.TransportMap();
            case MapService.LANDSCAPE -> new OsmTileSource.LandscapeMap();
            case MapService.OUTDOORS -> new OsmTileSource.OutdoorsMap();
            case MapService.BING -> new BingTileSource();
            case MapService.AERIAL -> new BingAerialTileSource();
            default -> new OsmTileSource.Mapnik();
        };
    }

    @Override
    public void setTileSource(TileSource tileSource) {
        boolean requireAttr;
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.panel.getMapController().setSliderRange(2, tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        if (requireAttr = tileSource.requiresAttribution()) {
            this.attrImage = tileSource.getAttributionImage();
            this.attrTermsUrl = tileSource.getTermsOfUseURL();
        } else {
            this.attrImage = null;
            this.attrTermsUrl = null;
        }
        this.refresh();
    }

    public BufferedImage paintImage(BufferedImage img) {
        boolean start_top;
        Graphics2D g = img.createGraphics();
        int iMove = 0;
        int tilesize = this.tileSource.getTileSize();
        int tilex = this.center.x / tilesize;
        int tiley = this.center.y / tilesize;
        int off_x = this.center.x % tilesize;
        int off_y = this.center.y % tilesize;
        int w2 = (int)this.width / 2;
        int h2 = (int)this.height / 2;
        int posx = w2 - off_x;
        int posy = h2 - off_y;
        int diff_left = off_x;
        int diff_right = tilesize - off_x;
        int diff_top = off_y;
        int diff_bottom = tilesize - off_y;
        boolean start_left = diff_left < diff_right;
        boolean bl = start_top = diff_top < diff_bottom;
        iMove = start_top ? (start_left ? 2 : 3) : (start_left ? 1 : 0);
        int x_min = -tilesize;
        int y_min = -tilesize;
        int x_max = (int)this.width;
        int y_max = (int)this.height;
        boolean painted = true;
        int x = 0;
        while (painted) {
            painted = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    Tile tile;
                    if (x_min <= posx && posx <= x_max && y_min <= posy && posy <= y_max && (tile = this.tileController.getTile(tilex, tiley, this.zoom)) != null) {
                        painted = true;
                        tile.paint(g, posx, posy, tilesize, tilesize);
                        if (this.tileGridVisible) {
                            g.drawRect(posx, posy, tilesize, tilesize);
                        }
                    }
                    Point p = move[iMove];
                    posx += p.x * tilesize;
                    posy += p.y * tilesize;
                    tilex += p.x;
                    tiley += p.y;
                }
                iMove = (iMove + 1) % move.length;
            }
        }
        int mapSize = tilesize << this.zoom;
        g.drawRect(w2 - this.center.x, h2 - this.center.y, mapSize, mapSize);
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            for (MapRectangle rectangle : this.mapRectangleList) {
                Coordinate topLeft = rectangle.getTopLeft();
                Coordinate bottomRight = rectangle.getBottomRight();
                if (topLeft == null || bottomRight == null) continue;
                Point pTopLeft = this.getMapPosition(topLeft.getLat(), topLeft.getLon(), false);
                Point pBottomRight = this.getMapPosition(bottomRight.getLat(), bottomRight.getLon(), false);
                if (pTopLeft == null || pBottomRight == null) continue;
                rectangle.paint(g, pTopLeft, pBottomRight);
            }
        }
        this.paintAttribution(g);
        g.dispose();
        return img;
    }

    public void setDisplayPosition(ICoordinate to, int zoom) {
        this.setDisplayPosition(new Point((int)this.width / 2, (int)this.height / 2), to, zoom);
    }

    public void setDisplayPosition(Point mapPoint, ICoordinate to, int zoom) {
        Point p = this.tileSource.latLonToXY(to, zoom);
        this.setDisplayPosition(mapPoint, p.x, p.y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point((int)this.width / 2, (int)this.height / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < 2) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + (int)this.width / 2;
        p.y = y - mapPoint.y + (int)this.height / 2;
        this.center = p;
        this.panel.setIgnoreRepaint(true);
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.panel.getMapController().zoomChanged(zoom);
            }
            if (this.panel.getMapController().getSlider() != zoom) {
                this.panel.getMapController().setSlider(zoom);
            }
        }
        finally {
            this.panel.setIgnoreRepaint(false);
            this.refresh();
        }
    }

    public ICoordinate getPosition() {
        return this.tileSource.xyToLatLon(this.center, this.zoom);
    }

    public ICoordinate getPosition(Point mapPoint) {
        return this.getPosition(mapPoint.x, mapPoint.y);
    }

    public ICoordinate getPosition(int mapPointX, int mapPointY) {
        int x = this.center.x + mapPointX - (int)Math.round(this.width / 2.0);
        int y = this.center.y + mapPointY - (int)Math.round(this.height / 2.0);
        return this.tileSource.xyToLatLon(x, y, this.zoom);
    }

    public Point getMapPosition(double lat, double lon, boolean checkOutside) {
        Point p = this.tileSource.latLonToXY(lat, lon, this.zoom);
        p.translate(-(this.center.x - (int)this.width / 2), -(this.center.y - (int)this.height / 2));
        if (checkOutside && (p.x < 0 || p.y < 0 || p.x > (int)this.width || p.y > (int)this.height)) {
            return null;
        }
        return p;
    }

    public Point getMapPosition(double lat, double lon) {
        return this.getMapPosition(lat, lon, true);
    }

    public Integer getLatOffset(double lat, double lon, double offset, boolean checkOutside) {
        Point p = this.tileSource.latLonToXY(lat + offset, lon, this.zoom);
        int y = p.y - (this.center.y - (int)this.height / 2);
        if (checkOutside && (y < 0 || y > (int)this.height)) {
            return null;
        }
        return y;
    }

    public Integer getRadius(MapMarker marker, Point p) {
        if (marker.getMarkerStyle() == MapMarker.STYLE.FIXED) {
            return (int)marker.getRadius();
        }
        if (p != null) {
            Integer radius = this.getLatOffset(marker.getLat(), marker.getLon(), marker.getRadius(), false);
            radius = radius == null ? null : Integer.valueOf(p.y - radius);
            return radius;
        }
        return null;
    }

    public Point getMapPosition(Coordinate coord) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon());
        }
        return null;
    }

    public Point getMapPosition(Coordinate coord, boolean checkOutside) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon(), checkOutside);
        }
        return null;
    }

    @Override
    public void moveMap(int x, int y) {
        this.center.x += x;
        this.center.y += y;
        this.refresh();
    }

    @Override
    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < this.tileController.getTileSource().getMinZoom() || zoom == this.zoom) {
            return;
        }
        ICoordinate zoomPos = this.getPosition(mapPoint);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPosition(mapPoint, zoomPos, zoom);
    }

    @Override
    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point((int)this.width / 2, (int)this.height / 2));
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    @Override
    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    @Override
    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point mapPoint) {
        this.setZoom(this.zoom - 1, mapPoint);
    }

    public int getMinZoom() {
        return 2;
    }

    public int getMaxZoom() {
        return this.tileController.getTileSource().getMaxZoom();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean mapRectanglesVisible) {
        this.mapRectanglesVisible = mapRectanglesVisible;
        this.refresh();
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean tileGridVisible) {
        this.tileGridVisible = tileGridVisible;
        this.refresh();
    }

    public void addMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.add(rectangle);
        this.refresh();
    }

    public void removeMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.remove(rectangle);
        this.refresh();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean success) {
        this.refresh();
    }

    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader loader) {
        this.tileController.setTileLoader(loader);
    }

    private void paintAttribution(Graphics g) {
        int x;
        if (!this.tileSource.requiresAttribution()) {
            return;
        }
        Font font = g.getFont();
        g.setFont(ATTR_LINK_FONT);
        Rectangle2D termsStringBounds = g.getFontMetrics().getStringBounds("Background Terms of Use", g);
        int textHeight = (int)termsStringBounds.getHeight() - 5;
        int termsTextY = (int)this.height - textHeight;
        if (this.attrTermsUrl != null) {
            x = 2;
            int y = (int)this.height - textHeight;
            g.setColor(Color.black);
            g.drawString("Background Terms of Use", x + 1, y + 1);
            g.setColor(Color.white);
            g.drawString("Background Terms of Use", x, y);
        }
        if (this.attrImage != null) {
            x = 2;
            int ht = this.attrImage.getHeight(null);
            int y = termsTextY - ht - textHeight - 5;
            g.drawImage(this.attrImage, x, y, null);
        }
        g.setFont(ATTR_FONT);
        ICoordinate topLeft = this.getPosition(0, 0);
        ICoordinate bottomRight = this.getPosition((int)this.width, (int)this.height);
        String attributionText = this.tileSource.getAttributionText(this.zoom, topLeft, bottomRight);
        if (attributionText != null) {
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(attributionText, g);
            int x2 = (int)this.width - (int)stringBounds.getWidth();
            int y = (int)this.height - textHeight;
            g.setColor(Color.black);
            g.drawString(attributionText, x2 + 1, y + 1);
            g.setColor(Color.white);
            g.drawString(attributionText, x2, y);
        }
        g.setFont(font);
    }

    public static Mapping getInstance() {
        if (instance == null) {
            instance = new Mapping();
        }
        return instance;
    }

    private Mapping() {
    }

    static {
        HashMap<TextAttribute, Integer> aUnderline = new HashMap<TextAttribute, Integer>();
        aUnderline.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(aUnderline);
    }
}

