/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.AttributedString;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.perspective.draw.geom.Text;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;

public class TextFormatter {
    private String text;
    private Document currentdom;
    private SAXBuilder builder;
    private int offset;
    private static final Logger logger = Logger.getLogger(TextFormatter.class.getName());

    public TextFormatter() {
        this.initbuilder();
        this.currentdom = new Document();
    }

    private void initbuilder() {
        this.builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        this.builder.setReuseParser(true);
        this.builder.setIgnoringBoundaryWhitespace(false);
        this.builder.setIgnoringElementContentWhitespace(false);
    }

    public void readTextItem(Text item) {
        String content = this.normalizeText(item.getText());
        StringReader r = new StringReader(content);
        try {
            this.currentdom = this.builder.build((Reader)r);
        }
        catch (JDOMException e) {
            logger.warning("Malformed input.");
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        this.text = this.getFlattenedText(this.currentdom.getContent());
    }

    private String normalizeText(String content) {
        Pattern parpattern = Pattern.compile("(<p>)+(.*)(</p>)+", 32);
        Matcher matcher = parpattern.matcher((CharSequence)content);
        if (!matcher.find()) {
            content = ((String)content).replaceAll("&", "&amp;");
            content = ((String)content).replaceAll("<", "&lt;");
            content = ((String)content).replaceAll(">", "&gt;");
            content = "<p>" + (String)content + "</p>";
        }
        return content;
    }

    private String getFlattenedText(List fragment) {
        Object cdata = "";
        for (Object o : fragment) {
            if (o instanceof org.jdom2.Text) {
                cdata = (String)cdata + ((org.jdom2.Text)o).getText();
                continue;
            }
            if (!(o instanceof Element)) continue;
            cdata = (String)cdata + this.getFlattenedText(((Element)o).getContent());
        }
        return cdata;
    }

    public AttributedString readFormattedText(Text item) {
        this.readTextItem(item);
        AttributedString as = new AttributedString(this.text);
        this.setFontAttributes(item, as);
        this.offset = 0;
        as = this.setFormattingAttributes(this.currentdom.getContent(), as);
        return as;
    }

    private void setFontAttributes(Text item, AttributedString as) {
        String font;
        switch (font = item.getFont()) {
            case "SansSerif": {
                as.addAttribute(TextAttribute.FAMILY, "Inter");
                break;
            }
            case "Monospaced": {
                as.addAttribute(TextAttribute.FAMILY, "Roboto Mono");
                break;
            }
            default: {
                as.addAttribute(TextAttribute.FAMILY, "Serif");
            }
        }
        as.addAttribute(TextAttribute.SIZE, item.getSize());
        as.addAttribute(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    }

    private AttributedString setFormattingAttributes(List fragment, AttributedString as) {
        for (Object element : fragment) {
            if (element instanceof org.jdom2.Text) {
                this.offset += ((org.jdom2.Text)element).getText().length();
                continue;
            }
            if (!(element instanceof Element) || this.getLocalOffset(((Element)element).getContent()) == 0) continue;
            if (((Element)element).getName().equalsIgnoreCase("b")) {
                as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, this.offset, this.offset + this.getLocalOffset(((Element)element).getContent()));
            } else if (((Element)element).getName().equalsIgnoreCase("i")) {
                as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, this.offset, this.offset + this.getLocalOffset(((Element)element).getContent()));
            } else if (((Element)element).getName().equalsIgnoreCase("u")) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, this.offset, this.offset + this.getLocalOffset(((Element)element).getContent()));
            }
            as = this.setFormattingAttributes(((Element)element).getContent(), as);
        }
        return as;
    }

    private int getLocalOffset(List fragment) {
        int localoffset = 0;
        for (Object o : fragment) {
            if (o instanceof org.jdom2.Text) {
                localoffset += ((org.jdom2.Text)o).getText().length();
                continue;
            }
            if (!(o instanceof Element)) continue;
            localoffset += this.getLocalOffset(((Element)o).getContent());
        }
        return localoffset;
    }
}

