/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.Transient;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.geom.AcceptIcon;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.TextFormatter;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.V2;
import org.jhotdraw.geom.DoubleStroke;

public class Text
implements DrawItem,
Serializable {
    private String text = "Please insert text";
    private String font;
    private int style;
    private int size;
    private Color color = null;
    private int transparency;
    private boolean isVertical;
    private double angle;
    private CanvasPoint start;
    private CanvasPoint end;
    private static final HashMap<TextAttribute, Object> map = new HashMap();
    private static final long serialVersionUID = 1L;

    public Text() {
        this(0.0, 0.0);
    }

    public Text(double x, double y) {
        this.start = new CanvasPoint(x, y);
        this.transparency = 0;
        this.isVertical = false;
        this.angle = 0.0;
    }

    @Override
    public void setStart(double x, double y) {
        if (this.start == null) {
            this.start = new CanvasPoint();
        }
        this.start.setLocation(x, y);
    }

    @Deprecated
    public void setStart(CanvasPoint start) {
        this.start = start;
    }

    @Override
    public CanvasPoint getStart() {
        return this.start;
    }

    @Override
    public void setEnd(double x, double y) {
        if (this.end == null) {
            this.end = new CanvasPoint();
        }
        this.end.setLocation(x, y);
    }

    @Deprecated
    public void setEnd(CanvasPoint end) {
        this.end = end;
    }

    @Override
    public CanvasPoint getEnd() {
        return this.end;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public String getFont() {
        return this.font;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void updateProperties(DrawingCanvas canvas) {
        this.setColor(canvas.getStrokeColor());
        this.setTransparency(canvas.getTransparency());
        this.setFont(canvas.getFontFamily());
        Pattern parpattern = Pattern.compile("(<p>)+(.*)(</p>)+", 32);
        Matcher matcher = parpattern.matcher(this.text);
        if (matcher.find()) {
            this.setStyle(0);
        } else {
            this.setStyle(canvas.getFontStyle());
        }
        this.setSize(canvas.getFontSize());
        this.setDimensions(canvas);
    }

    public void setDimensions(DrawingCanvas canvas) {
        TextLayout layout = this.getLayout(canvas);
        this.end = new CanvasPoint(layout.getAdvance(), (double)layout.getAscent() + (double)layout.getDescent());
    }

    public TextLayout getLayout(DrawingCanvas canvas) {
        TextLayout layout;
        Graphics2D g2 = (Graphics2D)canvas.getGraphics();
        Pattern parpattern = Pattern.compile("(<p>)+(.*)(</p>)+", 32);
        Matcher matcher = parpattern.matcher(this.text);
        if (matcher.find()) {
            FontRenderContext context = g2.getFontRenderContext();
            TextFormatter formatter = new TextFormatter();
            AttributedString as = formatter.readFormattedText(this);
            layout = new TextLayout(as.getIterator(), context);
        } else {
            Font thisFont = switch (this.font) {
                case "SansSerif" -> new Font("Inter", this.getConvertedFontStyle(), this.size);
                case "Serif" -> new Font("Serif", this.getConvertedFontStyle(), this.size);
                case "Monospaced" -> new Font("Roboto Mono", this.getConvertedFontStyle(), this.size);
                default -> new Font(this.font, this.getConvertedFontStyle(), this.size);
            };
            thisFont = thisFont.deriveFont(map);
            Object context = g2.getFontRenderContext();
            layout = new TextLayout(this.text, thisFont, (FontRenderContext)context);
        }
        return layout;
    }

    private int getConvertedFontStyle() {
        int thisstyle = 0;
        if ((this.style & 1) == 1) {
            thisstyle |= 1;
        }
        if ((this.style & 2) == 2) {
            thisstyle |= 2;
        }
        if ((this.style & 4) == 4) {
            // empty if block
        }
        return thisstyle;
    }

    @Override
    public CanvasPoint[] getTop() {
        CanvasPoint s = new CanvasPoint(this.start.x, this.start.y);
        s = this.getTransform(s);
        return new CanvasPoint[]{s, s};
    }

    @Override
    public CanvasPoint[] getUp() {
        CanvasPoint up = new CanvasPoint(this.start.x + this.end.x, this.start.y);
        up = this.getTransform(up);
        return new CanvasPoint[]{up, up};
    }

    @Override
    public CanvasPoint[] getDown() {
        CanvasPoint down = new CanvasPoint(this.start.x, this.start.y + this.end.y);
        down = this.getTransform(down);
        return new CanvasPoint[]{down, down};
    }

    @Override
    public CanvasPoint[] getBottom() {
        CanvasPoint e = new CanvasPoint(this.start.x + this.end.x, this.start.y + this.end.y);
        e = this.getTransform(e);
        return new CanvasPoint[]{e, e};
    }

    private CanvasPoint getTransform(CanvasPoint point) {
        CanvasPoint centre = this.rotationCentre();
        point.translate(-centre.x, -centre.y);
        if (this.getAngle() != 0.0) {
            point.rotate(this.getAngle());
        }
        if (this.isVertical()) {
            point.rotate(-1.5707963267948966);
        }
        point.translate(centre.x, centre.y);
        return point;
    }

    private AffineTransform getTransform() {
        CanvasPoint centre = this.rotationCentre();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(centre.x, centre.y);
        if (this.getAngle() != 0.0) {
            transform.rotate(this.getAngle());
        }
        if (this.isVertical()) {
            transform.rotate(-1.5707963267948966);
        }
        return transform;
    }

    @Override
    public CanvasPoint rotationCentre() {
        return this.start;
    }

    @Override
    public Shape bounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.end.x, this.end.y);
        Area bounds = new Area(rect);
        AffineTransform transform = this.getTransform();
        bounds.transform(transform);
        return bounds;
    }

    public Shape getAcceptBounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, AcceptIcon.getOrigWidth(), AcceptIcon.getOrigHeight());
        Area bounds = new Area(rect);
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.end.x + AcceptIcon.ACCEPTICON.x, this.end.y + AcceptIcon.ACCEPTICON.y);
        bounds.transform(transform);
        transform = this.getTransform();
        bounds.transform(transform);
        return bounds;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.bounds().contains(x, y);
    }

    @Override
    public void moveTo(double xinc, double yinc) {
        this.start.translate(xinc, yinc);
    }

    @Override
    public void draw(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform rotation;
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = new AffineTransform();
        TextLayout layout = this.getLayout(canvas);
        g2.setPaint(this.getColor());
        CanvasPoint axis = this.rotationCentre();
        CanvasPoint offset = new CanvasPoint(0.0, this.end.y - (double)layout.getDescent());
        offset = V2.rot(offset.x, offset.y, this.getAngle());
        if (this.isVertical()) {
            offset = V2.rot(offset.x, offset.y, -1.5707963267948966);
            transform.setToTranslation(axis.x + offset.x, axis.y + offset.y);
            rotation = new AffineTransform();
            rotation.setToRotation(-1.5707963705062866);
            transform.concatenate(rotation);
        } else {
            transform.setToTranslation(axis.x + offset.x, axis.y + offset.y);
        }
        rotation = new AffineTransform();
        rotation.setToRotation((float)this.getAngle());
        transform.concatenate(rotation);
        g2.transform(transform);
        layout.draw(g2, 0.0f, 0.0f);
        g2.setTransform(defaultTransform);
    }

    @Override
    public void sketch(Graphics2D g2, DrawingCanvas canvas) {
    }

    @Override
    public void drawAnchors(Graphics2D g2, DrawingCanvas canvas) {
        float[] dashes = new float[]{1.0f, 2.0f};
        AffineTransform defaultTransform = g2.getTransform();
        g2.transform(this.getTransform());
        g2.setColor(canvas.getThemeFillColor());
        g2.setStroke(new DoubleStroke(3.0, 1.0, 2, 2, 10.0, dashes, 0.0f));
        g2.draw(new RoundRectangle2D.Double(-7.0, -7.0, this.end.x + 14.0, this.end.y + 14.0, 7.0, 7.0));
        AffineTransform transform = new AffineTransform();
        transform.translate(this.end.x + AcceptIcon.ACCEPTICON.x, this.end.y + AcceptIcon.ACCEPTICON.y);
        g2.transform(transform);
        AcceptIcon.paint(g2);
        g2.setTransform(defaultTransform);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    @Override
    public boolean isVertical() {
        return this.isVertical;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Deprecated
    public void setStartPoint(CanvasPoint start) {
        this.start = start;
    }

    @Deprecated
    @Transient
    public CanvasPoint getStartPoint() {
        return this.start;
    }

    @Deprecated
    public void setEndPoint(CanvasPoint end) {
        this.end = end;
    }

    @Deprecated
    @Transient
    public CanvasPoint getEndPoint() {
        return this.end;
    }

    static {
        map.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    }
}

