/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.util.CanvasPoint;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public class StreetMap
extends Picture {
    private double latitude;
    private double longitude;
    private int zoom;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(StreetMap.class.getName());

    public StreetMap() {
        this(0.0, 0.0);
    }

    public StreetMap(double x, double y) {
        super(x, y);
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void updateProperties(DrawingCanvas canvas) {
        this.setTransparency(canvas.getTransparency());
    }

    @Override
    public CanvasPoint[] getTop() {
        CanvasPoint s = new CanvasPoint(this.start.x, this.start.y);
        return new CanvasPoint[]{s, s};
    }

    @Override
    public CanvasPoint[] getUp() {
        CanvasPoint up = new CanvasPoint(this.start.x + this.end.x, this.start.y);
        return new CanvasPoint[]{up, up};
    }

    @Override
    public CanvasPoint[] getDown() {
        CanvasPoint down = new CanvasPoint(this.start.x, this.start.y + this.end.y);
        return new CanvasPoint[]{down, down};
    }

    @Override
    public CanvasPoint[] getBottom() {
        CanvasPoint e = new CanvasPoint(this.start.x + this.end.x, this.start.y + this.end.y);
        return new CanvasPoint[]{e, e};
    }

    @Override
    public Shape bounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.end.x, this.end.y);
        Area bounds = new Area(rect);
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.start.x, this.start.y);
        bounds.transform(transform);
        return bounds;
    }

    @Override
    public void draw(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform retina = new AffineTransform();
        if (OsmMercator.isRetina()) {
            retina.setToScale(0.5, 0.5);
        }
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.start.x, this.start.y);
        g2.transform(transform);
        try {
            BufferedImage img = canvas.getView().getImageItem(this.index).getImage();
            if (img == null) {
                throw new NullPointerException();
            }
            g2.drawImage(img, retina, null);
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.SEVERE, "Picture: Index {0} Out of Bounds.", this.index);
            g2.setTransform(defaultTransform);
            this.sketch(g2, canvas);
        }
        catch (NullPointerException e) {
            logger.warning("Picture: Image not found.");
            g2.setTransform(defaultTransform);
            this.sketch(g2, canvas);
        }
        g2.setTransform(defaultTransform);
    }

    @Override
    public void sketch(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.start.x, this.start.y);
        g2.transform(transform);
        g2.setColor(canvas.getThemeFillColor());
        g2.fill(new Rectangle2D.Double(0.0, 0.0, this.end.x, this.end.y));
        g2.setTransform(defaultTransform);
    }

    @Override
    public void drawAnchors(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.start.x, this.start.y);
        g2.transform(transform);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        super.anchor(g2, 0.0, 0.0, canvas);
        super.anchor(g2, this.end.x, 0.0, canvas);
        super.anchor(g2, 0.0, this.end.y, canvas);
        super.anchor(g2, this.end.x, this.end.y, canvas);
        g2.setTransform(defaultTransform);
    }
}

