/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.util.CanvasPoint;
import org.jhotdraw.geom.DoubleStroke;

public class Grouped
implements DrawItem,
Serializable {
    public List<DrawItem> shapes;
    private int transparency = 0;
    private boolean isVertical = false;
    private double angle = 0.0;
    private CanvasPoint start;
    private CanvasPoint end;
    private double scale = 1.0;
    private static final long serialVersionUID = 1L;

    public void setDrawItems(List<DrawItem> shapes) {
        this.shapes = shapes;
    }

    public List<DrawItem> getDrawItems() {
        return this.shapes;
    }

    public void addDrawItem(DrawItem shape) {
        if (this.shapes == null) {
            this.shapes = new ArrayList<DrawItem>();
        }
        this.shapes.add(shape);
        this.setBounds();
    }

    public void removeDrawItem(DrawItem shape) {
        if (this.shapes != null) {
            this.shapes.remove(shape);
            if (!this.shapes.isEmpty()) {
                this.setBounds();
            }
        }
    }

    private void setBounds() {
        ArrayList<CanvasPoint> points = new ArrayList<CanvasPoint>();
        for (DrawItem shape : this.shapes) {
            points.add(shape.getTop()[0]);
            points.add(shape.getBottom()[0]);
            points.add(shape.getUp()[0]);
            points.add(shape.getDown()[0]);
        }
        try {
            CanvasPoint topleft = (CanvasPoint)((CanvasPoint)points.get(0)).clone();
            CanvasPoint bottomright = (CanvasPoint)((CanvasPoint)points.get(1)).clone();
            for (CanvasPoint point : points) {
                topleft.x = Math.min(point.x, topleft.x);
                topleft.y = Math.min(point.y, topleft.y);
                bottomright.x = Math.max(point.x, bottomright.x);
                bottomright.y = Math.max(point.y, bottomright.y);
            }
            this.start = new CanvasPoint(topleft.x, topleft.y);
            this.end = new CanvasPoint(bottomright.x, bottomright.y);
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Grouped.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setStart(double x, double y) {
        if (this.start == null) {
            this.start = new CanvasPoint();
        }
        this.start.setLocation(x, y);
    }

    @Deprecated
    public void setStart(CanvasPoint start) {
        this.start = start;
    }

    @Override
    public CanvasPoint getStart() {
        return this.start;
    }

    @Override
    public void setEnd(double x, double y) {
        if (this.end == null) {
            this.end = new CanvasPoint();
        }
        this.end.setLocation(x, y);
    }

    @Deprecated
    public void setEnd(CanvasPoint end) {
        this.end = end;
    }

    @Override
    public CanvasPoint getEnd() {
        return this.end;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void updateProperties(DrawingCanvas canvas) {
    }

    @Override
    public CanvasPoint[] getTop() {
        CanvasPoint[] p = this.getVertex(ContainsType.TL);
        CanvasPoint[] s = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return s;
    }

    @Override
    public CanvasPoint[] getUp() {
        CanvasPoint[] p = this.getVertex(ContainsType.TR);
        CanvasPoint[] up = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return up;
    }

    @Override
    public CanvasPoint[] getDown() {
        CanvasPoint[] p = this.getVertex(ContainsType.BL);
        CanvasPoint[] down = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return down;
    }

    @Override
    public CanvasPoint[] getBottom() {
        CanvasPoint[] p = this.getVertex(ContainsType.BR);
        CanvasPoint[] e = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return e;
    }

    private CanvasPoint getTransform(CanvasPoint point) {
        CanvasPoint centre = this.rotationCentre();
        point.translate(-centre.x, -centre.y);
        if (this.getAngle() != 0.0) {
            point.rotate(this.getAngle());
        }
        if (this.isVertical()) {
            point.rotate(-1.5707963267948966);
        }
        point.translate(centre.x, centre.y);
        return point;
    }

    private AffineTransform getTransform() {
        CanvasPoint centre = this.rotationCentre();
        AffineTransform transform = new AffineTransform();
        transform.setToRotation(this.getAngle() + (this.isVertical() ? -1.5707963267948966 : 0.0), centre.x, centre.y);
        return transform;
    }

    @Override
    public CanvasPoint rotationCentre() {
        return new CanvasPoint(this.scale * (this.end.x - this.start.x) / 2.0 + this.start.x, this.scale * (this.end.y - this.start.y) / 2.0 + this.start.y);
    }

    @Override
    public Shape bounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double(this.start.x, this.start.y, this.end.x - this.start.x, this.end.y - this.start.y);
        Area bounds = new Area(rect);
        AffineTransform transform = this.getTransform();
        transform.translate(this.start.x, this.start.y);
        transform.scale(this.scale, this.scale);
        transform.translate(-this.start.x, -this.start.y);
        bounds.transform(transform);
        return bounds;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.bounds().contains(x, y);
    }

    @Override
    public void moveTo(double xinc, double yinc) {
        this.shapes.stream().forEach(shape -> shape.moveTo(xinc, yinc));
        this.setBounds();
    }

    @Override
    public void draw(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = this.getTransform();
        transform.translate(this.start.x, this.start.y);
        transform.scale(this.scale, this.scale);
        transform.translate(-this.start.x, -this.start.y);
        g2.transform(transform);
        for (DrawItem shape : this.shapes) {
            shape.draw(g2, canvas);
        }
        g2.setTransform(defaultTransform);
    }

    @Override
    public void sketch(Graphics2D g2, DrawingCanvas canvas) {
    }

    @Override
    public void drawAnchors(Graphics2D g2, DrawingCanvas canvas) {
        float[] dashes = new float[]{1.0f, 2.0f};
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = this.getTransform();
        transform.translate(this.start.x, this.start.y);
        g2.transform(transform);
        g2.setStroke(new DoubleStroke(3.0, 1.0, 2, 2, 10.0, dashes, 0.0f));
        g2.setColor(canvas.getThemeFillColor());
        g2.draw(new RoundRectangle2D.Double(0.0, 0.0, this.scale * (this.end.x - this.start.x), this.scale * (this.end.y - this.start.y), 5.0, 5.0));
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        this.anchor(g2, 0.0, 0.0, canvas);
        this.anchor(g2, 0.0, this.scale * (this.end.y - this.start.y), canvas);
        this.anchor(g2, this.scale * (this.end.x - this.start.x), this.scale * (this.end.y - this.start.y), canvas);
        this.anchor(g2, this.scale * (this.end.x - this.start.x), 0.0, canvas);
        g2.setTransform(defaultTransform);
    }

    private void anchor(Graphics2D g2, double x, double y, DrawingCanvas canvas) {
        g2.setColor(canvas.getCanvasBackgroundColor());
        g2.fill(new Ellipse2D.Double(x - 4.0, y - 4.0, 8.0, 8.0));
        g2.setColor(canvas.getThemeAccentColor());
        g2.draw(new Ellipse2D.Double(x - 4.0, y - 4.0, 8.0, 8.0));
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    @Override
    public boolean isVertical() {
        return this.isVertical;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    public double sgnd_area() {
        CanvasPoint p1 = new CanvasPoint();
        CanvasPoint p2 = new CanvasPoint();
        CanvasPoint p3 = new CanvasPoint();
        if (this.scale < 0.0) {
            p1.setLocation(1.0, 1.0);
            p2.setLocation(1.0 + this.end.x - this.start.x, 1.0);
            p3.setLocation(1.0 + this.end.x - this.start.x, 1.0 + this.end.y - this.start.y);
        } else {
            p1.setLocation(1.0, 1.0);
            p2.setLocation(1.0, 1.0 + this.end.y - this.start.y);
            p3.setLocation(1.0 + this.end.x - this.start.x, 1.0 + this.end.y - this.start.y);
        }
        double _area = p1.x * p2.y - p2.x * p1.y + (p2.x * p3.y - p3.x * p2.y) + (p3.x * p1.y - p1.x * p3.y);
        return Math.signum(_area);
    }

    private CanvasPoint[] getVertex(ContainsType contains) {
        CanvasPoint[] canvasPointArray;
        double ey;
        double sy;
        double ex;
        double sx;
        double width = Math.abs(this.end.x - this.start.x);
        double height = Math.abs(this.end.y - this.start.y);
        double side = 0.25 * (width + height);
        CanvasPoint cxy = this.rotationCentre();
        CanvasPoint p1 = new CanvasPoint(this.start.x, this.start.y);
        CanvasPoint p2 = new CanvasPoint(this.start.x, this.start.y + this.scale * (this.end.y - this.start.y));
        CanvasPoint p3 = new CanvasPoint(this.start.x + this.scale * (this.end.x - this.start.x), this.start.y + this.scale * (this.end.y - this.start.y));
        CanvasPoint p4 = new CanvasPoint(this.start.x + this.scale * (this.end.x - this.start.x), this.start.y);
        if (p1.x < p3.x) {
            sx = cxy.x - side;
            ex = cxy.x + side;
        } else {
            sx = cxy.x + side;
            ex = cxy.x - side;
        }
        if (p1.y < p3.y) {
            sy = cxy.y - side;
            ey = cxy.y + side;
        } else {
            sy = cxy.y + side;
            ey = cxy.y - side;
        }
        switch (contains) {
            case TL: {
                CanvasPoint[] canvasPointArray2 = new CanvasPoint[2];
                canvasPointArray2[0] = p1;
                canvasPointArray = canvasPointArray2;
                canvasPointArray2[1] = new CanvasPoint(sx, sy);
                break;
            }
            case BL: {
                CanvasPoint[] canvasPointArray3 = new CanvasPoint[2];
                canvasPointArray3[0] = p2;
                canvasPointArray = canvasPointArray3;
                canvasPointArray3[1] = new CanvasPoint(sx, ey);
                break;
            }
            case BR: {
                CanvasPoint[] canvasPointArray4 = new CanvasPoint[2];
                canvasPointArray4[0] = p3;
                canvasPointArray = canvasPointArray4;
                canvasPointArray4[1] = new CanvasPoint(ex, ey);
                break;
            }
            case TR: {
                CanvasPoint[] canvasPointArray5 = new CanvasPoint[2];
                canvasPointArray5[0] = p4;
                canvasPointArray = canvasPointArray5;
                canvasPointArray5[1] = new CanvasPoint(ex, sy);
                break;
            }
            default: {
                CanvasPoint[] canvasPointArray6 = new CanvasPoint[2];
                canvasPointArray6[0] = p1;
                canvasPointArray = canvasPointArray6;
                canvasPointArray6[1] = new CanvasPoint(sx, sy);
            }
        }
        CanvasPoint[] p = canvasPointArray;
        return p;
    }

    public List<CanvasPoint[]> getVertices() {
        double ey;
        double sy;
        double ex;
        double sx;
        ArrayList<CanvasPoint[]> vert = new ArrayList<CanvasPoint[]>();
        ArrayList<CanvasPoint[]> vertices = new ArrayList<CanvasPoint[]>();
        double width = Math.abs(this.end.x - this.start.x);
        double height = Math.abs(this.end.y - this.start.y);
        double side = 0.25 * (width + height);
        CanvasPoint cxy = this.rotationCentre();
        CanvasPoint p1 = new CanvasPoint(this.start.x, this.start.y);
        CanvasPoint p2 = new CanvasPoint(this.start.x, this.start.y + this.scale * (this.end.y - this.start.y));
        CanvasPoint p3 = new CanvasPoint(this.start.x + this.scale * (this.end.x - this.start.x), this.start.y + this.scale * (this.end.y - this.start.y));
        CanvasPoint p4 = new CanvasPoint(this.start.x + this.scale * (this.end.x - this.start.x), this.start.y);
        if (p1.x < p3.x) {
            sx = cxy.x - side;
            ex = cxy.x + side;
        } else {
            sx = cxy.x + side;
            ex = cxy.x - side;
        }
        if (p1.y < p3.y) {
            sy = cxy.y - side;
            ey = cxy.y + side;
        } else {
            sy = cxy.y + side;
            ey = cxy.y - side;
        }
        vert.add(new CanvasPoint[]{p1, new CanvasPoint(sx, sy)});
        vert.add(new CanvasPoint[]{p2, new CanvasPoint(sx, ey)});
        vert.add(new CanvasPoint[]{p3, new CanvasPoint(ex, ey)});
        vert.add(new CanvasPoint[]{p4, new CanvasPoint(ex, sy)});
        for (CanvasPoint[] p : vert) {
            CanvasPoint[] point = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
            vertices.add(point);
        }
        return vertices;
    }

    @Deprecated
    public void setStartPoint(CanvasPoint start) {
        this.start = start;
    }

    @Deprecated
    @Transient
    public CanvasPoint getStartPoint() {
        return this.start;
    }

    @Deprecated
    public void setEndPoint(CanvasPoint end) {
        this.end = end;
    }

    @Deprecated
    @Transient
    public CanvasPoint getEndPoint() {
        return this.end;
    }
}

