/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.util.ArrayList;
import java.util.List;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.geom.PointFactory;
import net.perspective.draw.util.CanvasPoint;

public class FigurePointFactory
implements PointFactory {
    private List<CanvasPoint> pentagram = new ArrayList<CanvasPoint>();

    @Override
    public List<CanvasPoint> createPoints(DrawingType description, double ... coords) {
        double startX = 0.0;
        double startY = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        if (coords.length > 0) {
            startX = coords[0];
            startY = coords[1];
        }
        if (coords.length == 4) {
            endX = coords[2];
            endY = coords[3];
        }
        ArrayList<CanvasPoint> points = new ArrayList<CanvasPoint>();
        switch (description) {
            case POINT: {
                points.add(new CanvasPoint(startX, startY));
                points.add(new CanvasPoint(startX, startY));
                break;
            }
            case LINE: {
                points.add(new CanvasPoint(startX, startY));
                points.add(new CanvasPoint(endX, endY));
                break;
            }
            case HORIZONTAL: {
                points.add(new CanvasPoint(startX, startY));
                points.add(new CanvasPoint(endX, startY));
                break;
            }
            case VERTICAL: {
                points.add(new CanvasPoint(startX, startY));
                points.add(new CanvasPoint(startX, endY));
                break;
            }
            case CIRCLE: 
            case SQUARE: {
                double x = startX;
                double y = startY;
                double width = endX - startX;
                double height = endY - startY;
                double maxLength = Math.max(Math.abs(width), Math.abs(height));
                CanvasPoint p0 = new CanvasPoint(x, y);
                CanvasPoint p1 = new CanvasPoint(x, y + maxLength * Math.signum(height));
                CanvasPoint p2 = new CanvasPoint(x + maxLength * Math.signum(width), y + maxLength * Math.signum(height));
                CanvasPoint p3 = new CanvasPoint(x + maxLength * Math.signum(width), y);
                points.add(p0);
                points.add(p1);
                points.add(p2);
                points.add(p3);
                break;
            }
            case ELLIPSE: 
            case RECTANGLE: {
                CanvasPoint p0 = new CanvasPoint(startX, startY);
                CanvasPoint p1 = new CanvasPoint(startX, endY);
                CanvasPoint p2 = new CanvasPoint(endX, endY);
                CanvasPoint p3 = new CanvasPoint(endX, startY);
                points.add(p0);
                points.add(p1);
                points.add(p2);
                points.add(p3);
                break;
            }
            case TRIANGLE: {
                double width = endX - startX;
                double height = endY - startY;
                double maxLength = Math.max(Math.abs(width), Math.abs(height));
                CanvasPoint p0 = new CanvasPoint(startX + maxLength * Math.signum(width) / 2.0, startY);
                CanvasPoint p1 = new CanvasPoint(startX, startY + maxLength * Math.signum(height));
                CanvasPoint p2 = new CanvasPoint(startX + maxLength * Math.signum(width), startY + maxLength * Math.signum(height));
                points.add(p0);
                points.add(p1);
                points.add(p2);
                break;
            }
            case ISOSCELES: {
                double width = endX - startX;
                double height = endY - startY;
                CanvasPoint p0 = new CanvasPoint(startX + width / 2.0, startY);
                CanvasPoint p1 = new CanvasPoint(startX, startY + height);
                CanvasPoint p2 = new CanvasPoint(startX + width, startY + height);
                points.add(p0);
                points.add(p1);
                points.add(p2);
                break;
            }
            case HEXAGON: {
                double width = endX - startX;
                double height = endY - startY;
                CanvasPoint p0 = new CanvasPoint(startX + width / 4.0, startY);
                CanvasPoint p1 = new CanvasPoint(startX, startY + height / 2.0);
                CanvasPoint p2 = new CanvasPoint(startX + width / 4.0, endY);
                CanvasPoint p3 = new CanvasPoint(startX + 3.0 * width / 4.0, endY);
                CanvasPoint p4 = new CanvasPoint(endX, startY + height / 2.0);
                CanvasPoint p5 = new CanvasPoint(startX + 3.0 * width / 4.0, startY);
                points.add(p0);
                points.add(p1);
                points.add(p2);
                points.add(p3);
                points.add(p4);
                points.add(p5);
                break;
            }
            case ISOHEX: {
                double width = endX - startX;
                double height = endY - startY;
                double maxLength = Math.max(Math.abs(width), Math.abs(height));
                double w = maxLength * Math.signum(width);
                double h = maxLength * Math.sin(1.0471975511965976) * Math.signum(height);
                CanvasPoint p0 = new CanvasPoint(startX + w / 4.0, startY);
                CanvasPoint p1 = new CanvasPoint(startX, startY + h / 2.0);
                CanvasPoint p2 = new CanvasPoint(startX + w / 4.0, startY + h);
                CanvasPoint p3 = new CanvasPoint(startX + 3.0 * w / 4.0, startY + h);
                CanvasPoint p4 = new CanvasPoint(startX + w, startY + h / 2.0);
                CanvasPoint p5 = new CanvasPoint(startX + 3.0 * w / 4.0, startY);
                points.add(p0);
                points.add(p1);
                points.add(p2);
                points.add(p3);
                points.add(p4);
                points.add(p5);
                break;
            }
            case PENTAGRAM: {
                if (this.pentagram.isEmpty()) {
                    this.pentagram = this.makePentagram(this.pentagram);
                }
                double width = endX - startX;
                double height = endY - startY;
                for (CanvasPoint g : this.pentagram) {
                    points.add(new CanvasPoint(startX + width * g.getX(), startY + height * g.getY()));
                }
                break;
            }
            case ISOGRAM: {
                if (this.pentagram.isEmpty()) {
                    this.pentagram = this.makePentagram(this.pentagram);
                }
                double width = endX - startX;
                double height = endY - startY;
                double maxLength = Math.max(Math.abs(width), Math.abs(height));
                for (CanvasPoint g : this.pentagram) {
                    points.add(new CanvasPoint(startX + maxLength * Math.signum(width) * g.getX(), startY + maxLength * Math.signum(height) * g.getY()));
                }
                break;
            }
            case POLYGON: 
            case CURVE: 
            case SKETCH: {
                break;
            }
        }
        return points;
    }

    private List<CanvasPoint> makePentagram(List<CanvasPoint> gram) {
        double a = 2.0 / (1.0 + Math.sqrt(5.0));
        double j = 1.0 - a * Math.cos(0.3141592653589793);
        double l = a * Math.sin(0.3141592653589793);
        double cx = 0.5;
        double cy = a / 2.0 * (1.0 - j) / (l + a);
        double ex = l + a * (1.0 + j) / 2.0;
        double ey = 1.0 - j;
        double dx = (a * l * (j - 1.0) - 2.0 * (l + a) * (1.0 - l)) / (a * (j - 1.0) - 2.0 * (1.0 - l));
        double dy = -2.0 / a * dx + 2.0 * (l + a) / a;
        double fx = (1.0 + l - j) / 2.0;
        double fy = 1.0 - j;
        double gx = (a * (l + a) * (j - 1.0) - 2.0 * (l + a) * l) / (a * (j - 1.0) - 2.0 * (l + a));
        double gy = 2.0 / a * gx - 2.0 * l / a;
        CanvasPoint p = new CanvasPoint(l, 0.0);
        CanvasPoint q = new CanvasPoint(l + a, 0.0);
        CanvasPoint r = new CanvasPoint(1.0, 1.0 - j);
        CanvasPoint s = new CanvasPoint(0.5, 1.0);
        CanvasPoint t = new CanvasPoint(0.0, 1.0 - j);
        CanvasPoint c = new CanvasPoint(cx, cy);
        CanvasPoint d = new CanvasPoint(dx, dy);
        CanvasPoint e = new CanvasPoint(ex, ey);
        CanvasPoint f = new CanvasPoint(fx, fy);
        CanvasPoint g = new CanvasPoint(gx, gy);
        gram.add(p);
        gram.add(c);
        gram.add(q);
        gram.add(d);
        gram.add(r);
        gram.add(e);
        gram.add(s);
        gram.add(f);
        gram.add(t);
        gram.add(g);
        for (CanvasPoint z : gram) {
            z.y = 1.0 - z.y;
        }
        return gram;
    }
}

