/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import java.util.ListIterator;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.PathFactory;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.Spline;
import org.jhotdraw.geom.Bezier;

public class FigurePathFactory
implements PathFactory {
    Path2D.Double path;

    @Override
    public Path2D.Double createPath(Figure figure) {
        this.path = new Path2D.Double();
        List<CanvasPoint> points = figure.getPoints();
        switch (figure.getType()) {
            case LINE: {
                if (points.size() > 1) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    this.path.lineTo(points.get((int)1).x, points.get((int)1).y);
                    break;
                }
                return null;
            }
            case CIRCLE: 
            case SQUARE: {
                if (points.size() > 3) {
                    double h = 0.0;
                    double w = 0.0;
                    double y = 0.0;
                    double x = 0.0;
                    CanvasPoint p0 = points.get(0);
                    CanvasPoint p1 = points.get(1);
                    CanvasPoint p2 = points.get(2);
                    CanvasPoint p3 = points.get(3);
                    if (p0.x < p2.x && p0.y < p2.y) {
                        x = p0.x;
                        y = p0.y;
                        w = p2.x - x;
                        h = p2.y - y;
                    } else if (p0.x > p2.x && p0.y > p2.y) {
                        x = p2.x;
                        y = p2.y;
                        w = p0.x - x;
                        h = p0.y - y;
                    } else if (p3.x > p1.x && p3.y > p1.y) {
                        x = p1.x;
                        y = p1.y;
                        w = p3.x - x;
                        h = p3.y - y;
                    } else if (p3.x < p1.x && p3.y < p1.y) {
                        x = p3.x;
                        y = p3.y;
                        w = p1.x - x;
                        h = p1.y - y;
                    }
                    if (figure.getType().equals((Object)FigureType.CIRCLE)) {
                        this.path = new Path2D.Double(new Ellipse2D.Double(x, y, w, h));
                        break;
                    }
                    this.path = new Path2D.Double(new RoundRectangle2D.Double(x, y, w, h, 5.0, 5.0));
                    break;
                }
                return null;
            }
            case TRIANGLE: {
                if (points.size() > 2) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    this.path.lineTo(points.get((int)1).x, points.get((int)1).y);
                    this.path.lineTo(points.get((int)2).x, points.get((int)2).y);
                    this.path.closePath();
                    break;
                }
                return null;
            }
            case HEXAGON: {
                if (points.size() > 5) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    this.path.lineTo(points.get((int)1).x, points.get((int)1).y);
                    this.path.lineTo(points.get((int)2).x, points.get((int)2).y);
                    this.path.lineTo(points.get((int)3).x, points.get((int)3).y);
                    this.path.lineTo(points.get((int)4).x, points.get((int)4).y);
                    this.path.lineTo(points.get((int)5).x, points.get((int)5).y);
                    this.path.closePath();
                    break;
                }
                return null;
            }
            case PENTAGRAM: {
                if (points.size() > 8) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    this.path.lineTo(points.get((int)1).x, points.get((int)1).y);
                    this.path.lineTo(points.get((int)2).x, points.get((int)2).y);
                    this.path.lineTo(points.get((int)3).x, points.get((int)3).y);
                    this.path.lineTo(points.get((int)4).x, points.get((int)4).y);
                    this.path.lineTo(points.get((int)5).x, points.get((int)5).y);
                    this.path.lineTo(points.get((int)6).x, points.get((int)6).y);
                    this.path.lineTo(points.get((int)7).x, points.get((int)7).y);
                    this.path.lineTo(points.get((int)8).x, points.get((int)8).y);
                    this.path.lineTo(points.get((int)9).x, points.get((int)9).y);
                    this.path.closePath();
                    break;
                }
                return null;
            }
            case CURVE: {
                if (points.size() < 2) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    break;
                }
                if (points.size() < 3) {
                    this.path.moveTo(points.get((int)0).x, points.get((int)0).y);
                    this.path.lineTo(points.get((int)1).x, points.get((int)1).y);
                    break;
                }
                List<CanvasPoint> controlpoints = Spline.getControlPoints(points);
                ListIterator<CanvasPoint> iterator = points.listIterator();
                int i = 0;
                CanvasPoint p1 = (CanvasPoint)iterator.next();
                this.path.moveTo(p1.x, p1.y);
                while (iterator.hasNext()) {
                    CanvasPoint p2 = (CanvasPoint)iterator.next();
                    CanvasPoint cp1 = controlpoints.get(i);
                    CanvasPoint cp2 = controlpoints.get(i + 1);
                    this.path.curveTo(cp1.x, cp1.y, cp2.x, cp2.y, p2.x, p2.y);
                    i += 2;
                }
                break;
            }
            case SKETCH: {
                CanvasPoint[] cPoints = new CanvasPoint[points.size()];
                points.toArray(cPoints);
                this.path = Bezier.fitBezierPath(cPoints, 0.75).toGeneralPath();
                break;
            }
            case POLYGON: {
                CanvasPoint[] cPoints = new CanvasPoint[points.size()];
                points.toArray(cPoints);
                this.path = Bezier.fitBezierPath(cPoints, 0.75).toGeneralPath();
                this.path.closePath();
                break;
            }
            case VECTOR: {
                if (figure.getPath() == null) break;
                this.path = figure.getPath();
                break;
            }
            default: {
                return this.path;
            }
        }
        return this.path;
    }
}

