/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.geom.Edge;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureFactory;
import net.perspective.draw.geom.FigureType;

public class FigureFactoryImpl
implements FigureFactory {
    @Override
    public Figure createFigure(DrawingType drawType) {
        Figure drawItem = switch (drawType) {
            case DrawingType.POINT, DrawingType.LINE, DrawingType.HORIZONTAL, DrawingType.VERTICAL -> new Edge(FigureType.LINE);
            case DrawingType.CIRCLE, DrawingType.ELLIPSE -> new Figure(FigureType.CIRCLE);
            case DrawingType.SQUARE, DrawingType.RECTANGLE -> new Figure(FigureType.SQUARE);
            case DrawingType.TRIANGLE, DrawingType.ISOSCELES -> new Figure(FigureType.TRIANGLE);
            case DrawingType.HEXAGON, DrawingType.ISOHEX -> new Figure(FigureType.HEXAGON);
            case DrawingType.PENTAGRAM, DrawingType.ISOGRAM -> new Figure(FigureType.PENTAGRAM);
            case DrawingType.POLYGON -> new Edge(FigureType.POLYGON);
            case DrawingType.CURVE -> new Edge(FigureType.CURVE);
            case DrawingType.SKETCH -> new Edge(FigureType.SKETCH);
            default -> new Figure();
        };
        return drawItem;
    }
}

